/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.architecturemodelgenerator.core.generators.entity;

import io.ballerina.architecturemodelgenerator.core.Constants;
import io.ballerina.architecturemodelgenerator.core.diagnostics.ArchitectureModelDiagnostic;
import io.ballerina.architecturemodelgenerator.core.diagnostics.DiagnosticMessage;
import io.ballerina.architecturemodelgenerator.core.diagnostics.DiagnosticNode;
import io.ballerina.architecturemodelgenerator.core.generators.GeneratorUtils;
import io.ballerina.architecturemodelgenerator.core.generators.ModelGenerator;
import io.ballerina.architecturemodelgenerator.core.generators.entity.nodevisitors.TypeDefinitionNodeVisitor;
import io.ballerina.architecturemodelgenerator.core.model.SourceLocation;
import io.ballerina.architecturemodelgenerator.core.model.entity.Association;
import io.ballerina.architecturemodelgenerator.core.model.entity.Attribute;
import io.ballerina.architecturemodelgenerator.core.model.entity.Entity;
import io.ballerina.compiler.api.symbols.ArrayTypeSymbol;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.NilTypeSymbol;
import io.ballerina.compiler.api.symbols.RecordFieldSymbol;
import io.ballerina.compiler.api.symbols.RecordTypeSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDefinitionSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.ArrayTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.BasicLiteralNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingFieldNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.RecordFieldNode;
import io.ballerina.compiler.syntax.tree.RecordFieldWithDefaultValueNode;
import io.ballerina.compiler.syntax.tree.RecordTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SpecificFieldNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.Module;
import io.ballerina.projects.Package;
import io.ballerina.projects.PackageCompilation;
import io.ballerina.tools.diagnostics.Location;
import io.ballerina.tools.text.LineRange;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class EntityModelGenerator
extends ModelGenerator {
    private final Map<String, Entity> types = new HashMap<String, Entity>();

    public EntityModelGenerator(PackageCompilation packageCompilation, Module module) {
        super(packageCompilation, module);
    }

    public Map<String, Entity> generate() {
        HashMap recordTypeDescNodes = new HashMap();
        for (DocumentId documentId : this.getModule().documentIds()) {
            SyntaxTree syntaxTree = this.getModule().document(documentId).syntaxTree();
            TypeDefinitionNodeVisitor typeDefNodeVisitor = new TypeDefinitionNodeVisitor();
            syntaxTree.rootNode().accept((NodeVisitor)typeDefNodeVisitor);
            typeDefNodeVisitor.getRecordTypeDescNodes().forEach(recordTypeDescNodes::putIfAbsent);
        }
        List symbols = this.getSemanticModel().moduleSymbols();
        for (Symbol symbol : symbols) {
            TypeDefinitionSymbol typeDefinitionSymbol;
            if (!symbol.kind().equals((Object)SymbolKind.TYPE_DEFINITION) || !((typeDefinitionSymbol = (TypeDefinitionSymbol)symbol).typeDescriptor() instanceof RecordTypeSymbol)) continue;
            String entityName = this.getEntityName(typeDefinitionSymbol.moduleQualifiedName());
            RecordTypeSymbol recordTypeSymbol = (RecordTypeSymbol)typeDefinitionSymbol.typeDescriptor();
            RecordTypeDescriptorNode recordTypeDescNode = typeDefinitionSymbol.getName().isPresent() ? (RecordTypeDescriptorNode)recordTypeDescNodes.get(typeDefinitionSymbol.getName().get()) : null;
            this.types.put(entityName, this.getType(recordTypeSymbol, recordTypeDescNode, entityName, this.getElementLocation((Symbol)typeDefinitionSymbol), false));
        }
        return this.types;
    }

    private Entity getType(RecordTypeSymbol recordTypeSymbol, RecordTypeDescriptorNode recordNode, String entityName, SourceLocation elementLocation, boolean isAnonymous) {
        ArrayList<Attribute> attributeList = new ArrayList<Attribute>();
        ArrayList<String> inclusionList = new ArrayList<String>();
        Map<String, RecordFieldSymbol> recordFieldSymbolMap = this.getOriginalFieldMap(recordTypeSymbol, inclusionList, entityName);
        ArrayList<ArchitectureModelDiagnostic> diagnostics = new ArrayList<ArchitectureModelDiagnostic>();
        for (RecordFieldSymbol recordFieldSymbol : recordFieldSymbolMap.values()) {
            Node recordFieldNode = null;
            if (recordFieldSymbol.getName().isPresent() && recordNode != null) {
                recordFieldNode = recordNode.fields().stream().filter(node -> {
                    if (node.kind().equals((Object)SyntaxKind.RECORD_FIELD) && ((RecordFieldNode)node).fieldName().text().equals(recordFieldSymbol.getName().get())) {
                        return true;
                    }
                    return node.kind().equals((Object)SyntaxKind.RECORD_FIELD_WITH_DEFAULT_VALUE) && ((RecordFieldWithDefaultValueNode)node).fieldName().text().equals(recordFieldSymbol.getName().get());
                }).findFirst().orElse(null);
            }
            if (recordFieldNode == null) {
                DiagnosticMessage message = DiagnosticMessage.failedToGenerate(DiagnosticNode.ENTITIES, "Could not find the field named " + (String)recordFieldSymbol.getName().get() + ".");
                ArchitectureModelDiagnostic diagnostic = new ArchitectureModelDiagnostic(message.getCode(), message.getDescription(), message.getSeverity(), null, null);
                diagnostics.add(diagnostic);
                continue;
            }
            attributeList.add(this.getAttribute(recordFieldSymbol, recordFieldNode, entityName));
        }
        return new Entity(attributeList, inclusionList, isAnonymous, elementLocation, diagnostics);
    }

    private Attribute getAttribute(RecordFieldSymbol recordFieldSymbol, Node recordFieldNode, String entityName) {
        List<Association> associations;
        Node typeName;
        TypeDescKind fieldTypeDescKind = recordFieldSymbol.typeDescriptor().typeKind();
        TypeSymbol fieldTypeSymbol = recordFieldSymbol.typeDescriptor();
        String fieldName = (String)recordFieldSymbol.getName().get();
        Object fieldType = recordFieldSymbol.typeDescriptor().signature();
        boolean optional = recordFieldSymbol.isOptional();
        String defaultValue = "";
        boolean nillable = this.isNillable(recordFieldSymbol.typeDescriptor());
        String inlineRecordName = entityName + fieldName.substring(0, 1).toUpperCase(Locale.ROOT) + fieldName.substring(1);
        boolean isReadOnly = recordFieldNode.kind().equals((Object)SyntaxKind.RECORD_FIELD) ? ((RecordFieldNode)recordFieldNode).readonlyKeyword().isPresent() : ((RecordFieldWithDefaultValueNode)recordFieldNode).readonlyKeyword().isPresent();
        Node node = typeName = recordFieldNode.kind().equals((Object)SyntaxKind.RECORD_FIELD) ? ((RecordFieldNode)recordFieldNode).typeName() : ((RecordFieldWithDefaultValueNode)recordFieldNode).typeName();
        if (fieldTypeDescKind.equals((Object)TypeDescKind.RECORD)) {
            RecordTypeSymbol inlineRecordTypeSymbol = (RecordTypeSymbol)fieldTypeSymbol;
            fieldType = TypeDescKind.RECORD.getName();
            RecordTypeDescriptorNode recordTypeDescNode = (RecordTypeDescriptorNode)typeName;
            this.types.put(inlineRecordName, this.getType(inlineRecordTypeSymbol, recordTypeDescNode, inlineRecordName, this.getElementLocation((Symbol)recordFieldSymbol), true));
            String associateCardinality = optional ? Constants.CardinalityValue.ZERO_OR_ONE.getValue() : Constants.CardinalityValue.ONE_AND_ONLY_ONE.getValue();
            Association association = new Association(inlineRecordName, new Association.Cardinality(Constants.CardinalityValue.ONE_AND_ONLY_ONE.getValue(), associateCardinality));
            associations = new LinkedList<Association>(List.of(association));
        } else if (fieldTypeDescKind.equals((Object)TypeDescKind.ARRAY) && this.getInlineRecordTypeSymbol((ArrayTypeSymbol)fieldTypeSymbol).isPresent()) {
            RecordTypeSymbol inlineRecordTypeSymbol = this.getInlineRecordTypeSymbol((ArrayTypeSymbol)fieldTypeSymbol).get();
            int arraySize = ((ArrayTypeDescriptorNode)typeName).dimensions().size();
            fieldType = TypeDescKind.RECORD.getName() + "[]".repeat(arraySize);
            RecordTypeDescriptorNode recordTypeDescNode = (RecordTypeDescriptorNode)((ArrayTypeDescriptorNode)typeName).memberTypeDesc();
            this.types.put(inlineRecordName, this.getType(inlineRecordTypeSymbol, recordTypeDescNode, inlineRecordName, this.getElementLocation((Symbol)recordFieldSymbol), true));
            List<String> associateCardinalities = this.getArrayAssociateCardinalities(recordFieldNode);
            LinkedList<Association> associationsTemp = new LinkedList<Association>();
            associateCardinalities.forEach(associationCardinality -> {
                Association association = new Association(inlineRecordName, new Association.Cardinality(Constants.CardinalityValue.ONE_AND_ONLY_ONE.getValue(), (String)associationCardinality));
                associationsTemp.add(association);
            });
            associations = associationsTemp;
        } else {
            associations = this.getAssociations(fieldTypeSymbol, recordFieldNode, entityName, optional, nillable);
        }
        return new Attribute(fieldName, (String)fieldType, optional, nillable, defaultValue, associations, isReadOnly, this.getElementLocation((Symbol)recordFieldSymbol), Collections.emptyList());
    }

    private Optional<RecordTypeSymbol> getInlineRecordTypeSymbol(ArrayTypeSymbol arrayTypeSymbol) {
        if (arrayTypeSymbol.memberTypeDescriptor().typeKind().equals((Object)TypeDescKind.RECORD)) {
            return Optional.of((RecordTypeSymbol)arrayTypeSymbol.memberTypeDescriptor());
        }
        if (arrayTypeSymbol.memberTypeDescriptor().typeKind().equals((Object)TypeDescKind.ARRAY)) {
            return this.getInlineRecordTypeSymbol((ArrayTypeSymbol)arrayTypeSymbol.memberTypeDescriptor());
        }
        return Optional.empty();
    }

    private Map<String, RecordFieldSymbol> getOriginalFieldMap(RecordTypeSymbol recordTypeSymbol, List<String> inclusionList, String entityName) {
        Map<String, RecordFieldSymbol> childRecordFieldSymbolMap = recordTypeSymbol.fieldDescriptors();
        if (!recordTypeSymbol.typeInclusions().isEmpty()) {
            List typeInclusions = recordTypeSymbol.typeInclusions();
            for (TypeSymbol includedType : typeInclusions) {
                if (!(includedType instanceof TypeReferenceTypeSymbol)) continue;
                TypeReferenceTypeSymbol typeReferenceTypeSymbol = (TypeReferenceTypeSymbol)includedType;
                inclusionList.add(this.getAssociateEntityName(typeReferenceTypeSymbol, entityName));
                RecordTypeSymbol parentRecordTypeSymbol = (RecordTypeSymbol)typeReferenceTypeSymbol.typeDescriptor();
                Map parentRecordFieldSymbolMap = parentRecordTypeSymbol.fieldDescriptors();
                childRecordFieldSymbolMap = childRecordFieldSymbolMap.entrySet().stream().filter(entry -> !parentRecordFieldSymbolMap.containsKey(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            }
        }
        return childRecordFieldSymbolMap;
    }

    private boolean isNillable(TypeSymbol fieldTypeDescriptor) {
        boolean isNillable = false;
        if (fieldTypeDescriptor instanceof UnionTypeSymbol) {
            UnionTypeSymbol unionTypeSymbol = (UnionTypeSymbol)fieldTypeDescriptor;
            List memberTypeDescriptors = unionTypeSymbol.memberTypeDescriptors();
            isNillable = memberTypeDescriptors.stream().anyMatch(m -> m instanceof NilTypeSymbol);
        }
        return isNillable;
    }

    private String getSelfCardinality(TypeSymbol typeSymbol, String entityName) {
        String selfCardinality = Constants.CardinalityValue.ONE_AND_ONLY_ONE.getValue();
        if (typeSymbol instanceof TypeReferenceTypeSymbol && ((TypeReferenceTypeSymbol)typeSymbol).typeDescriptor() instanceof RecordTypeSymbol) {
            RecordTypeSymbol recordTypeSymbol = (RecordTypeSymbol)((TypeReferenceTypeSymbol)typeSymbol).typeDescriptor();
            Map recordFieldSymbolMap = recordTypeSymbol.fieldDescriptors();
            for (Map.Entry fieldEntry : recordFieldSymbolMap.entrySet()) {
                TypeSymbol memberTypeDescriptor;
                TypeSymbol fieldTypeDescriptor = ((RecordFieldSymbol)fieldEntry.getValue()).typeDescriptor();
                if (fieldTypeDescriptor instanceof TypeReferenceTypeSymbol) {
                    if (!entityName.equals(this.getAssociateEntityName((TypeReferenceTypeSymbol)fieldTypeDescriptor, entityName))) continue;
                    selfCardinality = Constants.CardinalityValue.ONE_AND_ONLY_ONE.getValue();
                    continue;
                }
                if (fieldTypeDescriptor instanceof UnionTypeSymbol) {
                    boolean isFound = false;
                    boolean isNull = false;
                    UnionTypeSymbol unionTypeSymbol = (UnionTypeSymbol)fieldTypeDescriptor;
                    List memberTypeDescriptors = unionTypeSymbol.memberTypeDescriptors();
                    for (TypeSymbol memberTypeSymbol : memberTypeDescriptors) {
                        if (memberTypeSymbol instanceof TypeReferenceTypeSymbol && entityName.equals(this.getAssociateEntityName((TypeReferenceTypeSymbol)memberTypeSymbol, entityName))) {
                            isFound = true;
                            continue;
                        }
                        if (!(memberTypeSymbol instanceof NilTypeSymbol)) continue;
                        isNull = true;
                    }
                    if (!isFound || !isNull) continue;
                    selfCardinality = Constants.CardinalityValue.ZERO_OR_ONE.getValue();
                    continue;
                }
                if (!(fieldTypeDescriptor instanceof ArrayTypeSymbol) || !((memberTypeDescriptor = ((ArrayTypeSymbol)fieldTypeDescriptor).memberTypeDescriptor()) instanceof TypeReferenceTypeSymbol) || !this.getAssociateEntityName((TypeReferenceTypeSymbol)memberTypeDescriptor, entityName).replace("[]", "").equals(entityName)) continue;
                selfCardinality = Constants.CardinalityValue.ZERO_OR_MANY.getValue();
            }
        }
        return selfCardinality;
    }

    private String getAssociateCardinality(boolean isArray, boolean isOptional, boolean isNillable) {
        if (isArray) {
            return Constants.CardinalityValue.ZERO_OR_MANY.getValue();
        }
        if (isOptional || isNillable) {
            return Constants.CardinalityValue.ZERO_OR_ONE.getValue();
        }
        return Constants.CardinalityValue.ONE_AND_ONLY_ONE.getValue();
    }

    private List<String> getArrayAssociateCardinalities(Node recordFieldNode) {
        Optional metadata = recordFieldNode.kind().equals((Object)SyntaxKind.RECORD_FIELD) ? ((RecordFieldNode)recordFieldNode).metadata() : ((RecordFieldWithDefaultValueNode)recordFieldNode).metadata();
        LinkedList<String> associateCardinalities = new LinkedList<String>();
        if (metadata.isPresent()) {
            for (AnnotationNode annotationNode : ((MetadataNode)metadata.get()).annotations()) {
                QualifiedNameReferenceNode annotRef;
                if (!annotationNode.annotReference().kind().equals((Object)SyntaxKind.QUALIFIED_NAME_REFERENCE) || !(annotRef = (QualifiedNameReferenceNode)annotationNode.annotReference()).modulePrefix().text().equals("constraint") || !annotRef.identifier().text().equals("Array") || !annotationNode.annotValue().isPresent()) continue;
                String minLength = Constants.CardinalityValue.ZERO.getValue();
                String maxLength = Constants.CardinalityValue.MANY.getValue();
                for (MappingFieldNode annotValField : ((MappingConstructorExpressionNode)annotationNode.annotValue().get()).fields()) {
                    if (!((SpecificFieldNode)annotValField).fieldName().kind().equals((Object)SyntaxKind.IDENTIFIER_TOKEN) || !((SpecificFieldNode)annotValField).valueExpr().isPresent() || !((ExpressionNode)((SpecificFieldNode)annotValField).valueExpr().get()).kind().equals((Object)SyntaxKind.NUMERIC_LITERAL)) continue;
                    if (((IdentifierToken)((SpecificFieldNode)annotValField).fieldName()).text().equals("minLength")) {
                        minLength = ((BasicLiteralNode)((SpecificFieldNode)annotValField).valueExpr().get()).literalToken().text();
                        continue;
                    }
                    if (!((IdentifierToken)((SpecificFieldNode)annotValField).fieldName()).text().equals("maxLength")) continue;
                    maxLength = ((BasicLiteralNode)((SpecificFieldNode)annotValField).valueExpr().get()).literalToken().text();
                }
                associateCardinalities.add(Constants.CardinalityValue.CUSTOM.getCustomValue(minLength, maxLength));
            }
        }
        if (associateCardinalities.size() > 0) {
            return associateCardinalities;
        }
        return new LinkedList<String>(List.of(Constants.CardinalityValue.ZERO_OR_MANY.getValue()));
    }

    private String getEntityName(String moduleQualifiedName) {
        Package pkg = this.getModule().packageInstance();
        String[] nameSpits = moduleQualifiedName.split(":");
        String entityName = pkg.packageName().value().equals(nameSpits[0]) ? pkg.packageOrg().value() + "/" + pkg.packageName().value() + ":" + String.valueOf(pkg.packageVersion().value()) + ":" + nameSpits[1] : pkg.packageOrg().value() + "/" + pkg.packageName().value() + ":" + nameSpits[0] + ":" + String.valueOf(pkg.packageVersion().value()) + ":" + nameSpits[1];
        return entityName;
    }

    private List<Association> getAssociationsInUnionTypes(UnionTypeSymbol unionTypeSymbol, String entityName, boolean isRequired) {
        ArrayList<Association> unionTypeAssociations = new ArrayList<Association>();
        List memberTypeDescriptors = unionTypeSymbol.memberTypeDescriptors();
        boolean isNullableAssociate = memberTypeDescriptors.stream().anyMatch(m -> m instanceof NilTypeSymbol);
        for (TypeSymbol typeSymbol : memberTypeDescriptors) {
            if (typeSymbol instanceof NilTypeSymbol) continue;
            List<Association> associations = this.getAssociations(typeSymbol, null, entityName, isRequired, isNullableAssociate);
            unionTypeAssociations.addAll(associations);
        }
        return unionTypeAssociations;
    }

    private String getAssociateEntityName(TypeReferenceTypeSymbol typeReferenceTypeSymbol, String referencedPackageName) {
        String referenceType = typeReferenceTypeSymbol.signature();
        if (typeReferenceTypeSymbol.getModule().isPresent() && !referenceType.split(":")[0].equals(referencedPackageName.split(":")[0])) {
            String orgName = ((ModuleSymbol)typeReferenceTypeSymbol.getModule().get()).id().orgName();
            String packageName = ((ModuleSymbol)typeReferenceTypeSymbol.getModule().get()).id().packageName();
            String modulePrefix = ((ModuleSymbol)typeReferenceTypeSymbol.getModule().get()).id().modulePrefix();
            String recordName = (String)typeReferenceTypeSymbol.getName().get();
            String version = ((ModuleSymbol)typeReferenceTypeSymbol.getModule().get()).id().version();
            referenceType = packageName.equals(modulePrefix) ? String.format("%s/%s:%s:%s", orgName, packageName, version, recordName) : String.format("%s/%s:%s:%s:%s", orgName, packageName, modulePrefix, version, recordName);
        }
        return referenceType;
    }

    private List<Association> getAssociations(TypeSymbol fieldTypeDescriptor, Node recordFieldNode, String entityName, boolean optional, boolean isNillable) {
        ArrayList<Association> associations = new ArrayList<Association>();
        if (fieldTypeDescriptor instanceof TypeReferenceTypeSymbol) {
            String associate = this.getAssociateEntityName((TypeReferenceTypeSymbol)fieldTypeDescriptor, entityName);
            Association.Cardinality cardinality = new Association.Cardinality(this.getSelfCardinality(fieldTypeDescriptor, entityName), this.getAssociateCardinality(false, optional, isNillable));
            associations.add(new Association(associate, cardinality));
        } else if (fieldTypeDescriptor instanceof UnionTypeSymbol) {
            UnionTypeSymbol unionTypeSymbol = (UnionTypeSymbol)fieldTypeDescriptor;
            associations.addAll(this.getAssociationsInUnionTypes(unionTypeSymbol, entityName, optional));
        } else if (fieldTypeDescriptor instanceof ArrayTypeSymbol) {
            ArrayTypeSymbol arrayTypeSymbol = (ArrayTypeSymbol)fieldTypeDescriptor;
            if (arrayTypeSymbol.memberTypeDescriptor() instanceof TypeReferenceTypeSymbol) {
                String associate = this.getAssociateEntityName((TypeReferenceTypeSymbol)arrayTypeSymbol.memberTypeDescriptor(), entityName).replace("[]", "");
                List<String> associateCardinalities = this.getArrayAssociateCardinalities(recordFieldNode);
                associateCardinalities.forEach(associationCardinality -> {
                    Association.Cardinality cardinality = new Association.Cardinality(this.getSelfCardinality((TypeSymbol)arrayTypeSymbol, entityName), (String)associationCardinality);
                    associations.add(new Association(associate, cardinality));
                });
            } else {
                associations.addAll(this.getAssociations(arrayTypeSymbol.memberTypeDescriptor(), recordFieldNode, entityName, optional, isNillable));
            }
        }
        return associations;
    }

    private SourceLocation getElementLocation(Symbol symbol) {
        SourceLocation elementLocation = null;
        if (symbol.getLocation().isPresent()) {
            LineRange typeLineRange = ((Location)symbol.getLocation().get()).lineRange();
            String filePath = Files.isDirectory(this.getModuleRootPath(), new LinkOption[0]) ? this.getModuleRootPath().resolve(typeLineRange.filePath()).toAbsolutePath().toString() : this.getModuleRootPath().toString();
            elementLocation = GeneratorUtils.getSourceLocation(filePath, typeLineRange);
        }
        return elementLocation;
    }
}

