/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.artifactsgenerator;

import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class ArtifactGenerationDebouncer {
    private static final long DEFAULT_DELAY = 500L;
    private static final TimeUnit TIME_UNIT = TimeUnit.MILLISECONDS;
    private final ConcurrentHashMap<String, ScheduledTaskHolder> delayedMap;
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();

    private ArtifactGenerationDebouncer() {
        this.delayedMap = new ConcurrentHashMap();
    }

    public void debounce(String key, Runnable task) {
        this.debounce(key, task, 500L);
    }

    public void debounce(String key, Runnable task, long delay) {
        CompletableFuture<Void> promise = new CompletableFuture<Void>();
        ScheduledFuture<?> scheduledFuture = this.scheduler.schedule(() -> {
            try {
                task.run();
                promise.complete(null);
            }
            catch (Exception ex) {
                promise.completeExceptionally(ex);
            }
            finally {
                this.delayedMap.remove(key);
            }
        }, delay, TIME_UNIT);
        ScheduledTaskHolder prev = this.delayedMap.put(key, new ScheduledTaskHolder(promise, scheduledFuture));
        if (prev != null) {
            prev.future.cancel(true);
            prev.promise.completeExceptionally(new CancellationException("Debounced by a new request"));
        }
    }

    public static ArtifactGenerationDebouncer getInstance() {
        return Holder.INSTANCE;
    }

    private record ScheduledTaskHolder(CompletableFuture<Void> promise, Future<?> future) {
    }

    private static class Holder {
        private static final ArtifactGenerationDebouncer INSTANCE = new ArtifactGenerationDebouncer();

        private Holder() {
        }
    }
}

