/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.artifactsgenerator;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ArtifactsCache {
    private static ArtifactsCache instance;
    private final ConcurrentMap<String, ConcurrentMap<String, Map<String, List<String>>>> projectCache = new ConcurrentHashMap<String, ConcurrentMap<String, Map<String, List<String>>>>();
    private final ConcurrentMap<String, Lock> locks = new ConcurrentHashMap<String, Lock>();

    private ArtifactsCache() {
    }

    public static void initialize() {
        instance = new ArtifactsCache();
    }

    public static ArtifactsCache getInstance() {
        return instance;
    }

    private Lock getOrCreateLock(String projectId, String fileUri) {
        String lockKey = projectId + ":" + fileUri;
        return this.locks.computeIfAbsent(lockKey, k -> new ReentrantLock());
    }

    public boolean hasInitialized(String projectId) {
        return this.projectCache.containsKey(projectId);
    }

    public void initializeProject(String projectId, ConcurrentMap<String, Map<String, List<String>>> documentMap) {
        this.projectCache.put(projectId, documentMap);
    }

    public Map<String, List<String>> getArtifactIds(String projectId, String fileUri) {
        Lock lock = this.getOrCreateLock(projectId, fileUri);
        lock.lock();
        ConcurrentMap documentMap = (ConcurrentMap)this.projectCache.get(projectId);
        if (documentMap == null) {
            return Collections.emptyMap();
        }
        Map artifactIds = (Map)documentMap.get(fileUri);
        if (artifactIds == null) {
            return Collections.emptyMap();
        }
        return artifactIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateArtifactIds(String projectId, String fileUri, Map<String, List<String>> artifactIds) {
        try {
            ConcurrentMap documentMap = this.projectCache.computeIfAbsent(projectId, k -> new ConcurrentHashMap());
            documentMap.put(fileUri, artifactIds);
        }
        finally {
            Lock lock = this.getOrCreateLock(projectId, fileUri);
            lock.unlock();
        }
    }
}

