/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.designmodelgenerator.core;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.AnnotationAttachmentSymbol;
import io.ballerina.compiler.api.symbols.AnnotationSymbol;
import io.ballerina.compiler.api.symbols.ClassSymbol;
import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.FunctionTypeSymbol;
import io.ballerina.compiler.api.symbols.MethodSymbol;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.ParameterSymbol;
import io.ballerina.compiler.api.symbols.Qualifier;
import io.ballerina.compiler.api.symbols.ResourceMethodSymbol;
import io.ballerina.compiler.api.symbols.ServiceDeclarationSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.VariableSymbol;
import io.ballerina.compiler.api.values.ConstantValue;
import io.ballerina.compiler.syntax.tree.AssignmentStatementNode;
import io.ballerina.compiler.syntax.tree.BlockStatementNode;
import io.ballerina.compiler.syntax.tree.CheckExpressionNode;
import io.ballerina.compiler.syntax.tree.ClientResourceAccessActionNode;
import io.ballerina.compiler.syntax.tree.CompoundAssignmentStatementNode;
import io.ballerina.compiler.syntax.tree.DoStatementNode;
import io.ballerina.compiler.syntax.tree.ExplicitNewExpressionNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.ExpressionStatementNode;
import io.ballerina.compiler.syntax.tree.FailStatementNode;
import io.ballerina.compiler.syntax.tree.FieldAccessExpressionNode;
import io.ballerina.compiler.syntax.tree.ForEachStatementNode;
import io.ballerina.compiler.syntax.tree.ForkStatementNode;
import io.ballerina.compiler.syntax.tree.FunctionArgumentNode;
import io.ballerina.compiler.syntax.tree.FunctionBodyBlockNode;
import io.ballerina.compiler.syntax.tree.FunctionCallExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.IfElseStatementNode;
import io.ballerina.compiler.syntax.tree.ImplicitNewExpressionNode;
import io.ballerina.compiler.syntax.tree.ListConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.ListenerDeclarationNode;
import io.ballerina.compiler.syntax.tree.LockStatementNode;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MatchStatementNode;
import io.ballerina.compiler.syntax.tree.MethodCallExpressionNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.ModuleVariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.NameReferenceNode;
import io.ballerina.compiler.syntax.tree.NamedArgumentNode;
import io.ballerina.compiler.syntax.tree.NamedWorkerDeclarationNode;
import io.ballerina.compiler.syntax.tree.NewExpressionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.PanicStatementNode;
import io.ballerina.compiler.syntax.tree.ParenthesizedArgList;
import io.ballerina.compiler.syntax.tree.PositionalArgumentNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.RemoteMethodCallActionNode;
import io.ballerina.compiler.syntax.tree.RetryStatementNode;
import io.ballerina.compiler.syntax.tree.ReturnStatementNode;
import io.ballerina.compiler.syntax.tree.RollbackStatementNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SpecificFieldNode;
import io.ballerina.compiler.syntax.tree.StartActionNode;
import io.ballerina.compiler.syntax.tree.StatementNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.TemplateExpressionNode;
import io.ballerina.compiler.syntax.tree.TransactionStatementNode;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.VariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.WhileStatementNode;
import io.ballerina.designmodelgenerator.core.CommonUtils;
import io.ballerina.designmodelgenerator.core.ConnectionFinder;
import io.ballerina.designmodelgenerator.core.IntermediateModel;
import io.ballerina.designmodelgenerator.core.model.Connection;
import io.ballerina.designmodelgenerator.core.model.DesignGraphNode;
import io.ballerina.designmodelgenerator.core.model.Listener;
import io.ballerina.designmodelgenerator.core.model.Location;
import io.ballerina.tools.text.LineRange;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class CodeAnalyzer
extends NodeVisitor {
    private final SemanticModel semanticModel;
    private final IntermediateModel intermediateModel;
    private IntermediateModel.FunctionModel currentFunctionModel;
    private IntermediateModel.ServiceModel currentServiceModel;
    private final Path rootPath;
    private final ConnectionFinder connectionFinder;

    public CodeAnalyzer(SemanticModel semanticModel, IntermediateModel intermediateModel, Path rootPath, ConnectionFinder connectionFinder) {
        this.semanticModel = semanticModel;
        this.intermediateModel = intermediateModel;
        this.rootPath = rootPath;
        this.connectionFinder = connectionFinder;
    }

    public void visit(ModulePartNode modulePartNode) {
        modulePartNode.members().forEach(member -> member.accept((NodeVisitor)this));
    }

    public void visit(ServiceDeclarationNode serviceDeclarationNode) {
        IntermediateModel.ServiceModel serviceModel;
        Optional serviceSymbol = this.semanticModel.symbol((Node)serviceDeclarationNode);
        String displayName = null;
        if (serviceSymbol.isPresent()) {
            displayName = this.getDisplayName(((ServiceDeclarationSymbol)serviceSymbol.get()).annotAttachments());
        }
        String absoluteResourcePath = String.join((CharSequence)"", serviceDeclarationNode.absoluteResourcePath().stream().map(Node::toSourceCode).toList());
        LineRange lineRange = serviceDeclarationNode.lineRange();
        String sortText = lineRange.fileName() + lineRange.startLine().line();
        this.currentServiceModel = serviceModel = new IntermediateModel.ServiceModel(displayName, absoluteResourcePath, sortText, this.getLocation(lineRange));
        this.intermediateModel.serviceModelMap.put(String.valueOf(lineRange.hashCode()), serviceModel);
        for (ExpressionNode expressionNode : serviceDeclarationNode.expressions()) {
            Object listener;
            Optional symbol;
            if (expressionNode instanceof ExplicitNewExpressionNode) {
                TypeSymbol typeSymbol;
                TypeSymbol rawType;
                Object t;
                ExplicitNewExpressionNode explicitNewExpressionNode = (ExplicitNewExpressionNode)expressionNode;
                List<Listener.KeyValue> arguments = new ArrayList<Listener.KeyValue>();
                symbol = this.semanticModel.symbol((Node)explicitNewExpressionNode.typeDescriptor());
                if (symbol.isPresent() && (t = symbol.get()) instanceof TypeSymbol && (rawType = CommonUtils.getRawType(typeSymbol = (TypeSymbol)t)) instanceof ClassSymbol) {
                    ClassSymbol classSymbol = (ClassSymbol)rawType;
                    arguments = this.getInitMethodParamNames(classSymbol, (SeparatedNodeList<FunctionArgumentNode>)explicitNewExpressionNode.parenthesizedArgList().arguments());
                }
                String icon = symbol.flatMap(Symbol::getModule).map(module -> CommonUtils.generateIcon(module.id())).orElse("");
                listener = new Listener("ANON", sortText, this.getLocation(serviceDeclarationNode.lineRange()), explicitNewExpressionNode.typeDescriptor().toSourceCode(), icon, Listener.Kind.ANON, arguments);
                serviceModel.anonListeners.add((Listener)listener);
                this.intermediateModel.listeners.put(((DesignGraphNode)listener).getUuid(), (Listener)listener);
                continue;
            }
            if (expressionNode instanceof SimpleNameReferenceNode) {
                SimpleNameReferenceNode simpleNameReferenceNode = (SimpleNameReferenceNode)expressionNode;
                serviceModel.namedListeners.add(simpleNameReferenceNode.name().text());
                continue;
            }
            if (!(expressionNode instanceof QualifiedNameReferenceNode)) continue;
            QualifiedNameReferenceNode qualifiedNameReferenceNode = (QualifiedNameReferenceNode)expressionNode;
            String fullQualifiedName = qualifiedNameReferenceNode.modulePrefix().text() + ":" + qualifiedNameReferenceNode.identifier().text();
            if (!this.intermediateModel.listeners.containsKey(fullQualifiedName) && (symbol = this.semanticModel.symbol((Node)qualifiedNameReferenceNode)).isPresent() && (listener = symbol.get()) instanceof VariableSymbol) {
                VariableSymbol variableSymbol = (VariableSymbol)listener;
                TypeSymbol typeSymbol = CommonUtils.getRawType(variableSymbol.typeDescriptor());
                String typeSignature = CommonUtils.getTypeSignature(typeSymbol, CommonUtils.ModuleInfo.from(((ModuleSymbol)typeSymbol.getModule().get()).id()));
                String icon = typeSymbol.getModule().map(module -> CommonUtils.generateIcon(module.id())).orElse("");
                Listener listener2 = new Listener(fullQualifiedName, sortText, this.getLocation(serviceDeclarationNode.lineRange()), typeSignature, icon, Listener.Kind.IMPORTED, new ArrayList<Listener.KeyValue>());
                this.intermediateModel.listeners.put(fullQualifiedName, listener2);
            }
            serviceModel.namedListeners.add(fullQualifiedName);
        }
        serviceDeclarationNode.members().forEach(member -> member.accept((NodeVisitor)this));
        this.currentServiceModel = null;
    }

    public void visit(FunctionDefinitionNode functionDefinitionNode) {
        Object t;
        Optional symbol;
        String functionName = functionDefinitionNode.functionName().text().trim();
        this.currentFunctionModel = new IntermediateModel.FunctionModel(functionName);
        if (this.currentServiceModel != null) {
            symbol = this.semanticModel.symbol((Node)functionDefinitionNode);
            if (symbol.isPresent()) {
                MethodSymbol methodSymbol = (MethodSymbol)symbol.get();
                if (functionDefinitionNode.kind() == SyntaxKind.RESOURCE_ACCESSOR_DEFINITION) {
                    this.currentFunctionModel.path = CommonUtils.getResourcePathStr(this.semanticModel, (ResourceMethodSymbol)methodSymbol);
                    this.currentServiceModel.resourceFunctions.add(this.currentFunctionModel);
                } else if (methodSymbol.qualifiers().contains(Qualifier.REMOTE)) {
                    this.currentServiceModel.remoteFunctions.add(this.currentFunctionModel);
                } else {
                    this.currentServiceModel.otherFunctions.put(functionName, this.currentFunctionModel);
                }
            }
        } else {
            this.intermediateModel.functionModelMap.put(functionDefinitionNode.functionName().text(), this.currentFunctionModel);
        }
        this.currentFunctionModel.location = this.getLocation(functionDefinitionNode.lineRange());
        if (functionName.equals("main") && (symbol = this.semanticModel.symbol((Node)functionDefinitionNode)).isPresent() && (t = symbol.get()) instanceof FunctionSymbol) {
            FunctionSymbol functionSymbol = (FunctionSymbol)t;
            this.currentFunctionModel.displayName = this.getDisplayName(functionSymbol.annotAttachments());
        }
        functionDefinitionNode.functionBody().accept((NodeVisitor)this);
        this.currentFunctionModel = null;
    }

    public void visit(FunctionBodyBlockNode functionBodyBlockNode) {
        for (StatementNode statement : functionBodyBlockNode.statements()) {
            statement.accept((NodeVisitor)this);
        }
        super.visit(functionBodyBlockNode);
    }

    public void visit(DoStatementNode doStatementNode) {
        BlockStatementNode blockStatementNode = doStatementNode.blockStatement();
        blockStatementNode.statements().forEach(statement -> statement.accept((NodeVisitor)this));
        doStatementNode.onFailClause().ifPresent(onFailClauseNode -> onFailClauseNode.blockStatement().statements().forEach(statement -> statement.accept((NodeVisitor)this)));
    }

    public void visit(FunctionCallExpressionNode functionCallExpressionNode) {
        if (!(functionCallExpressionNode.functionName() instanceof QualifiedNameReferenceNode)) {
            if (this.currentFunctionModel != null) {
                this.currentFunctionModel.dependentFuncs.add(functionCallExpressionNode.functionName().toSourceCode().trim());
            }
            functionCallExpressionNode.arguments().forEach(arg -> arg.accept((NodeVisitor)this));
        }
    }

    public void visit(MethodCallExpressionNode methodCallExpressionNode) {
        if (this.currentFunctionModel != null) {
            String methodName = methodCallExpressionNode.methodName().toSourceCode().trim();
            this.currentFunctionModel.dependentObjFuncs.add(methodName);
        }
        methodCallExpressionNode.arguments().forEach(arg -> arg.accept((NodeVisitor)this));
    }

    public void visit(RemoteMethodCallActionNode remoteMethodCallActionNode) {
        this.handleConnectionExpr(remoteMethodCallActionNode.expression());
        remoteMethodCallActionNode.arguments().forEach(arg -> arg.accept((NodeVisitor)this));
    }

    public void visit(ClientResourceAccessActionNode clientResourceAccessActionNode) {
        this.handleConnectionExpr(clientResourceAccessActionNode.expression());
        clientResourceAccessActionNode.arguments().ifPresent(parenthesizedArgList -> parenthesizedArgList.arguments().forEach(expr -> expr.accept((NodeVisitor)this)));
    }

    private void handleConnectionExpr(ExpressionNode expressionNode) {
        if (this.currentFunctionModel != null) {
            if (expressionNode instanceof FieldAccessExpressionNode) {
                FieldAccessExpressionNode fieldAccessExpressionNode = (FieldAccessExpressionNode)expressionNode;
                NameReferenceNode fieldName = fieldAccessExpressionNode.fieldName();
                Optional fieldNameSymbol = this.semanticModel.symbol((Node)fieldName);
                if (fieldNameSymbol.isPresent()) {
                    this.connectionFinder.findConnection((Symbol)fieldNameSymbol.get(), new ArrayList<String>());
                    String hashCode = String.valueOf(((io.ballerina.tools.diagnostics.Location)((Symbol)fieldNameSymbol.get()).getLocation().get()).hashCode());
                    if (this.intermediateModel.connectionMap.containsKey(hashCode)) {
                        Connection connection = this.intermediateModel.connectionMap.get(hashCode);
                        this.currentFunctionModel.connections.add(connection.getUuid());
                    }
                }
            } else {
                Optional symbol = this.semanticModel.symbol((Node)expressionNode);
                if (symbol.isPresent()) {
                    String symbolHash = String.valueOf(((Symbol)symbol.get()).getLocation().hashCode());
                    if (this.intermediateModel.connectionMap.containsKey(symbolHash)) {
                        Connection connection = this.intermediateModel.connectionMap.get(symbolHash);
                        this.currentFunctionModel.connections.add(connection.getUuid());
                    } else {
                        this.connectionFinder.findConnection((Symbol)symbol.get(), new ArrayList<String>());
                        String hashCode = String.valueOf(((io.ballerina.tools.diagnostics.Location)((Symbol)symbol.get()).getLocation().get()).hashCode());
                        if (this.intermediateModel.connectionMap.containsKey(hashCode)) {
                            Connection connection = this.intermediateModel.connectionMap.get(hashCode);
                            this.currentFunctionModel.connections.add(connection.getUuid());
                        }
                    }
                }
            }
        }
    }

    public void visit(ReturnStatementNode returnStatementNode) {
        returnStatementNode.expression().ifPresent(expr -> expr.accept((NodeVisitor)this));
    }

    public void visit(IfElseStatementNode ifElseStatementNode) {
        ifElseStatementNode.condition().accept((NodeVisitor)this);
        ifElseStatementNode.ifBody().statements().forEach(statement -> statement.accept((NodeVisitor)this));
        ifElseStatementNode.elseBody().ifPresent(elseBody -> elseBody.accept((NodeVisitor)this));
    }

    public void visit(ImplicitNewExpressionNode implicitNewExpressionNode) {
        implicitNewExpressionNode.parenthesizedArgList().ifPresent(parenthesizedArgList -> parenthesizedArgList.arguments().forEach(expr -> expr.accept((NodeVisitor)this)));
    }

    public void visit(ExplicitNewExpressionNode explicitNewExpressionNode) {
        explicitNewExpressionNode.parenthesizedArgList().arguments().forEach(expr -> expr.accept((NodeVisitor)this));
    }

    public void visit(TemplateExpressionNode templateExpressionNode) {
        templateExpressionNode.content().forEach(expr -> expr.accept((NodeVisitor)this));
    }

    public void visit(VariableDeclarationNode variableDeclarationNode) {
        variableDeclarationNode.initializer().ifPresent(expr -> expr.accept((NodeVisitor)this));
    }

    public void visit(ListenerDeclarationNode listenerDeclarationNode) {
        ArrayList<Listener.KeyValue> arguments = new ArrayList();
        Optional symbol = this.semanticModel.symbol((Node)listenerDeclarationNode.typeDescriptor().get());
        Node initializer = listenerDeclarationNode.initializer();
        if (initializer instanceof NewExpressionNode) {
            TypeSymbol typeSymbol;
            TypeSymbol rawType;
            Object t;
            NewExpressionNode newExpressionNode = (NewExpressionNode)initializer;
            if (symbol.isPresent() && (t = symbol.get()) instanceof TypeSymbol && (rawType = CommonUtils.getRawType(typeSymbol = (TypeSymbol)t)) instanceof ClassSymbol) {
                ClassSymbol classSymbol = (ClassSymbol)rawType;
                arguments = this.getInitMethodParamNames(classSymbol, this.getArgList(newExpressionNode));
            }
        }
        String icon = symbol.flatMap(Symbol::getModule).map(module -> CommonUtils.generateIcon(module.id())).orElse("");
        LineRange lineRange = listenerDeclarationNode.lineRange();
        String sortText = lineRange.fileName() + lineRange.startLine().line();
        this.intermediateModel.listeners.put(listenerDeclarationNode.variableName().text(), new Listener(listenerDeclarationNode.variableName().text(), sortText, this.getLocation(listenerDeclarationNode.lineRange()), ((TypeDescriptorNode)listenerDeclarationNode.typeDescriptor().get()).toSourceCode().strip(), icon, Listener.Kind.NAMED, arguments, true));
    }

    public void visit(ModuleVariableDeclarationNode moduleVariableDeclarationNode) {
        io.ballerina.tools.diagnostics.Location location;
        String hashCode;
        moduleVariableDeclarationNode.initializer().ifPresent(expr -> expr.accept((NodeVisitor)this));
        Optional symbol = this.semanticModel.symbol((Node)moduleVariableDeclarationNode);
        if (symbol.isPresent() && this.intermediateModel.connectionMap.containsKey(hashCode = String.valueOf((location = (io.ballerina.tools.diagnostics.Location)((Symbol)symbol.get()).getLocation().get()).hashCode()))) {
            Connection connection = this.intermediateModel.connectionMap.get(hashCode);
            connection.setLocation(this.getLocation(moduleVariableDeclarationNode.lineRange()));
            TypeSymbol rawType = CommonUtils.getRawType(((VariableSymbol)symbol.get()).typeDescriptor());
            if (rawType instanceof ClassSymbol) {
                Optional initializer = moduleVariableDeclarationNode.initializer();
                if (initializer.isEmpty()) {
                    return;
                }
                ExpressionNode expressionNode = (ExpressionNode)initializer.get();
                if (expressionNode instanceof CheckExpressionNode) {
                    CheckExpressionNode checkExpressionNode = (CheckExpressionNode)expressionNode;
                    expressionNode = checkExpressionNode.expression();
                }
                if (expressionNode instanceof NewExpressionNode) {
                    NewExpressionNode newExpressionNode = (NewExpressionNode)expressionNode;
                    SeparatedNodeList<FunctionArgumentNode> argList = this.getArgList(newExpressionNode);
                    List<ExpressionNode> argExprs = this.getInitMethodArgExprs(argList);
                    for (ExpressionNode argExpr : argExprs) {
                        this.handleInitMethodListArgs(connection, argExpr);
                    }
                }
            }
        }
    }

    private void handleInitMethodListArgs(Connection connection, ExpressionNode expressionNode) {
        ClassSymbol classSymbol;
        VariableSymbol variableSymbol;
        TypeSymbol rawType;
        Object specificFieldNode2;
        SimpleNameReferenceNode varRef;
        Optional symbol;
        if (expressionNode instanceof ListConstructorExpressionNode) {
            ListConstructorExpressionNode listConstructorExpressionNode = (ListConstructorExpressionNode)expressionNode;
            for (Node expr : listConstructorExpressionNode.expressions()) {
                Object t;
                Optional symbol2 = this.semanticModel.symbol(expr);
                if (symbol2.isEmpty() || !((t = symbol2.get()) instanceof FunctionSymbol)) continue;
                FunctionSymbol functionSymbol = (FunctionSymbol)t;
                connection.addDependentFunction(functionSymbol.getName().orElse(""));
            }
        } else if (expressionNode instanceof MappingConstructorExpressionNode) {
            MappingConstructorExpressionNode mappingConstructorExpressionNode = (MappingConstructorExpressionNode)expressionNode;
            for (Node expr : mappingConstructorExpressionNode.fields()) {
                SpecificFieldNode specificFieldNode2;
                if (!(expr instanceof SpecificFieldNode) || !(specificFieldNode2 = (SpecificFieldNode)expr).valueExpr().isPresent()) continue;
                this.handleInitMethodListArgs(connection, (ExpressionNode)specificFieldNode2.valueExpr().get());
            }
        } else if (expressionNode instanceof SimpleNameReferenceNode && (symbol = this.semanticModel.symbol((Node)(varRef = (SimpleNameReferenceNode)expressionNode))).isPresent() && (specificFieldNode2 = symbol.get()) instanceof VariableSymbol && (rawType = CommonUtils.getRawType((variableSymbol = (VariableSymbol)specificFieldNode2).typeDescriptor())) instanceof ClassSymbol && (classSymbol = (ClassSymbol)rawType).qualifiers().contains(Qualifier.CLIENT) && this.intermediateModel.connectionMap.containsKey(String.valueOf(((io.ballerina.tools.diagnostics.Location)((Symbol)symbol.get()).getLocation().get()).hashCode()))) {
            Connection dependentConnection = this.intermediateModel.connectionMap.get(String.valueOf(((io.ballerina.tools.diagnostics.Location)((Symbol)symbol.get()).getLocation().get()).hashCode()));
            connection.addDependentConnection(dependentConnection.getUuid());
        }
    }

    private List<ExpressionNode> getInitMethodArgExprs(SeparatedNodeList<FunctionArgumentNode> argumentNodes) {
        ArrayList<ExpressionNode> arguments = new ArrayList<ExpressionNode>();
        for (int argIdx = 0; argIdx < argumentNodes.size(); ++argIdx) {
            Node argument = argumentNodes.get(argIdx);
            if (argument == null) continue;
            SyntaxKind argKind = argument.kind();
            if (argKind == SyntaxKind.NAMED_ARG) {
                arguments.add(((NamedArgumentNode)argument).expression());
                continue;
            }
            if (argKind != SyntaxKind.POSITIONAL_ARG) continue;
            arguments.add(((PositionalArgumentNode)argument).expression());
        }
        return arguments;
    }

    public void visit(AssignmentStatementNode assignmentStatementNode) {
        assignmentStatementNode.expression().accept((NodeVisitor)this);
    }

    public void visit(CompoundAssignmentStatementNode compoundAssignmentStatementNode) {
        compoundAssignmentStatementNode.rhsExpression().accept((NodeVisitor)this);
        compoundAssignmentStatementNode.lhsExpression().accept((NodeVisitor)this);
    }

    public void visit(BlockStatementNode blockStatementNode) {
        blockStatementNode.statements().forEach(statement -> statement.accept((NodeVisitor)this));
    }

    public void visit(FailStatementNode failStatementNode) {
        failStatementNode.expression().accept((NodeVisitor)this);
    }

    public void visit(ExpressionStatementNode expressionStatementNode) {
        expressionStatementNode.expression().accept((NodeVisitor)this);
    }

    public void visit(WhileStatementNode whileStatementNode) {
        whileStatementNode.condition().accept((NodeVisitor)this);
        whileStatementNode.whileBody().statements().forEach(statement -> statement.accept((NodeVisitor)this));
        whileStatementNode.onFailClause().ifPresent(onFailClauseNode -> onFailClauseNode.blockStatement().statements().forEach(statement -> statement.accept((NodeVisitor)this)));
    }

    public void visit(PanicStatementNode panicStatementNode) {
        panicStatementNode.expression().accept((NodeVisitor)this);
    }

    public void visit(CheckExpressionNode checkExpressionNode) {
        checkExpressionNode.expression().accept((NodeVisitor)this);
    }

    public void visit(StartActionNode startActionNode) {
        startActionNode.expression().accept((NodeVisitor)this);
    }

    public void visit(LockStatementNode lockStatementNode) {
        lockStatementNode.blockStatement().statements().forEach(statement -> statement.accept((NodeVisitor)this));
    }

    public void visit(ForkStatementNode forkStatementNode) {
        forkStatementNode.namedWorkerDeclarations().forEach(namedWorkerDeclaration -> namedWorkerDeclaration.accept((NodeVisitor)this));
    }

    public void visit(NamedWorkerDeclarationNode namedWorkerDeclarationNode) {
        namedWorkerDeclarationNode.workerBody().statements().forEach(statement -> statement.accept((NodeVisitor)this));
        namedWorkerDeclarationNode.onFailClause().ifPresent(onFailClauseNode -> onFailClauseNode.blockStatement().statements().forEach(statement -> statement.accept((NodeVisitor)this)));
    }

    public void visit(TransactionStatementNode transactionStatementNode) {
        transactionStatementNode.blockStatement().statements().forEach(statement -> statement.accept((NodeVisitor)this));
        transactionStatementNode.onFailClause().ifPresent(onFailClauseNode -> onFailClauseNode.blockStatement().statements().forEach(statement -> statement.accept((NodeVisitor)this)));
    }

    public void visit(ForEachStatementNode forEachStatementNode) {
        forEachStatementNode.blockStatement().statements().forEach(statement -> statement.accept((NodeVisitor)this));
        forEachStatementNode.actionOrExpressionNode().accept((NodeVisitor)this);
    }

    public void visit(RollbackStatementNode rollbackStatementNode) {
        rollbackStatementNode.expression().ifPresent(expr -> expr.accept((NodeVisitor)this));
    }

    public void visit(RetryStatementNode retryStatementNode) {
        retryStatementNode.retryBody().accept((NodeVisitor)this);
        retryStatementNode.onFailClause().ifPresent(onFailClauseNode -> onFailClauseNode.blockStatement().statements().forEach(statement -> statement.accept((NodeVisitor)this)));
    }

    public void visit(MatchStatementNode matchStatementNode) {
        matchStatementNode.condition().accept((NodeVisitor)this);
        matchStatementNode.matchClauses().forEach(matchClause -> matchClause.blockStatement().statements().forEach(statement -> statement.accept((NodeVisitor)this)));
        matchStatementNode.onFailClause().ifPresent(onFailClauseNode -> onFailClauseNode.blockStatement().statements().forEach(statement -> statement.accept((NodeVisitor)this)));
    }

    public void visit(MappingConstructorExpressionNode mappingConstructorExpressionNode) {
        mappingConstructorExpressionNode.fields().forEach(field -> field.accept((NodeVisitor)this));
    }

    public void visit(ListConstructorExpressionNode listConstructorExpressionNode) {
        listConstructorExpressionNode.expressions().forEach(expr -> expr.accept((NodeVisitor)this));
    }

    private String getDisplayName(List<AnnotationAttachmentSymbol> annotationAttachmentSymbols) {
        return annotationAttachmentSymbols.stream().filter(annotationAttachmentSymbol -> {
            AnnotationSymbol annotationSymbol = annotationAttachmentSymbol.typeDescriptor();
            if (annotationSymbol.getName().isPresent()) {
                return ((String)annotationSymbol.getName().get()).equals("display");
            }
            return false;
        }).findAny().map(annotationAttachmentSymbol -> annotationAttachmentSymbol.attachmentValue().map(ConstantValue::value)).flatMap(v -> v).map(m -> ((Map)m).get("label")).map(v -> ((ConstantValue)v).value().toString()).orElse(null);
    }

    public Location getLocation(LineRange lineRange) {
        Path filePath = this.rootPath.resolve(lineRange.fileName());
        return new Location(filePath.toAbsolutePath().toString(), lineRange.startLine(), lineRange.endLine());
    }

    private List<Listener.KeyValue> getInitMethodParamNames(ClassSymbol classSymbol, SeparatedNodeList<FunctionArgumentNode> argumentNodes) {
        Optional methodSymbol = classSymbol.initMethod();
        ArrayList<Listener.KeyValue> keyValues = new ArrayList<Listener.KeyValue>();
        if (methodSymbol.isPresent()) {
            FunctionTypeSymbol functionTypeSymbol = ((MethodSymbol)methodSymbol.get()).typeDescriptor();
            List parameterSymbols = (List)functionTypeSymbol.params().get();
            for (int argIdx = 0; argIdx < argumentNodes.size() && argIdx < parameterSymbols.size(); ++argIdx) {
                Node argument = argumentNodes.get(argIdx);
                if (argument == null) {
                    return Collections.emptyList();
                }
                SyntaxKind argKind = argument.kind();
                if (argKind == SyntaxKind.NAMED_ARG) {
                    argument = ((NamedArgumentNode)argument).expression();
                } else if (argKind == SyntaxKind.POSITIONAL_ARG) {
                    argument = ((PositionalArgumentNode)argument).expression();
                } else {
                    return Collections.emptyList();
                }
                ParameterSymbol parameterSymbol = (ParameterSymbol)parameterSymbols.get(argIdx);
                String paramName = parameterSymbol.getName().orElse("");
                keyValues.add(new Listener.KeyValue(paramName, argument.toSourceCode()));
            }
        }
        return keyValues;
    }

    private SeparatedNodeList<FunctionArgumentNode> getArgList(NewExpressionNode newExpressionNode) {
        if (newExpressionNode instanceof ExplicitNewExpressionNode) {
            ExplicitNewExpressionNode explicitNewExpressionNode = (ExplicitNewExpressionNode)newExpressionNode;
            return explicitNewExpressionNode.parenthesizedArgList().arguments();
        }
        Optional parenthesizedArgList = ((ImplicitNewExpressionNode)newExpressionNode).parenthesizedArgList();
        return parenthesizedArgList.isPresent() ? ((ParenthesizedArgList)parenthesizedArgList.get()).arguments() : NodeFactory.createSeparatedNodeList((Node[])new Node[0]);
    }
}

