/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.designmodelgenerator.core;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.ObjectTypeSymbol;
import io.ballerina.compiler.api.symbols.Qualifier;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.VariableSymbol;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.designmodelgenerator.core.CodeAnalyzer;
import io.ballerina.designmodelgenerator.core.CommonUtils;
import io.ballerina.designmodelgenerator.core.ConnectionFinder;
import io.ballerina.designmodelgenerator.core.IntermediateModel;
import io.ballerina.designmodelgenerator.core.model.Automation;
import io.ballerina.designmodelgenerator.core.model.Connection;
import io.ballerina.designmodelgenerator.core.model.DesignModel;
import io.ballerina.designmodelgenerator.core.model.Function;
import io.ballerina.designmodelgenerator.core.model.Listener;
import io.ballerina.designmodelgenerator.core.model.Location;
import io.ballerina.designmodelgenerator.core.model.ResourceFunction;
import io.ballerina.designmodelgenerator.core.model.Service;
import io.ballerina.modelgenerator.commons.PackageUtil;
import io.ballerina.projects.Document;
import io.ballerina.projects.Module;
import io.ballerina.projects.Package;
import io.ballerina.tools.text.LineRange;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class DesignModelGenerator {
    private final SemanticModel semanticModel;
    private final Module defaultModule;
    private final Path rootPath;
    public static final String MAIN_FUNCTION_NAME = "main";
    private static final String AUTOMATION = "automation";
    private static final String SERVICE = "Service";
    private final Map<String, ModulePartNode> documentMap;

    public DesignModelGenerator(Package ballerinaPackage) {
        this.defaultModule = ballerinaPackage.getDefaultModule();
        this.semanticModel = PackageUtil.getCompilation((Package)ballerinaPackage).getSemanticModel(this.defaultModule.moduleId());
        this.rootPath = ballerinaPackage.project().sourceRoot();
        this.documentMap = new HashMap<String, ModulePartNode>();
        this.defaultModule.documentIds().forEach(documentId -> {
            Document document = this.defaultModule.document(documentId);
            this.documentMap.put(document.name(), (ModulePartNode)document.syntaxTree().rootNode());
        });
    }

    public DesignModel generate() {
        IntermediateModel intermediateModel = new IntermediateModel();
        this.populateModuleLevelConnections(intermediateModel);
        ConnectionFinder connectionFinder = new ConnectionFinder(this.semanticModel, this.rootPath, this.documentMap, intermediateModel);
        this.defaultModule.documentIds().forEach(d -> {
            ModulePartNode rootNode = (ModulePartNode)this.defaultModule.document(d).syntaxTree().rootNode();
            CodeAnalyzer codeAnalyzer = new CodeAnalyzer(this.semanticModel, intermediateModel, this.rootPath, connectionFinder);
            codeAnalyzer.visit(rootNode);
        });
        DesignModel.DesignModelBuilder builder = new DesignModel.DesignModelBuilder();
        if (intermediateModel.functionModelMap.containsKey(MAIN_FUNCTION_NAME)) {
            IntermediateModel.FunctionModel main = intermediateModel.functionModelMap.get(MAIN_FUNCTION_NAME);
            this.buildConnectionGraph(intermediateModel, main, null);
            builder.setAutomation(new Automation(AUTOMATION, main.displayName, "Z", main.location, main.allDependentConnections.stream().toList()));
        }
        for (Map.Entry<String, IntermediateModel.ServiceModel> serviceEntry : intermediateModel.serviceModelMap.entrySet()) {
            IntermediateModel.ServiceModel serviceModel = serviceEntry.getValue();
            HashSet connections = new HashSet();
            ArrayList<Function> functions = new ArrayList<Function>();
            serviceModel.otherFunctions.values().forEach(otherFunction -> {
                this.buildConnectionGraph(intermediateModel, (IntermediateModel.FunctionModel)otherFunction, serviceModel);
                functions.add(new Function(otherFunction.name, otherFunction.location, otherFunction.allDependentConnections));
                connections.addAll(otherFunction.allDependentConnections);
            });
            ArrayList<Function> remoteFunctions = new ArrayList<Function>();
            serviceModel.remoteFunctions.forEach(remoteFunction -> {
                this.buildConnectionGraph(intermediateModel, (IntermediateModel.FunctionModel)remoteFunction, serviceModel);
                remoteFunction.connections.forEach(connection -> {
                    Connection conn = intermediateModel.uuidToConnectionMap.get(connection);
                    if (conn != null) {
                        remoteFunction.dependentFuncs.clear();
                        remoteFunction.dependentFuncs.addAll(conn.getDependentFunctions());
                        remoteFunction.allDependentConnections.addAll(conn.getDependentConnection());
                    }
                });
                remoteFunction.analyzed = false;
                remoteFunction.visited = false;
                remoteFunctions.add(new Function(remoteFunction.name, remoteFunction.location, remoteFunction.allDependentConnections));
                connections.addAll(remoteFunction.allDependentConnections);
            });
            ArrayList<ResourceFunction> resourceFunctions = new ArrayList<ResourceFunction>();
            serviceModel.resourceFunctions.forEach(resourceFunction -> {
                this.buildConnectionGraph(intermediateModel, (IntermediateModel.FunctionModel)resourceFunction, serviceModel);
                resourceFunction.connections.forEach(connection -> {
                    Connection conn = intermediateModel.uuidToConnectionMap.get(connection);
                    if (conn != null) {
                        resourceFunction.dependentFuncs.clear();
                        resourceFunction.dependentFuncs.addAll(conn.getDependentFunctions());
                        resourceFunction.allDependentConnections.addAll(conn.getDependentConnection());
                    }
                });
                resourceFunction.analyzed = false;
                resourceFunction.visited = false;
                this.buildConnectionGraph(intermediateModel, (IntermediateModel.FunctionModel)resourceFunction, serviceModel);
                resourceFunctions.add(new ResourceFunction(resourceFunction.name, resourceFunction.path, resourceFunction.location, resourceFunction.allDependentConnections));
                connections.addAll(resourceFunction.allDependentConnections);
            });
            List<Listener> allAttachedListeners = serviceModel.anonListeners;
            for (String listener : serviceModel.namedListeners) {
                allAttachedListeners.add(intermediateModel.listeners.get(listener));
            }
            Service service = new Service(serviceModel.displayName, serviceModel.absolutePath, serviceModel.location, serviceModel.sortText, connections.stream().toList(), functions, remoteFunctions, resourceFunctions);
            int size = allAttachedListeners.size();
            if (size > 0) {
                Listener listener = allAttachedListeners.get(0);
                service.setIcon(listener.getIcon());
                service.setType(this.getServiceType(listener.getType()));
                for (int i = 0; i < size; ++i) {
                    listener = allAttachedListeners.get(i);
                    listener.getAttachedServices().add(service.getUuid());
                    service.addAttachedListener(listener.getUuid());
                }
            }
            builder.addService(service);
        }
        return builder.setListeners(intermediateModel.listeners.values().stream().toList()).setConnections(intermediateModel.connectionMap.values().stream().toList()).build();
    }

    private void populateModuleLevelConnections(IntermediateModel intermediateModel) {
        for (Symbol symbol : this.semanticModel.moduleSymbols()) {
            ObjectTypeSymbol objectTypeSymbol;
            VariableSymbol variableSymbol;
            TypeSymbol typeSymbol;
            if (!(symbol instanceof VariableSymbol) || !((typeSymbol = CommonUtils.getRawType((variableSymbol = (VariableSymbol)symbol).typeDescriptor())) instanceof ObjectTypeSymbol) || !(objectTypeSymbol = (ObjectTypeSymbol)typeSymbol).qualifiers().contains(Qualifier.CLIENT)) continue;
            LineRange lineRange = ((io.ballerina.tools.diagnostics.Location)variableSymbol.getLocation().get()).lineRange();
            String sortText = lineRange.fileName() + lineRange.startLine().line();
            String icon = CommonUtils.generateIcon(variableSymbol.typeDescriptor());
            Connection connection = new Connection((String)variableSymbol.getName().get(), sortText, this.getLocation(lineRange), Connection.Scope.GLOBAL, icon, true);
            intermediateModel.connectionMap.put(String.valueOf(((io.ballerina.tools.diagnostics.Location)variableSymbol.getLocation().get()).hashCode()), connection);
            intermediateModel.uuidToConnectionMap.put(connection.getUuid(), connection);
        }
    }

    private void buildConnectionGraph(IntermediateModel intermediateModel, IntermediateModel.FunctionModel functionModel, IntermediateModel.ServiceModel serviceModel) {
        HashSet connections = new HashSet();
        if (!functionModel.visited && !functionModel.analyzed) {
            functionModel.visited = true;
            functionModel.dependentFuncs.forEach(dependentFunc -> {
                IntermediateModel.FunctionModel dependentFunctionModel = intermediateModel.functionModelMap.get(dependentFunc);
                if (dependentFunctionModel == null) {
                    return;
                }
                if (!dependentFunctionModel.analyzed) {
                    this.buildConnectionGraph(intermediateModel, dependentFunctionModel, serviceModel);
                }
                connections.addAll(dependentFunctionModel.allDependentConnections);
                connections.addAll(dependentFunctionModel.connections);
            });
            functionModel.dependentObjFuncs.forEach(dependentObjFunc -> {
                if (serviceModel == null) {
                    return;
                }
                IntermediateModel.FunctionModel dependentFunctionModel = serviceModel.otherFunctions.get(dependentObjFunc);
                if (dependentFunctionModel == null) {
                    return;
                }
                if (!dependentFunctionModel.analyzed) {
                    this.buildConnectionGraph(intermediateModel, dependentFunctionModel, serviceModel);
                }
                connections.addAll(dependentFunctionModel.allDependentConnections);
                connections.addAll(dependentFunctionModel.connections);
            });
        }
        functionModel.visited = true;
        functionModel.allDependentConnections.addAll(functionModel.connections);
        functionModel.allDependentConnections.addAll(connections);
        functionModel.analyzed = true;
    }

    public Location getLocation(LineRange lineRange) {
        Path filePath = this.rootPath.resolve(lineRange.fileName());
        return new Location(filePath.toAbsolutePath().toString(), lineRange.startLine(), lineRange.endLine());
    }

    public String getServiceType(String listenerType) {
        return listenerType.split(SyntaxKind.COLON_TOKEN.stringValue())[0] + SyntaxKind.COLON_TOKEN.stringValue() + SERVICE;
    }
}

