/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.designmodelgenerator.core.model;

import io.ballerina.designmodelgenerator.core.model.DesignGraphNode;
import io.ballerina.designmodelgenerator.core.model.Location;
import java.util.List;
import java.util.Objects;

public final class Automation
extends DesignGraphNode {
    private final String name;
    private final String displayName;
    private final Location location;
    private final List<String> connections;
    private final String type;

    public Automation(String name, String displayName, String sortText, Location location, List<String> connections) {
        super(true, sortText);
        this.name = name;
        this.displayName = displayName;
        this.location = location;
        this.connections = connections;
        this.type = "automation";
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Location getLocation() {
        return this.location;
    }

    public List<String> getConnections() {
        return this.connections;
    }

    public int hashCode() {
        return Objects.hash(this.type.hashCode(), this.name.hashCode(), this.displayName.hashCode(), this.location.hashCode(), this.connections.size());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Automation)) {
            return false;
        }
        Automation automation = (Automation)obj;
        return automation.getType().equals(this.type) && automation.getName().equals(this.name) && automation.getDisplayName().equals(this.displayName) && automation.getLocation().equals(this.location) && automation.getConnections().size() == this.connections.size();
    }
}

