/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.designmodelgenerator.core.model;

import io.ballerina.designmodelgenerator.core.model.Automation;
import io.ballerina.designmodelgenerator.core.model.Connection;
import io.ballerina.designmodelgenerator.core.model.Listener;
import io.ballerina.designmodelgenerator.core.model.Service;
import java.util.ArrayList;
import java.util.List;

public record DesignModel(Automation automation, List<Connection> connections, List<Listener> listeners, List<Service> services) {

    public static class DesignModelBuilder {
        private Automation automation;
        private List<Connection> connections;
        private List<Listener> listeners;
        private final List<Service> services = new ArrayList<Service>();

        public void setAutomation(Automation automation) {
            this.automation = automation;
        }

        public DesignModelBuilder setConnections(List<Connection> connections) {
            this.connections = connections;
            return this;
        }

        public DesignModelBuilder setListeners(List<Listener> listeners) {
            this.listeners = listeners;
            return this;
        }

        public void addService(Service service) {
            this.services.add(service);
        }

        public DesignModel build() {
            return new DesignModel(this.automation, this.connections, this.listeners, this.services);
        }
    }
}

