/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.designmodelgenerator.core.model;

import io.ballerina.designmodelgenerator.core.model.DesignGraphNode;
import io.ballerina.designmodelgenerator.core.model.Location;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class Listener
extends DesignGraphNode {
    private final String symbol;
    private final Location location;
    private final Set<String> attachedServices;
    private final Kind kind;
    private final String type;
    private final List<KeyValue> args;
    private final String icon;

    public Listener(String symbol, String sortText, Location location, String type, String icon, Kind kind, List<KeyValue> args) {
        super(sortText);
        this.symbol = symbol;
        this.location = location;
        this.kind = kind;
        this.attachedServices = new HashSet<String>();
        this.type = type;
        this.icon = icon;
        this.args = args;
    }

    public Listener(String symbol, String sortText, Location location, String type, String icon, Kind kind, List<KeyValue> args, boolean enableFlow) {
        super(enableFlow, sortText);
        this.symbol = symbol;
        this.location = location;
        this.kind = kind;
        this.attachedServices = new HashSet<String>();
        this.type = type;
        this.icon = icon;
        this.args = args;
    }

    public String getIcon() {
        return this.icon;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public Location getLocation() {
        return this.location;
    }

    public Set<String> getAttachedServices() {
        return this.attachedServices;
    }

    public Kind getKind() {
        return this.kind;
    }

    public String getType() {
        return this.type;
    }

    public List<KeyValue> getArgs() {
        return this.args;
    }

    public static enum Kind {
        ANON,
        NAMED,
        IMPORTED;

    }

    public record KeyValue(String key, String value) {
    }
}

