/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.api;

import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BDecimal;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import java.util.ArrayList;
import java.util.List;

public class CorsHeaders {
    private static final BString ALLOW_CREDENTIALS_FIELD = StringUtils.fromString((String)"allowCredentials");
    private static final BString ALLOW_HEADERS_FIELD = StringUtils.fromString((String)"allowHeaders");
    private static final BString ALLOW_METHODS_FIELD = StringUtils.fromString((String)"allowMethods");
    private static final BString ALLOWS_ORIGINS_FIELD = StringUtils.fromString((String)"allowOrigins");
    private static final BString EXPOSE_HEADERS_FIELD = StringUtils.fromString((String)"exposeHeaders");
    private static final BString MAX_AGE_FIELD = StringUtils.fromString((String)"maxAge");
    private boolean available = false;
    private List<String> allowOrigins;
    private int allowCredentials = -1;
    private List<String> allowMethods;
    private List<String> allowHeaders;
    private long maxAge = -1L;
    private List<String> exposeHeaders;

    private CorsHeaders() {
    }

    public boolean isAvailable() {
        return this.available;
    }

    public List<String> getAllowOrigins() {
        return this.allowOrigins;
    }

    public void setAllowOrigins(List<String> allowOrigins) {
        if (allowOrigins != null) {
            this.available = true;
        }
        this.allowOrigins = allowOrigins;
    }

    public int getAllowCredentials() {
        return this.allowCredentials;
    }

    public void setAllowCredentials(int allowCredentials) {
        if (allowCredentials > 0) {
            this.available = true;
        }
        this.allowCredentials = allowCredentials;
    }

    List<String> getAllowMethods() {
        return this.allowMethods;
    }

    void setAllowMethods(List<String> allowMethods) {
        if (allowMethods != null) {
            this.available = true;
        }
        this.allowMethods = allowMethods;
    }

    public List<String> getAllowHeaders() {
        return this.allowHeaders;
    }

    public void setAllowHeaders(List<String> allowHeaders) {
        if (allowHeaders != null) {
            this.available = true;
        }
        this.allowHeaders = allowHeaders;
    }

    public long getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(long maxAge) {
        if (maxAge >= 0L) {
            this.available = true;
        }
        this.maxAge = maxAge;
    }

    public List<String> getExposeHeaders() {
        return this.exposeHeaders;
    }

    public void setExposeHeaders(List<String> exposeHeaders) {
        if (exposeHeaders != null) {
            this.available = true;
        }
        this.exposeHeaders = exposeHeaders;
    }

    static CorsHeaders buildCorsHeaders(BMap corsConfig) {
        CorsHeaders corsHeaders = new CorsHeaders();
        if (corsConfig == null) {
            return corsHeaders;
        }
        corsHeaders.setAllowHeaders(CorsHeaders.getAsStringList(corsConfig.getArrayValue(ALLOW_HEADERS_FIELD).getStringArray()));
        corsHeaders.setAllowMethods(CorsHeaders.getAsStringList(corsConfig.getArrayValue(ALLOW_METHODS_FIELD).getStringArray()));
        corsHeaders.setAllowOrigins(CorsHeaders.getAsStringList(corsConfig.getArrayValue(ALLOWS_ORIGINS_FIELD).getStringArray()));
        corsHeaders.setExposeHeaders(CorsHeaders.getAsStringList(corsConfig.getArrayValue(EXPOSE_HEADERS_FIELD).getStringArray()));
        corsHeaders.setAllowCredentials(corsConfig.getBooleanValue(ALLOW_CREDENTIALS_FIELD) != false ? 1 : 0);
        corsHeaders.setMaxAge(((BDecimal)corsConfig.get((Object)MAX_AGE_FIELD)).intValue());
        return corsHeaders;
    }

    private static List<String> getAsStringList(Object[] values) {
        if (values == null) {
            return null;
        }
        ArrayList<String> valuesList = new ArrayList<String>();
        for (Object val : values) {
            valuesList.add(val.toString().trim());
        }
        return !valuesList.isEmpty() ? valuesList : null;
    }
}

