/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.api;

import io.ballerina.stdlib.http.api.HttpUtil;
import io.ballerina.stdlib.http.transport.contract.HttpWsConnectorFactory;
import io.ballerina.stdlib.http.transport.contract.ServerConnector;
import io.ballerina.stdlib.http.transport.contract.config.ListenerConfiguration;
import io.ballerina.stdlib.http.transport.contract.config.SenderConfiguration;
import io.ballerina.stdlib.http.transport.contract.config.ServerBootstrapConfiguration;
import io.ballerina.stdlib.http.transport.contract.config.TransportProperty;
import io.ballerina.stdlib.http.transport.contract.config.TransportsConfiguration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class HttpConnectionManager {
    private static final HttpConnectionManager instance = new HttpConnectionManager();
    private final Map<String, ServerConnector> startupDelayedHTTPServerConnectors = new HashMap<String, ServerConnector>();
    private final Map<String, HttpServerConnectorContext> serverConnectorPool = new HashMap<String, HttpServerConnectorContext>();
    private final TransportsConfiguration trpConfig = this.buildDefaultTransportConfig();

    private HttpConnectionManager() {
    }

    public static HttpConnectionManager getInstance() {
        return instance;
    }

    public ServerConnector createHttpServerConnector(ListenerConfiguration listenerConfig) throws Exception {
        String listenerInterface = listenerConfig.getHost() + ":" + listenerConfig.getPort();
        HttpServerConnectorContext httpServerConnectorContext = this.serverConnectorPool.get(listenerInterface);
        if (httpServerConnectorContext != null) {
            if (this.checkForConflicts(listenerConfig, httpServerConnectorContext)) {
                throw new Exception("Conflicting configuration detected for listener configuration id " + listenerConfig.getId());
            }
            httpServerConnectorContext.incrementReferenceCount();
            return httpServerConnectorContext.getServerConnector();
        }
        if (this.isHTTPTraceLoggerEnabled()) {
            listenerConfig.setHttpTraceLogEnabled(true);
        }
        if (this.isHTTPAccessLoggerEnabled()) {
            listenerConfig.setHttpAccessLogEnabled(true);
        }
        ServerBootstrapConfiguration serverBootstrapConfiguration = new ServerBootstrapConfiguration(listenerConfig);
        HttpWsConnectorFactory httpConnectorFactory = HttpUtil.createHttpWsConnectionFactory();
        ServerConnector serverConnector = httpConnectorFactory.createServerConnector(serverBootstrapConfiguration, listenerConfig);
        httpServerConnectorContext = new HttpServerConnectorContext(serverConnector, listenerConfig);
        this.serverConnectorPool.put(serverConnector.getConnectorID(), httpServerConnectorContext);
        httpServerConnectorContext.incrementReferenceCount();
        this.addStartupDelayedHTTPServerConnector(listenerInterface, serverConnector);
        return serverConnector;
    }

    public void addStartupDelayedHTTPServerConnector(String id, ServerConnector serverConnector) {
        this.startupDelayedHTTPServerConnectors.put(id, serverConnector);
    }

    private boolean checkForConflicts(ListenerConfiguration listenerConfiguration, HttpServerConnectorContext context) {
        if (context == null) {
            return false;
        }
        if (!listenerConfiguration.getScheme().equalsIgnoreCase("https")) {
            return false;
        }
        ListenerConfiguration config = context.getListenerConfiguration();
        return !listenerConfiguration.getKeyStoreFile().equals(config.getKeyStoreFile()) || !listenerConfiguration.getKeyStorePass().equals(config.getKeyStorePass());
    }

    public TransportsConfiguration getTransportConfig() {
        return this.trpConfig;
    }

    public boolean isHTTPTraceLoggerEnabled() {
        return Boolean.parseBoolean(System.getProperty("http.tracelog.enabled"));
    }

    public boolean isHTTPAccessLoggerEnabled() {
        return Boolean.parseBoolean(System.getProperty("http.accesslog.enabled"));
    }

    private TransportsConfiguration buildDefaultTransportConfig() {
        TransportsConfiguration transportsConfiguration = new TransportsConfiguration();
        SenderConfiguration httpSender = new SenderConfiguration("http-sender");
        SenderConfiguration httpsSender = new SenderConfiguration("https-sender");
        httpsSender.setScheme("https");
        TransportProperty latencyMetrics = new TransportProperty();
        latencyMetrics.setName("latency.metrics.enabled");
        latencyMetrics.setValue(true);
        TransportProperty serverSocketTimeout = new TransportProperty();
        serverSocketTimeout.setName("server.bootstrap.socket.timeout");
        serverSocketTimeout.setValue(60);
        TransportProperty clientSocketTimeout = new TransportProperty();
        clientSocketTimeout.setName("client.bootstrap.socket.timeout");
        clientSocketTimeout.setValue(60);
        HashSet<SenderConfiguration> senderConfigurationSet = new HashSet<SenderConfiguration>();
        senderConfigurationSet.add(httpSender);
        senderConfigurationSet.add(httpsSender);
        transportsConfiguration.setSenderConfigurations(senderConfigurationSet);
        HashSet<TransportProperty> transportPropertySet = new HashSet<TransportProperty>();
        transportPropertySet.add(latencyMetrics);
        transportPropertySet.add(serverSocketTimeout);
        transportPropertySet.add(clientSocketTimeout);
        transportsConfiguration.setTransportProperties(transportPropertySet);
        return transportsConfiguration;
    }

    private static class HttpServerConnectorContext {
        private final ServerConnector serverConnector;
        private final ListenerConfiguration listenerConfiguration;
        private int referenceCount = 0;

        HttpServerConnectorContext(ServerConnector serverConnector, ListenerConfiguration listenerConfiguration) {
            this.serverConnector = serverConnector;
            this.listenerConfiguration = listenerConfiguration;
        }

        void incrementReferenceCount() {
            ++this.referenceCount;
        }

        void decrementReferenceCount() {
            --this.referenceCount;
        }

        ServerConnector getServerConnector() {
            return this.serverConnector;
        }

        ListenerConfiguration getListenerConfiguration() {
            return this.listenerConfiguration;
        }

        int getReferenceCount() {
            return this.referenceCount;
        }
    }
}

