/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.api;

import io.ballerina.runtime.api.Runtime;
import io.ballerina.runtime.api.concurrent.StrandMetadata;
import io.ballerina.runtime.api.types.ServiceType;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.stdlib.http.api.BallerinaHTTPConnectorListener;
import io.ballerina.stdlib.http.api.HttpCallableUnitCallback;
import io.ballerina.stdlib.http.api.HttpErrorType;
import io.ballerina.stdlib.http.api.HttpUtil;
import io.ballerina.stdlib.http.transport.message.HttpCarbonMessage;

public class HttpRequestInterceptorUnitCallback
extends HttpCallableUnitCallback {
    private static final String ILLEGAL_FUNCTION_INVOKED = "illegal return: response has already been sent";
    private final BObject caller;
    private final Runtime runtime;
    private final HttpCarbonMessage requestMessage;
    private final BallerinaHTTPConnectorListener ballerinaHTTPConnectorListener;
    private final BObject requestCtx;

    HttpRequestInterceptorUnitCallback(HttpCarbonMessage requestMessage, Runtime runtime, BallerinaHTTPConnectorListener ballerinaHTTPConnectorListener) {
        super(requestMessage, runtime);
        this.runtime = runtime;
        this.requestMessage = requestMessage;
        this.requestCtx = (BObject)requestMessage.getProperty("RequestContext");
        this.ballerinaHTTPConnectorListener = ballerinaHTTPConnectorListener;
        this.caller = (BObject)requestMessage.getProperty("Caller");
    }

    @Override
    public void handleResult(Object result) {
        if (result instanceof BError) {
            if (!result.equals(this.requestCtx.getNativeData("TARGET_SERVICE"))) {
                this.requestMessage.setHttpStatusCode(500);
            }
            this.invokeErrorInterceptors((BError)((Object)result), false);
            return;
        }
        this.validateResponseAndProceed(result);
    }

    @Override
    public void handlePanic(BError error) {
        this.cleanupRequestMessage();
        this.sendFailureResponse(error);
        System.exit(1);
    }

    @Override
    public void invokeErrorInterceptors(BError error, boolean isInternalError) {
        if (isInternalError) {
            this.requestMessage.setProperty("INTERNAL_ERROR", true);
        } else {
            this.requestMessage.removeProperty("INTERNAL_ERROR");
        }
        this.requestMessage.setProperty("INTERCEPTOR_SERVICE_ERROR", (Object)error);
        this.ballerinaHTTPConnectorListener.onMessage(this.requestMessage);
    }

    public void returnErrorResponse(Object error) {
        Object[] paramFeed = new Object[]{error, null};
        this.invokeBalMethod(paramFeed, "returnErrorResponse");
    }

    private boolean alreadyResponded() {
        try {
            HttpUtil.methodInvocationCheck(this.requestMessage, 0, ILLEGAL_FUNCTION_INVOKED);
        }
        catch (BError e) {
            return true;
        }
        return false;
    }

    private void sendRequestToNextService() {
        this.ballerinaHTTPConnectorListener.onMessage(this.requestMessage);
    }

    private void validateResponseAndProceed(Object result) {
        int interceptorId = this.getRequestInterceptorId();
        this.requestMessage.setProperty("REQUEST_INTERCEPTOR_INDEX", interceptorId);
        BArray interceptors = (BArray)this.requestCtx.getNativeData("INTERCEPTORS");
        boolean nextCalled = (Boolean)this.requestCtx.getNativeData("REQUEST_CONTEXT_NEXT");
        if (this.alreadyResponded()) {
            if (nextCalled) {
                this.sendRequestToNextService();
            }
            return;
        }
        if (result == null) {
            this.returnResponse(null);
            if (nextCalled) {
                this.sendRequestToNextService();
                return;
            }
            return;
        }
        if (this.isServiceType(result)) {
            this.validateServiceReturnType(result, interceptorId, interceptors);
        } else {
            this.returnResponse(result);
        }
    }

    private boolean isServiceType(Object result) {
        return result instanceof BObject && TypeUtils.getType((Object)result) instanceof ServiceType;
    }

    private void validateServiceReturnType(Object result, int interceptorId, BArray interceptors) {
        if (interceptors != null) {
            if (interceptorId < interceptors.size()) {
                Object interceptor = interceptors.get((long)interceptorId);
                if (result.equals(interceptor)) {
                    this.sendRequestToNextService();
                } else {
                    String message = "next interceptor service did not match with the configuration";
                    BError err = HttpUtil.createHttpStatusCodeError(HttpErrorType.INTERNAL_INTERCEPTOR_RETURN_ERROR, message);
                    this.invokeErrorInterceptors(err, true);
                }
            } else {
                Object targetService = this.requestCtx.getNativeData("TARGET_SERVICE");
                if (result.equals(targetService)) {
                    this.sendRequestToNextService();
                } else {
                    String message = "target service did not match with the configuration";
                    BError err = HttpUtil.createHttpStatusCodeError(HttpErrorType.INTERNAL_INTERCEPTOR_RETURN_ERROR, message);
                    this.invokeErrorInterceptors(err, true);
                }
            }
        }
    }

    private void returnResponse(Object result) {
        Object[] paramFeed = new Object[]{result, null, null, null};
        this.invokeBalMethod(paramFeed, "returnResponse");
    }

    @Override
    public void invokeBalMethod(Object[] paramFeed, String methodName) {
        try {
            StrandMetadata metaData = new StrandMetadata(true, null);
            this.runtime.callMethod(this.caller, methodName, metaData, paramFeed);
        }
        catch (BError error) {
            this.cleanupRequestMessage();
            HttpUtil.handleFailure(this.requestMessage, error);
        }
    }

    private int getRequestInterceptorId() {
        return Math.max((Integer)this.requestCtx.getNativeData("REQUEST_INTERCEPTOR_INDEX"), (Integer)this.requestMessage.getProperty("REQUEST_INTERCEPTOR_INDEX"));
    }
}

