/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.api.client.actions;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BTypedesc;
import io.ballerina.stdlib.http.api.DataContext;
import io.ballerina.stdlib.http.api.HttpConstants;
import io.ballerina.stdlib.http.api.HttpErrorType;
import io.ballerina.stdlib.http.api.HttpUtil;
import io.ballerina.stdlib.http.api.client.actions.AbstractHTTPAction;
import io.ballerina.stdlib.http.api.nativeimpl.ExternUtils;
import io.ballerina.stdlib.http.api.nativeimpl.ModuleUtils;
import io.ballerina.stdlib.http.transport.contract.HttpClientConnector;
import io.ballerina.stdlib.http.transport.message.Http2PushPromise;
import io.ballerina.stdlib.http.transport.message.HttpCarbonMessage;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HttpClientAction
extends AbstractHTTPAction {
    public static Object executeClientAction(Environment env, BObject httpClient, BString path, BObject requestObj, BString httpMethod) {
        String url = (String)httpClient.getNativeData("url");
        BMap config = (BMap)httpClient.getNativeData("config");
        HttpClientConnector clientConnector = (HttpClientConnector)httpClient.getNativeData("Client");
        HttpCarbonMessage outboundRequestMsg = HttpClientAction.createOutboundRequestMsg(url, config, path.getValue().replaceAll("(?<!(http:|https:))//", "/"), requestObj);
        outboundRequestMsg.setHttpMethod(httpMethod.getValue());
        return env.yieldAndRun(() -> {
            CompletableFuture<Object> balFuture = new CompletableFuture<Object>();
            DataContext dataContext = new DataContext(env, balFuture, clientConnector, requestObj, outboundRequestMsg);
            HttpClientAction.executeNonBlockingAction(dataContext, false);
            return ExternUtils.getResult(balFuture);
        });
    }

    public static void rejectPromise(BObject clientObj, BObject pushPromiseObj) {
        Http2PushPromise http2PushPromise = HttpUtil.getPushPromise(pushPromiseObj, null);
        if (http2PushPromise == null) {
            throw HttpUtil.createHttpError("invalid push promise");
        }
        HttpClientConnector clientConnector = (HttpClientConnector)clientObj.getNativeData("Client");
        clientConnector.rejectPushResponse(http2PushPromise);
    }

    public static Object postResource(Environment env, BObject client, BArray path, Object message, Object headers, Object mediaType, BTypedesc targetType, BMap params) {
        return HttpClientAction.invokeClientMethod(env, client, HttpClientAction.constructRequestPath(path, params), message, mediaType, headers, targetType, "processPost");
    }

    public static Object post(Environment env, BObject client, BString path, Object message, Object headers, Object mediaType, BTypedesc targetType) {
        return HttpClientAction.invokeClientMethod(env, client, path, message, mediaType, headers, targetType, "processPost");
    }

    public static Object putResource(Environment env, BObject client, BArray path, Object message, Object headers, Object mediaType, BTypedesc targetType, BMap params) {
        return HttpClientAction.invokeClientMethod(env, client, HttpClientAction.constructRequestPath(path, params), message, mediaType, headers, targetType, "processPut");
    }

    public static Object put(Environment env, BObject client, BString path, Object message, Object headers, Object mediaType, BTypedesc targetType) {
        return HttpClientAction.invokeClientMethod(env, client, path, message, mediaType, headers, targetType, "processPut");
    }

    public static Object patchResource(Environment env, BObject client, BArray path, Object message, Object headers, Object mediaType, BTypedesc targetType, BMap params) {
        return HttpClientAction.invokeClientMethod(env, client, HttpClientAction.constructRequestPath(path, params), message, mediaType, headers, targetType, "processPatch");
    }

    public static Object patch(Environment env, BObject client, BString path, Object message, Object headers, Object mediaType, BTypedesc targetType) {
        return HttpClientAction.invokeClientMethod(env, client, path, message, mediaType, headers, targetType, "processPatch");
    }

    public static Object deleteResource(Environment env, BObject client, BArray path, Object message, Object headers, Object mediaType, BTypedesc targetType, BMap params) {
        return HttpClientAction.invokeClientMethod(env, client, HttpClientAction.constructRequestPath(path, params), message, mediaType, headers, targetType, "processDelete");
    }

    public static Object delete(Environment env, BObject client, BString path, Object message, Object headers, Object mediaType, BTypedesc targetType) {
        return HttpClientAction.invokeClientMethod(env, client, path, message, mediaType, headers, targetType, "processDelete");
    }

    public static Object getResource(Environment env, BObject client, BArray path, Object headers, BTypedesc targetType, BMap params) {
        return HttpClientAction.invokeClientMethod(env, client, HttpClientAction.constructRequestPath(path, params), headers, targetType, "processGet");
    }

    public static Object get(Environment env, BObject client, BString path, Object headers, BTypedesc targetType) {
        return HttpClientAction.invokeClientMethod(env, client, path, headers, targetType, "processGet");
    }

    public static Object headResource(Environment env, BObject client, BArray path, Object headers, BMap params) {
        Object[] paramFeed = new Object[]{HttpClientAction.constructRequestPath(path, params), headers};
        return HttpClientAction.invokeClientMethod(env, client, "head", paramFeed);
    }

    public static Object optionsResource(Environment env, BObject client, BArray path, Object headers, BTypedesc targetType, BMap params) {
        return HttpClientAction.invokeClientMethod(env, client, HttpClientAction.constructRequestPath(path, params), headers, targetType, "processOptions");
    }

    public static Object options(Environment env, BObject client, BString path, Object headers, BTypedesc targetType) {
        return HttpClientAction.invokeClientMethod(env, client, path, headers, targetType, "processOptions");
    }

    public static Object execute(Environment env, BObject client, BString httpVerb, BString path, Object message, Object headers, Object mediaType, BTypedesc targetType) {
        Object[] paramFeed = new Object[]{httpVerb, path, message, targetType, mediaType, headers};
        return HttpClientAction.invokeClientMethod(env, client, "processExecute", paramFeed);
    }

    public static Object forward(Environment env, BObject client, BString path, BObject message, BTypedesc targetType) {
        Object[] paramFeed = new Object[]{path, message, targetType};
        return HttpClientAction.invokeClientMethod(env, client, "processForward", paramFeed);
    }

    private static Object invokeClientMethod(Environment env, BObject client, BString path, Object message, BTypedesc targetType, String methodName) {
        Object[] paramFeed = new Object[]{path, message, targetType};
        return HttpClientAction.invokeClientMethod(env, client, methodName, paramFeed);
    }

    private static Object invokeClientMethod(Environment env, BObject client, BString path, Object message, Object mediaType, Object headers, BTypedesc targetType, String methodName) {
        Object[] paramFeed = new Object[]{path, message, targetType, mediaType, headers};
        return HttpClientAction.invokeClientMethod(env, client, methodName, paramFeed);
    }

    private static Object invokeClientMethod(Environment env, BObject client, String methodName, Object[] paramFeed) {
        return env.yieldAndRun(() -> {
            try {
                return env.getRuntime().callMethod(client, methodName, null, paramFeed);
            }
            catch (BError bError) {
                return HttpUtil.createHttpError("client method invocation failed: " + String.valueOf(bError.getErrorMessage()), HttpErrorType.CLIENT_ERROR, bError);
            }
        });
    }

    private static BString constructRequestPath(BArray pathArray, BMap params) {
        String joinedPath = "/" + String.join((CharSequence)"/", HttpClientAction.getPathStringArray(pathArray));
        String queryParams = HttpClientAction.constructQueryString(params);
        if (queryParams.isEmpty()) {
            return StringUtils.fromString((String)joinedPath);
        }
        return StringUtils.fromString((String)(joinedPath + "?" + queryParams));
    }

    private static String[] getPathStringArray(BArray pathArray) {
        int tag = pathArray.getElementType().getTag();
        switch (tag) {
            case 5: {
                return (String[])Arrays.stream(pathArray.getStringArray()).map(String::valueOf).toArray(String[]::new);
            }
            case 1: {
                return (String[])Arrays.stream(pathArray.getIntArray()).mapToObj(String::valueOf).toArray(String[]::new);
            }
            case 3: {
                return (String[])Arrays.stream(pathArray.getFloatArray()).mapToObj(String::valueOf).toArray(String[]::new);
            }
            case 6: {
                boolean[] booleanArray = pathArray.getBooleanArray();
                String[] booleanStringArray = new String[booleanArray.length];
                for (int i = 0; i < booleanArray.length; ++i) {
                    booleanStringArray[i] = String.valueOf(booleanArray[i]);
                }
                return booleanStringArray;
            }
        }
        return (String[])Arrays.stream(pathArray.getValues()).filter(Objects::nonNull).map(String::valueOf).toArray(String[]::new);
    }

    private static String constructQueryString(BMap params) {
        ArrayList<CallSite> queryParams = new ArrayList<CallSite>();
        Map<String, String> annotationValues = HttpClientAction.getQueryNameMapping(params);
        BString[] keys = (BString[])params.getKeys();
        if (keys.length == 0) {
            return "";
        }
        for (BString key : keys) {
            Object value = params.get((Object)key);
            String queryName = key.getValue();
            queryName = annotationValues.getOrDefault(queryName, queryName);
            String valueString = value.toString();
            if (value instanceof BArray) {
                valueString = valueString.substring(1, valueString.length() - 1);
                valueString = valueString.replace("\"", "");
            }
            queryParams.add((CallSite)((Object)(queryName + "=" + valueString)));
        }
        return String.join((CharSequence)"&", queryParams);
    }

    private static Map<String, String> getQueryNameMapping(BMap params) {
        HashMap<String, String> annotationValues = new HashMap<String, String>();
        RecordType queryRecord = (RecordType)params.getType();
        BMap queryFields = queryRecord.getAnnotations();
        for (Map.Entry qField : queryFields.entrySet()) {
            Object[] keys;
            BMap value = (BMap)qField.getValue();
            for (Object annotRef : keys = value.getKeys()) {
                String refRegex = ModuleUtils.getHttpPackageIdentifier() + ":Query";
                Pattern pattern = Pattern.compile(refRegex);
                Matcher matcher = pattern.matcher(annotRef.toString());
                if (!matcher.find()) continue;
                BMap refValue = (BMap)value.get(annotRef);
                HttpClientAction.extractedFieldName(annotationValues, qField, refValue);
            }
        }
        return annotationValues;
    }

    private static void extractedFieldName(Map<String, String> annotationValues, Map.Entry<BString, Object> qField, BMap value) {
        String[] parts = Pattern.compile("(\\$field\\$\\.)").split(qField.getKey().getValue());
        String fieldName = HttpClientAction.unescapeIdentifier(parts[1]);
        Object overrideValue = value.get((Object)HttpConstants.ANN_FIELD_NAME);
        if (!(overrideValue instanceof BString)) {
            return;
        }
        BString overrideName = (BString)overrideValue;
        annotationValues.put(fieldName, overrideName.getValue());
    }

    public static String unescapeIdentifier(String parameterName) {
        return parameterName.replaceAll("\\\\", "");
    }

    private HttpClientAction() {
    }
}

