/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.api.logging.util;

public enum LogLevel {
    OFF(Integer.MAX_VALUE),
    ERROR(1000),
    WARN(900),
    INFO(800),
    DEBUG(700),
    TRACE(600),
    ALL(Integer.MIN_VALUE);

    private int levelValue;

    private LogLevel(int levelValue) {
        this.levelValue = levelValue;
    }

    public int value() {
        return this.levelValue;
    }

    public static LogLevel toLogLevel(String logLevel) {
        LogLevel level;
        try {
            level = LogLevel.valueOf(logLevel);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("invalid log level: " + logLevel);
        }
        return level;
    }
}

