/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.api.nativeimpl;

import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.http.api.HttpUtil;
import io.ballerina.stdlib.http.transport.message.Http2PushPromise;
import java.util.Set;
import java.util.TreeSet;

public class ExternPushPromise {
    public static void addHeader(BObject pushPromiseObj, BString headerName, BString headerValue) {
        Http2PushPromise http2PushPromise = HttpUtil.getPushPromise(pushPromiseObj, HttpUtil.createHttpPushPromise(pushPromiseObj));
        http2PushPromise.addHeader(headerName.getValue(), headerValue.getValue());
    }

    public static BString getHeader(BObject pushPromiseObj, BString headerName) {
        Http2PushPromise http2PushPromise = HttpUtil.getPushPromise(pushPromiseObj, HttpUtil.createHttpPushPromise(pushPromiseObj));
        return StringUtils.fromString((String)http2PushPromise.getHeader(headerName.getValue()));
    }

    public static BArray getHeaderNames(BObject pushPromiseObj) {
        Http2PushPromise http2PushPromise = HttpUtil.getPushPromise(pushPromiseObj, HttpUtil.createHttpPushPromise(pushPromiseObj));
        Set httpHeaderNames = http2PushPromise.getHttpRequest().headers().names();
        if (httpHeaderNames == null || httpHeaderNames.isEmpty()) {
            return StringUtils.fromStringArray((String[])new String[0]);
        }
        TreeSet distinctNames = new TreeSet(String.CASE_INSENSITIVE_ORDER);
        distinctNames.addAll(httpHeaderNames);
        return StringUtils.fromStringSet(distinctNames);
    }

    public static BArray getHeaders(BObject pushPromiseObj, BString headerName) {
        Http2PushPromise http2PushPromise = HttpUtil.getPushPromise(pushPromiseObj, HttpUtil.createHttpPushPromise(pushPromiseObj));
        String[] headers = http2PushPromise.getHeaders(headerName.getValue());
        return StringUtils.fromStringArray((String[])headers);
    }

    public static boolean hasHeader(BObject pushPromiseObj, BString headerName) {
        Http2PushPromise http2PushPromise = HttpUtil.getPushPromise(pushPromiseObj, HttpUtil.createHttpPushPromise(pushPromiseObj));
        return http2PushPromise.getHeader(headerName.getValue()) != null;
    }

    public static void removeAllHeaders(BObject pushPromiseObj) {
        Http2PushPromise http2PushPromise = HttpUtil.getPushPromise(pushPromiseObj, HttpUtil.createHttpPushPromise(pushPromiseObj));
        http2PushPromise.removeAllHeaders();
    }

    public static void removeHeader(BObject pushPromiseObj, BString headerName) {
        Http2PushPromise http2PushPromise = HttpUtil.getPushPromise(pushPromiseObj, HttpUtil.createHttpPushPromise(pushPromiseObj));
        http2PushPromise.removeHeader(headerName.getValue());
    }

    public static void setHeader(BObject pushPromiseObj, BString headerName, BString headerValue) {
        Http2PushPromise http2PushPromise = HttpUtil.getPushPromise(pushPromiseObj, HttpUtil.createHttpPushPromise(pushPromiseObj));
        http2PushPromise.setHeader(headerName.getValue(), headerValue.getValue());
    }

    private ExternPushPromise() {
    }
}

