/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.api.nativeimpl.connection;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.Runtime;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.observability.ObserveUtils;
import io.ballerina.runtime.observability.ObserverContext;
import io.ballerina.stdlib.http.api.BallerinaConnectorException;
import io.ballerina.stdlib.http.api.DataContext;
import io.ballerina.stdlib.http.api.HTTPInterceptorServicesRegistry;
import io.ballerina.stdlib.http.api.HttpConstants;
import io.ballerina.stdlib.http.api.HttpDispatcher;
import io.ballerina.stdlib.http.api.HttpErrorType;
import io.ballerina.stdlib.http.api.HttpResponseInterceptorUnitCallback;
import io.ballerina.stdlib.http.api.HttpUtil;
import io.ballerina.stdlib.http.api.InterceptorService;
import io.ballerina.stdlib.http.api.client.caching.ResponseCacheControlObj;
import io.ballerina.stdlib.http.api.nativeimpl.ExternUtils;
import io.ballerina.stdlib.http.api.nativeimpl.connection.ConnectionAction;
import io.ballerina.stdlib.http.api.nativeimpl.pipelining.PipelinedResponse;
import io.ballerina.stdlib.http.api.nativeimpl.pipelining.PipeliningHandler;
import io.ballerina.stdlib.http.api.util.CacheUtils;
import io.ballerina.stdlib.http.transport.message.HttpCarbonMessage;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Respond
extends ConnectionAction {
    private static final Logger log = LoggerFactory.getLogger(Respond.class);

    public static Object nativeRespondError(Environment env, BObject connectionObj, BObject outboundResponseObj, BError error) {
        HttpCarbonMessage inboundRequest = HttpUtil.getCarbonMsg(connectionObj, null);
        inboundRequest.setProperty("INTERCEPTOR_SERVICE_ERROR", (Object)error);
        return Respond.nativeRespond(env, connectionObj, outboundResponseObj);
    }

    public static Object nativeRespond(Environment env, BObject connectionObj, BObject outboundResponseObj) {
        HttpCarbonMessage inboundRequestMsg = HttpUtil.getCarbonMsg(connectionObj, null);
        if (Respond.invokeResponseInterceptor(env, inboundRequestMsg, outboundResponseObj, connectionObj)) {
            return null;
        }
        return Respond.nativeRespondInternal(env, connectionObj, outboundResponseObj, inboundRequestMsg);
    }

    public static Object nativeRespondInternal(Environment env, BObject connectionObj, BObject outboundResponseObj, HttpCarbonMessage inboundRequestMsg) {
        if (Respond.isDirtyResponse(outboundResponseObj)) {
            String errorMessage = "Couldn't complete the respond operation as the response has been already used.";
            HttpUtil.sendOutboundResponse(inboundRequestMsg, HttpUtil.createErrorMessage(errorMessage, 500));
            if (log.isDebugEnabled()) {
                log.debug("Couldn't complete the respond operation for the sequence id of the request: {} as the response has been already used.", (Object)inboundRequestMsg.getSequenceId());
            }
            return HttpUtil.createHttpError(errorMessage, HttpErrorType.GENERIC_LISTENER_ERROR);
        }
        outboundResponseObj.addNativeData("dirtyResponse", (Object)true);
        HttpCarbonMessage outboundResponseMsg = HttpUtil.getCarbonMsg(outboundResponseObj, HttpUtil.createHttpCarbonMessage(false));
        outboundResponseMsg.setPipeliningEnabled(inboundRequestMsg.isPipeliningEnabled());
        outboundResponseMsg.setSequenceId(inboundRequestMsg.getSequenceId());
        Respond.setCacheControlHeader(outboundResponseObj, outboundResponseMsg);
        HttpUtil.prepareOutboundResponse(connectionObj, inboundRequestMsg, outboundResponseMsg, outboundResponseObj);
        try {
            HttpUtil.checkFunctionValidity(inboundRequestMsg, outboundResponseMsg);
        }
        catch (BError e) {
            log.debug(e.getPrintableStackTrace(), (Throwable)e);
            return e;
        }
        if (CacheUtils.isValidCachedResponse(outboundResponseMsg, inboundRequestMsg)) {
            outboundResponseMsg.setHttpStatusCode(HttpResponseStatus.NOT_MODIFIED.code());
            outboundResponseMsg.setProperty("HTTP_REASON_PHRASE", HttpResponseStatus.NOT_MODIFIED.reasonPhrase());
            outboundResponseMsg.removeHeader(HttpHeaderNames.CONTENT_LENGTH.toString());
            outboundResponseMsg.removeHeader(HttpHeaderNames.CONTENT_TYPE.toString());
            outboundResponseMsg.waitAndReleaseAllEntities();
            outboundResponseMsg.completeMessage();
        }
        if (ObserveUtils.isObservabilityEnabled()) {
            int statusCode = (int)outboundResponseObj.getIntValue(HttpConstants.RESPONSE_STATUS_CODE_FIELD);
            ObserverContext observerContext = ObserveUtils.getObserverContextOfCurrentFrame((Environment)env);
            if (observerContext != null) {
                observerContext.addProperty("_http_status_code_", (Object)statusCode);
            }
            if ((observerContext = (ObserverContext)inboundRequestMsg.getProperty("observabilityContext")) != null) {
                observerContext.addProperty("_http_status_code_", (Object)statusCode);
            }
        }
        return env.yieldAndRun(() -> {
            try {
                CompletableFuture<Object> balFuture = new CompletableFuture<Object>();
                DataContext dataContext = new DataContext(env, balFuture, HttpUtil.getCarbonMsg(connectionObj, null));
                if (PipeliningHandler.pipeliningRequired(inboundRequestMsg)) {
                    if (log.isDebugEnabled()) {
                        log.debug("Pipelining is required. Sequence id of the request: {}", (Object)inboundRequestMsg.getSequenceId());
                    }
                    PipelinedResponse pipelinedResponse = new PipelinedResponse(inboundRequestMsg, outboundResponseMsg, dataContext, outboundResponseObj);
                    PipeliningHandler.setPipeliningListener(outboundResponseMsg);
                    PipeliningHandler.executePipeliningLogic(inboundRequestMsg.getSourceContext(), pipelinedResponse);
                } else {
                    Respond.sendOutboundResponseRobust(dataContext, inboundRequestMsg, outboundResponseObj, outboundResponseMsg);
                }
                return ExternUtils.getResult(balFuture);
            }
            catch (BError e) {
                log.debug(e.getPrintableStackTrace(), (Throwable)e);
                return HttpUtil.createHttpError(e.getMessage(), HttpErrorType.GENERIC_LISTENER_ERROR);
            }
            catch (Throwable e) {
                String errorMessage = "Couldn't complete outbound response: " + e.getMessage();
                log.debug(errorMessage, e);
                return HttpUtil.createHttpError(errorMessage, HttpErrorType.GENERIC_LISTENER_ERROR);
            }
        });
    }

    private static void setCacheControlHeader(BObject outboundRespObj, HttpCarbonMessage outboundResponse) {
        BObject cacheControl = (BObject)outboundRespObj.get(HttpConstants.RESPONSE_CACHE_CONTROL_FIELD);
        if (cacheControl != null && outboundResponse.getHeader(HttpHeaderNames.CACHE_CONTROL.toString()) == null) {
            ResponseCacheControlObj respCC = new ResponseCacheControlObj(cacheControl);
            outboundResponse.setHeader(HttpHeaderNames.CACHE_CONTROL.toString(), respCC.buildCacheControlDirectives());
        }
    }

    private static boolean isDirtyResponse(BObject outboundResponseObj) {
        return outboundResponseObj.get(HttpConstants.RESPONSE_CACHE_CONTROL_FIELD) == null && outboundResponseObj.getNativeData("dirtyResponse") != null;
    }

    private Respond() {
    }

    public static boolean invokeResponseInterceptor(Environment env, HttpCarbonMessage inboundMessage, BObject outboundResponseObj, BObject callerObj) {
        List interceptorServicesRegistries = (List)inboundMessage.getProperty("INTERCEPTOR_SERVICES_REGISTRIES");
        if (interceptorServicesRegistries.isEmpty()) {
            return false;
        }
        int interceptorServiceIndex = Respond.getResponseInterceptorIndex(inboundMessage, interceptorServicesRegistries.size());
        while (interceptorServiceIndex >= 0) {
            HTTPInterceptorServicesRegistry interceptorServicesRegistry = (HTTPInterceptorServicesRegistry)interceptorServicesRegistries.get(interceptorServiceIndex);
            if (!interceptorServicesRegistry.getServicesType().equals(inboundMessage.getResponseInterceptorServiceState())) {
                inboundMessage.setProperty("RESPONSE_INTERCEPTOR_INDEX", --interceptorServiceIndex);
                continue;
            }
            try {
                InterceptorService service = HttpDispatcher.findInterceptorService(interceptorServicesRegistry, inboundMessage, true);
                if (service == null) {
                    throw new BallerinaConnectorException("no Interceptor Service found to handle the response");
                }
                if (interceptorServiceIndex == 0 && inboundMessage.isInterceptorInternalError()) {
                    BError bError = (BError)((Object)inboundMessage.getProperty("INTERCEPTOR_SERVICE_ERROR"));
                    bError.printStackTrace();
                }
                inboundMessage.setProperty("RESPONSE_INTERCEPTOR_INDEX", --interceptorServiceIndex);
                Respond.startInterceptResponseMethod(inboundMessage, outboundResponseObj, callerObj, service, env, interceptorServicesRegistry);
                return true;
            }
            catch (Exception e) {
                throw HttpUtil.createHttpError(e.getMessage(), HttpErrorType.GENERIC_LISTENER_ERROR);
            }
        }
        if (inboundMessage.isInterceptorError()) {
            HttpResponseInterceptorUnitCallback callback = new HttpResponseInterceptorUnitCallback(inboundMessage, callerObj, outboundResponseObj, env, null, false);
            callback.sendFailureResponse((BError)((Object)inboundMessage.getProperty("INTERCEPTOR_SERVICE_ERROR")));
        }
        return false;
    }

    private static int getResponseInterceptorIndex(HttpCarbonMessage inboundMessage, int interceptorsCount) {
        if (inboundMessage.getProperty("RESPONSE_INTERCEPTOR_INDEX") != null) {
            return (Integer)inboundMessage.getProperty("RESPONSE_INTERCEPTOR_INDEX");
        }
        if (inboundMessage.getProperty("REQUEST_INTERCEPTOR_INDEX") != null) {
            return (Integer)inboundMessage.getProperty("REQUEST_INTERCEPTOR_INDEX") - 1;
        }
        return interceptorsCount - 1;
    }

    private static void startInterceptResponseMethod(HttpCarbonMessage inboundMessage, BObject outboundResponseObj, BObject callerObj, InterceptorService service, Environment env, HTTPInterceptorServicesRegistry interceptorServicesRegistry) {
        BObject serviceObj = service.getBalService();
        Runtime runtime = interceptorServicesRegistry.getRuntime();
        Object[] signatureParams = HttpDispatcher.getRemoteSignatureParameters(service, outboundResponseObj, callerObj, inboundMessage, runtime);
        HttpResponseInterceptorUnitCallback callback = new HttpResponseInterceptorUnitCallback(inboundMessage, callerObj, outboundResponseObj, env, runtime, interceptorServicesRegistry.isPossibleLastInterceptor());
        inboundMessage.removeProperty("INTERCEPTOR_SERVICE_ERROR");
        String methodName = service.getServiceType().equals("ResponseErrorInterceptor") ? "interceptResponseError" : "interceptResponse";
        try {
            Object result = runtime.callMethod(serviceObj, methodName, null, signatureParams);
            callback.handleResult(result);
        }
        catch (BError bError) {
            callback.handlePanic(bError);
        }
    }
}

