/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.api.nativeimpl.connection;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.http.api.DataContext;
import io.ballerina.stdlib.http.api.HttpErrorType;
import io.ballerina.stdlib.http.api.HttpUtil;
import io.ballerina.stdlib.http.transport.contract.HttpConnectorListener;
import io.ballerina.stdlib.http.transport.contract.HttpResponseFuture;
import io.ballerina.stdlib.http.transport.message.HttpCarbonMessage;
import io.ballerina.stdlib.http.transport.message.HttpMessageDataStreamer;
import io.ballerina.stdlib.http.transport.message.PooledDataStreamerFactory;
import io.ballerina.stdlib.mime.util.EntityBodyHandler;
import io.ballerina.stdlib.mime.util.HeaderUtil;
import io.ballerina.stdlib.mime.util.MultipartDataSource;
import java.io.IOException;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseWriter {
    private static final Logger log = LoggerFactory.getLogger(ResponseWriter.class);

    public static void sendResponseRobust(DataContext dataContext, HttpCarbonMessage requestMessage, BObject outboundResponse, HttpCarbonMessage responseMessage) {
        String contentType = HttpUtil.getContentTypeFromTransportMessage(responseMessage);
        String boundaryString = null;
        if (HeaderUtil.isMultipart((String)contentType)) {
            boundaryString = HttpUtil.addBoundaryIfNotExist(responseMessage, contentType);
        }
        HttpMessageDataStreamer outboundMsgDataStreamer = ResponseWriter.getResponseDataStreamer(responseMessage);
        BObject entityObj = HttpUtil.extractEntity(outboundResponse);
        if (entityObj == null) {
            responseMessage.setPassthrough(true);
        }
        HttpResponseFuture outboundRespStatusFuture = HttpUtil.sendOutboundResponse(requestMessage, responseMessage);
        HttpResponseConnectorListener outboundResStatusConnectorListener = new HttpResponseConnectorListener(dataContext, outboundMsgDataStreamer);
        outboundRespStatusFuture.setHttpConnectorListener(outboundResStatusConnectorListener);
        OutputStream messageOutputStream = outboundMsgDataStreamer.getOutputStream();
        if (entityObj != null) {
            if (boundaryString != null) {
                ResponseWriter.serializeMultiparts(dataContext.getEnvironment(), boundaryString, entityObj, messageOutputStream);
            } else {
                Object outboundMessageSource = EntityBodyHandler.getMessageDataSource((BObject)entityObj);
                ResponseWriter.serializeDataSource(dataContext.getEnvironment(), outboundMessageSource, entityObj, messageOutputStream);
            }
        }
    }

    private static void serializeMultiparts(Environment env, String boundaryString, BObject entity, OutputStream messageOutputStream) {
        BArray bodyParts = EntityBodyHandler.getBodyPartArray((BObject)entity);
        if (bodyParts != null && bodyParts.size() > 0) {
            MultipartDataSource multipartDataSource = new MultipartDataSource(env, entity, boundaryString);
            multipartDataSource.serialize(messageOutputStream);
            HttpUtil.closeMessageOutputStream(messageOutputStream);
        } else {
            ResponseWriter.serializeDataSource(env, EntityBodyHandler.getMessageDataSource((BObject)entity), entity, messageOutputStream);
        }
    }

    static void serializeDataSource(Environment env, Object outboundMessageSource, BObject entity, OutputStream messageOutputStream) {
        try {
            if (outboundMessageSource != null) {
                HttpUtil.serializeDataSource(outboundMessageSource, entity, messageOutputStream);
                HttpUtil.closeMessageOutputStream(messageOutputStream);
            } else if (EntityBodyHandler.getEventStream((BObject)entity) != null) {
                EntityBodyHandler.writeEventStreamToOutputStream((Environment)env, (BObject)entity, (OutputStream)messageOutputStream);
            } else if (EntityBodyHandler.getByteStream((BObject)entity) != null) {
                EntityBodyHandler.writeByteStreamToOutputStream((Environment)env, (BObject)entity, (OutputStream)messageOutputStream);
                HttpUtil.closeMessageOutputStream(messageOutputStream);
            } else if (EntityBodyHandler.getByteChannel((BObject)entity) != null) {
                EntityBodyHandler.writeByteChannelToOutputStream((BObject)entity, (OutputStream)messageOutputStream);
                HttpUtil.closeMessageOutputStream(messageOutputStream);
            } else {
                log.debug("Entity does not have a serializable payload");
            }
        }
        catch (IOException ex) {
            throw ErrorCreator.createError((BString)StringUtils.fromString((String)"SerializationError"), (BString)StringUtils.fromString((String)("error occurred while serializing message data source : " + ex.getMessage())));
        }
    }

    static HttpMessageDataStreamer getResponseDataStreamer(HttpCarbonMessage outboundResponse) {
        PooledDataStreamerFactory pooledDataStreamerFactory = (PooledDataStreamerFactory)outboundResponse.getProperty("POOLED_BYTE_BUFFER_FACTORY");
        HttpMessageDataStreamer outboundMsgDataStreamer = pooledDataStreamerFactory != null ? pooledDataStreamerFactory.createHttpDataStreamer(outboundResponse) : new HttpMessageDataStreamer(outboundResponse);
        return outboundMsgDataStreamer;
    }

    private ResponseWriter() {
    }

    static class HttpResponseConnectorListener
    implements HttpConnectorListener {
        private final DataContext dataContext;
        private HttpMessageDataStreamer outboundMsgDataStreamer;

        HttpResponseConnectorListener(DataContext dataContext) {
            this.dataContext = dataContext;
        }

        HttpResponseConnectorListener(DataContext dataContext, HttpMessageDataStreamer outboundMsgDataStreamer) {
            this.dataContext = dataContext;
            this.outboundMsgDataStreamer = outboundMsgDataStreamer;
        }

        @Override
        public void onMessage(HttpCarbonMessage httpCarbonMessage) {
            this.dataContext.notifyOutboundResponseStatus(null);
        }

        @Override
        public void onError(Throwable throwable) {
            BError httpConnectorError = HttpUtil.createHttpError(throwable.getMessage(), HttpErrorType.GENERIC_LISTENER_ERROR);
            if (this.outboundMsgDataStreamer != null && !(throwable instanceof IOException)) {
                this.dataContext.getOutboundRequest().setIoException(new IOException(throwable.getMessage(), throwable));
            }
            this.dataContext.notifyOutboundResponseStatus(httpConnectorError);
        }
    }
}

