/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.api.service.endpoint;

import io.ballerina.runtime.api.values.BObject;
import io.ballerina.stdlib.http.api.HTTPInterceptorServicesRegistry;
import io.ballerina.stdlib.http.api.HTTPServicesRegistry;
import io.ballerina.stdlib.http.transport.contract.ServerConnector;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractHttpNativeFunction {
    protected static HTTPServicesRegistry getHttpServicesRegistry(BObject serviceEndpoint) {
        return (HTTPServicesRegistry)serviceEndpoint.getNativeData("HTTP_SERVICE_REGISTRY");
    }

    public static List<HTTPInterceptorServicesRegistry> getHttpInterceptorServicesRegistries(BObject serviceEndpoint) {
        return (List)serviceEndpoint.getNativeData("INTERCEPTOR_SERVICES_REGISTRIES");
    }

    protected static ServerConnector getServerConnector(BObject serviceEndpoint) {
        return (ServerConnector)serviceEndpoint.getNativeData("HTTP_SERVER_CONNECTOR");
    }

    static boolean isConnectorStarted(BObject serviceEndpoint) {
        return serviceEndpoint.getNativeData("CONNECTOR_STARTED") != null && (Boolean)serviceEndpoint.getNativeData("CONNECTOR_STARTED") != false;
    }

    static void resetRegistry(BObject serviceEndpoint) {
        HTTPServicesRegistry httpServicesRegistry = new HTTPServicesRegistry();
        serviceEndpoint.addNativeData("HTTP_SERVICE_REGISTRY", (Object)httpServicesRegistry);
    }

    public static void resetInterceptorRegistry(BObject serviceEndpoint, int interceptorsSize) {
        ArrayList<HTTPInterceptorServicesRegistry> httpInterceptorServicesRegistries = new ArrayList<HTTPInterceptorServicesRegistry>();
        for (int i = 0; i < interceptorsSize; ++i) {
            httpInterceptorServicesRegistries.add(new HTTPInterceptorServicesRegistry());
        }
        serviceEndpoint.addNativeData("INTERCEPTOR_SERVICES_REGISTRIES", httpInterceptorServicesRegistries);
    }
}

