/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.api.service.signature;

import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.FunctionType;
import io.ballerina.runtime.api.types.MapType;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.ResourceMethodType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.IdentifierUtils;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BTypedesc;
import io.ballerina.stdlib.http.api.HttpConstants;
import io.ballerina.stdlib.http.api.HttpErrorType;
import io.ballerina.stdlib.http.api.HttpUtil;
import io.ballerina.stdlib.http.api.nativeimpl.ModuleUtils;
import io.ballerina.stdlib.http.api.service.signature.AllHeaderParams;
import io.ballerina.stdlib.http.api.service.signature.AllPathParams;
import io.ballerina.stdlib.http.api.service.signature.AllQueryParams;
import io.ballerina.stdlib.http.api.service.signature.HeaderParam;
import io.ballerina.stdlib.http.api.service.signature.NonRecurringParam;
import io.ballerina.stdlib.http.api.service.signature.Parameter;
import io.ballerina.stdlib.http.api.service.signature.PathParam;
import io.ballerina.stdlib.http.api.service.signature.PayloadParam;
import io.ballerina.stdlib.http.api.service.signature.QueryParam;
import io.ballerina.stdlib.http.uri.URIUtil;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ParamHandler {
    private final Type[] paramTypes;
    private final int pathParamCount;
    private Type callerInfoType = null;
    private final ResourceMethodType resource;
    private final List<Parameter> paramList = new ArrayList<Parameter>();
    private PayloadParam payloadParam = null;
    private NonRecurringParam callerParam = null;
    private NonRecurringParam requestParam = null;
    private NonRecurringParam headerObjectParam = null;
    private NonRecurringParam requestContextParam = null;
    private NonRecurringParam interceptorErrorParam = null;
    private final AllPathParams pathParams = new AllPathParams();
    private final AllQueryParams queryParams = new AllQueryParams();
    private final AllHeaderParams headerParams = new AllHeaderParams();
    private final boolean constraintValidation;
    private final boolean laxDataBinding;
    private static final String PARAM_ANNOT_PREFIX = "$param$.";
    private static final MapType MAP_TYPE = TypeCreator.createMapType((Type)TypeCreator.createArrayType((Type)PredefinedTypes.TYPE_STRING));
    private static final String CALLER_TYPE = "http:Caller";
    private static final String REQ_TYPE = "http:Request";
    private static final String HEADERS_TYPE = "http:Headers";
    private static final String REQUEST_CONTEXT_TYPE = "http:RequestContext";
    private static final String CALLER_ANNOTATION = ModuleUtils.getHttpPackageIdentifier() + ":CallerInfo";
    public static final String PAYLOAD_ANNOTATION = ModuleUtils.getHttpPackageIdentifier() + ":Payload";
    public static final String HEADER_ANNOTATION = ModuleUtils.getHttpPackageIdentifier() + ":Header";
    public static final String CALLER_INFO_ANNOTATION = ModuleUtils.getHttpPackageIdentifier() + ":CallerInfo";
    public static final String CACHE_ANNOTATION = ModuleUtils.getHttpPackageIdentifier() + ":Cache";
    public static final String QUERY_ANNOTATION = ModuleUtils.getHttpPackageIdentifier() + ":Query";

    public ParamHandler(ResourceMethodType resource, int pathParamCount, boolean constraintValidation, boolean laxDataBinding) {
        this.resource = resource;
        this.pathParamCount = pathParamCount;
        this.paramTypes = HttpUtil.getParameterTypes((FunctionType)resource);
        this.constraintValidation = constraintValidation;
        this.laxDataBinding = laxDataBinding;
        this.populatePathParamTokens(resource, pathParamCount);
        this.populatePayloadAndHeaderParamTokens(resource);
        this.validateSignatureParams();
    }

    private void populatePathParamTokens(ResourceMethodType resource, int pathParamCount) {
        if (pathParamCount == 0) {
            return;
        }
        for (int index = 0; index < pathParamCount; ++index) {
            this.createPathParam(index, resource, this.constraintValidation);
        }
        if (this.pathParams.isNotEmpty()) {
            this.getParamList().add(this.pathParams);
        }
    }

    private void validateSignatureParams() {
        if (this.paramTypes.length == this.pathParamCount) {
            return;
        }
        Type[] originalParameterTypes = HttpUtil.getOriginalParameterTypes((FunctionType)this.resource);
        block14: for (int index = this.pathParamCount; index < this.paramTypes.length; ++index) {
            String typeName;
            Type parameterType = this.paramTypes[index];
            switch (typeName = parameterType.toString()) {
                case "http:RequestContext": {
                    if (this.requestContextParam == null) {
                        this.requestContextParam = new NonRecurringParam(index, "RequestContext");
                        this.getParamList().add(this.requestContextParam);
                        continue block14;
                    }
                    throw HttpUtil.createHttpError("invalid multiple 'http:RequestContext' parameter");
                }
                case "error": {
                    if (this.interceptorErrorParam == null) {
                        this.interceptorErrorParam = new NonRecurringParam(index, "error");
                        this.getParamList().add(this.interceptorErrorParam);
                        continue block14;
                    }
                    throw HttpUtil.createHttpError("invalid multiple 'error' parameter");
                }
                case "http:Caller": {
                    if (this.callerParam == null) {
                        this.callerParam = new NonRecurringParam(index, "Caller");
                        this.getParamList().add(this.callerParam);
                        continue block14;
                    }
                    throw HttpUtil.createHttpError("invalid multiple 'http:Caller' parameter");
                }
                case "http:Request": {
                    if (this.requestParam == null) {
                        this.requestParam = new NonRecurringParam(index, "Request");
                        this.getParamList().add(this.requestParam);
                        continue block14;
                    }
                    throw HttpUtil.createHttpError("invalid multiple 'http:Request' parameter");
                }
                case "http:Headers": {
                    if (this.headerObjectParam == null) {
                        this.headerObjectParam = new NonRecurringParam(index, "Headers");
                        this.getParamList().add(this.headerObjectParam);
                        continue block14;
                    }
                    throw HttpUtil.createHttpError("invalid multiple 'http:Headers' parameter");
                }
                default: {
                    String paramName = HttpUtil.unescapeAndEncodeValue(this.resource.getParamNames()[index]);
                    if (this.payloadParam != null && paramName.equals(this.payloadParam.getToken())) {
                        this.payloadParam.init(parameterType, originalParameterTypes[index], index);
                        this.getParamList().add(this.payloadParam);
                        continue block14;
                    }
                    HeaderParam headerParam = this.headerParams.get(paramName);
                    if (headerParam != null) {
                        headerParam.initHeaderParam(originalParameterTypes[index], index, this.constraintValidation);
                        continue block14;
                    }
                    this.createQueryParam(index, this.resource, originalParameterTypes[index]);
                }
            }
        }
        if (this.queryParams.isNotEmpty()) {
            this.getParamList().add(this.queryParams);
        }
        if (this.headerParams.isNotEmpty()) {
            this.getParamList().add(this.headerParams);
        }
    }

    private void populatePayloadAndHeaderParamTokens(ResourceMethodType balResource) {
        for (String paramName : balResource.getParamNames()) {
            BMap annotations = (BMap)balResource.getAnnotation(StringUtils.fromString((String)(PARAM_ANNOT_PREFIX + IdentifierUtils.escapeSpecialCharacters((String)(paramName = HttpUtil.unescapeAndEncodeValue(paramName))))));
            if (annotations == null) continue;
            Object[] annotationsKeys = annotations.getKeys();
            this.validateForMultipleHTTPAnnotationsOnSingleParam(annotationsKeys, paramName);
            for (Object objKey : annotationsKeys) {
                BMap callerInfo;
                Object respondType;
                String key = ((BString)objKey).getValue();
                if (PAYLOAD_ANNOTATION.equals(key)) {
                    if (this.payloadParam == null) {
                        this.createPayloadParam(paramName, annotations, this.constraintValidation, this.laxDataBinding);
                        continue;
                    }
                    throw HttpUtil.createHttpError("invalid multiple 'http:Payload' annotation usage");
                }
                if (HEADER_ANNOTATION.equals(key)) {
                    this.createHeaderParam(paramName, annotations);
                    continue;
                }
                if (!CALLER_INFO_ANNOTATION.equals(key) || !((respondType = (callerInfo = annotations.getMapValue(StringUtils.fromString((String)CALLER_INFO_ANNOTATION))).get((Object)HttpConstants.ANN_FIELD_RESPOND_TYPE)) instanceof BTypedesc)) continue;
                this.callerInfoType = TypeUtils.getReferredType((Type)((BTypedesc)respondType).getDescribingType());
            }
        }
    }

    private void validateForMultipleHTTPAnnotationsOnSingleParam(Object[] annotationsKeys, String paramName) {
        boolean alreadyAnnotated = false;
        for (Object objKey : annotationsKeys) {
            String key = ((BString)objKey).getValue();
            if (alreadyAnnotated && this.isAllowedResourceParamAnnotation(key)) {
                throw HttpUtil.createHttpError("cannot specify more than one http annotation for parameter '" + paramName + "'");
            }
            if (alreadyAnnotated || !this.isAllowedResourceParamAnnotation(key)) continue;
            alreadyAnnotated = true;
        }
    }

    private boolean isAllowedResourceParamAnnotation(String key) {
        return PAYLOAD_ANNOTATION.equals(key) || CALLER_ANNOTATION.equals(key) || HEADER_ANNOTATION.equals(key);
    }

    private void createPayloadParam(String paramName, BMap annotations, boolean constraintValidation, boolean laxDataBinding) {
        Object[] value;
        this.payloadParam = new PayloadParam(paramName, constraintValidation, laxDataBinding);
        BMap mapValue = annotations.getMapValue(StringUtils.fromString((String)PAYLOAD_ANNOTATION));
        Object mediaType = mapValue.get((Object)HttpConstants.ANN_FIELD_MEDIA_TYPE);
        if (mediaType instanceof BString) {
            String value2 = ((BString)mediaType).getValue();
            this.payloadParam.getMediaTypes().add(value2);
        } else if (mediaType instanceof BArray && (value = ((BArray)mediaType).getStringArray()).length != 0) {
            this.payloadParam.getMediaTypes().add(Arrays.toString(value));
        }
    }

    private void createPathParam(int index, ResourceMethodType balResource, boolean constraintValidation) {
        io.ballerina.runtime.api.types.Parameter parameter = balResource.getParameters()[index];
        PathParam pathParam = new PathParam(parameter.type, parameter.name, index, constraintValidation);
        this.pathParams.add(pathParam);
    }

    private void createHeaderParam(String paramName, BMap annotations) {
        HeaderParam headerParam = new HeaderParam(paramName);
        BMap mapValue = annotations.getMapValue(StringUtils.fromString((String)HEADER_ANNOTATION));
        Object headerName = mapValue.get((Object)HttpConstants.ANN_FIELD_NAME);
        if (headerName instanceof BString) {
            String value = ((BString)headerName).getValue();
            headerParam.setHeaderName(value);
        } else {
            headerParam.setHeaderName(HttpUtil.unescapeAndEncodeValue(paramName));
        }
        this.headerParams.add(headerParam);
    }

    private void createQueryParam(int index, ResourceMethodType balResource, Type originalType) {
        io.ballerina.runtime.api.types.Parameter parameter = balResource.getParameters()[index];
        String paramName = parameter.name;
        BMap annotations = (BMap)balResource.getAnnotation(StringUtils.fromString((String)(PARAM_ANNOT_PREFIX + IdentifierUtils.escapeSpecialCharacters((String)paramName))));
        if (annotations != null) {
            String queryParamName = ParamHandler.getQueryParamName(paramName, annotations);
            paramName = queryParamName.isBlank() ? paramName : queryParamName;
        }
        paramName = HttpUtil.unescapeAndEncodeValue(paramName);
        QueryParam queryParam = new QueryParam(originalType, paramName, index, parameter.isDefault, this.constraintValidation);
        this.queryParams.add(queryParam);
    }

    private static String getQueryParamName(String paramName, BMap annotations) {
        BMap mapValue = annotations.getMapValue(StringUtils.fromString((String)QUERY_ANNOTATION));
        Object queryName = mapValue.get((Object)HttpConstants.ANN_FIELD_NAME);
        if (queryName instanceof BString) {
            BString query = (BString)queryName;
            return query.getValue();
        }
        return paramName;
    }

    public boolean isPayloadBindingRequired() {
        return this.payloadParam != null;
    }

    public List<Parameter> getParamList() {
        return this.paramList;
    }

    public BMap<BString, Object> getQueryParams(Object rawQueryString) {
        BMap queryParams = ValueCreator.createMapValue((MapType)MAP_TYPE);
        if (rawQueryString != null) {
            try {
                URIUtil.populateQueryParamMap((String)rawQueryString, (BMap<BString, Object>)queryParams);
            }
            catch (UnsupportedEncodingException e) {
                throw HttpUtil.createHttpError("error while retrieving query param from message: " + e.getMessage(), HttpErrorType.GENERIC_LISTENER_ERROR);
            }
        }
        return queryParams;
    }

    public Type getCallerInfoType() {
        return this.callerInfoType;
    }
}

