/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.api.service.signature;

import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.stdlib.constraint.Constraints;
import io.ballerina.stdlib.http.api.HttpErrorType;
import io.ballerina.stdlib.http.api.HttpUtil;
import io.ballerina.stdlib.http.api.service.signature.SignatureParam;

public class QueryParam
extends SignatureParam {
    private final boolean nilable;
    private final boolean defaultable;

    QueryParam(Type originalType, String token, int index, boolean defaultable, boolean requireConstraintValidation) {
        super(originalType, token, index, requireConstraintValidation, "query");
        this.nilable = originalType.isNilable();
        this.defaultable = defaultable;
    }

    public boolean isNilable() {
        return this.nilable;
    }

    public boolean isDefaultable() {
        return this.defaultable;
    }

    @Override
    public Object validateConstraints(Object queryValue) {
        Object result;
        if (this.requireConstraintValidation() && (result = Constraints.validateAfterTypeConversion((Object)queryValue, (Type)this.getOriginalType())) instanceof BError) {
            String message = "query validation failed: " + HttpUtil.getPrintableErrorMsg((BError)((Object)result));
            throw HttpUtil.createHttpStatusCodeError(HttpErrorType.INTERNAL_QUERY_PARAM_VALIDATION_ERROR, message);
        }
        return queryValue;
    }
}

