/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.api.service.signature.builder;

import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.MapType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.UnionType;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.http.api.HttpErrorType;
import io.ballerina.stdlib.http.api.HttpUtil;
import io.ballerina.stdlib.http.api.service.signature.builder.AbstractPayloadBuilder;
import io.ballerina.stdlib.http.api.service.signature.converter.StringToByteArrayConverter;
import io.ballerina.stdlib.http.api.service.signature.converter.UrlEncodedStringToMapConverter;
import io.ballerina.stdlib.mime.util.EntityBodyHandler;
import java.util.List;

public class StringPayloadBuilder
extends AbstractPayloadBuilder {
    private final Type payloadType;

    public StringPayloadBuilder(Type payloadType) {
        this.payloadType = payloadType;
    }

    @Override
    public Object getValue(BObject entity, boolean readonly) {
        BString dataSource = EntityBodyHandler.constructStringDataSource((BObject)entity);
        EntityBodyHandler.addMessageDataSource((BObject)entity, (Object)dataSource);
        return this.createValue(this.payloadType, readonly, dataSource);
    }

    private Object createValue(Type payloadType, boolean readonly, BString dataSource) {
        if (payloadType.getTag() == 5 || payloadType.getTag() == 13 || payloadType.getTag() == 46) {
            return dataSource;
        }
        if (payloadType.getTag() == 32) {
            return StringToByteArrayConverter.convert((ArrayType)payloadType, dataSource, readonly);
        }
        if (payloadType.getTag() == 27) {
            return UrlEncodedStringToMapConverter.convert((MapType)payloadType, dataSource, readonly);
        }
        if (payloadType.getTag() == 33) {
            List memberTypes = ((UnionType)payloadType).getMemberTypes();
            for (Type memberType : memberTypes) {
                try {
                    return this.createValue(memberType, readonly, dataSource);
                }
                catch (BError bError) {
                }
            }
        }
        String message = "incompatible type found: '" + payloadType.toString() + "'";
        throw HttpUtil.createHttpStatusCodeError(HttpErrorType.INTERNAL_PAYLOAD_BINDING_LISTENER_ERROR, message);
    }
}

