/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.transport.contractimpl;

import io.ballerina.stdlib.http.transport.contract.HttpConnectorListener;
import io.ballerina.stdlib.http.transport.contract.PortBindingEventListener;
import io.ballerina.stdlib.http.transport.contract.ServerConnectorFuture;
import io.ballerina.stdlib.http.transport.contract.exceptions.ServerConnectorException;
import io.ballerina.stdlib.http.transport.contractimpl.websocket.DefaultWebSocketConnectorFuture;
import io.ballerina.stdlib.http.transport.message.Http2PushPromise;
import io.ballerina.stdlib.http.transport.message.HttpCarbonMessage;
import io.netty.channel.ChannelFuture;
import io.netty.channel.group.ChannelGroup;

public class HttpWsServerConnectorFuture
extends DefaultWebSocketConnectorFuture
implements ServerConnectorFuture {
    private static final String HTTP_CONNECTOR_LISTENER_IS_NOT_SET = "HTTP connector listener is not set";
    private HttpConnectorListener httpConnectorListener;
    private PortBindingEventListener portBindingEventListener;
    private ChannelFuture nettyBindFuture;
    private ChannelGroup allChannels;
    private String openingServerConnectorId;
    private boolean isOpeningSCHttps;
    private String closingServerConnectorId;
    private boolean isClosingSCHttps;
    private Throwable connectorInitException;

    public HttpWsServerConnectorFuture() {
    }

    public HttpWsServerConnectorFuture(ChannelFuture nettyBindFuture) {
        this.nettyBindFuture = nettyBindFuture;
    }

    public HttpWsServerConnectorFuture(ChannelFuture nettyBindFuture, ChannelGroup allChannels) {
        this.nettyBindFuture = nettyBindFuture;
        this.allChannels = allChannels;
    }

    @Override
    public void setHttpConnectorListener(HttpConnectorListener httpConnectorListener) {
        this.httpConnectorListener = httpConnectorListener;
    }

    @Override
    public void notifyHttpListener(HttpCarbonMessage httpMessage) throws ServerConnectorException {
        if (this.httpConnectorListener == null) {
            throw new ServerConnectorException(HTTP_CONNECTOR_LISTENER_IS_NOT_SET);
        }
        this.httpConnectorListener.onMessage(httpMessage);
    }

    @Override
    public void notifyHttpListener(HttpCarbonMessage httpMessage, Http2PushPromise pushPromise) throws ServerConnectorException {
        if (this.httpConnectorListener == null) {
            throw new ServerConnectorException(HTTP_CONNECTOR_LISTENER_IS_NOT_SET);
        }
        this.httpConnectorListener.onPushResponse(pushPromise.getPromisedStreamId(), httpMessage);
    }

    @Override
    public void notifyHttpListener(Http2PushPromise pushPromise) throws ServerConnectorException {
        if (this.httpConnectorListener == null) {
            throw new ServerConnectorException(HTTP_CONNECTOR_LISTENER_IS_NOT_SET);
        }
        this.httpConnectorListener.onPushPromise(pushPromise);
    }

    @Override
    public void sync() throws InterruptedException {
        ChannelFuture bindFuture = this.nettyBindFuture.sync();
        if (this.allChannels != null && bindFuture.channel() != null) {
            this.allChannels.add((Object)bindFuture.channel());
        }
    }

    @Override
    public void notifyErrorListener(Throwable cause) throws ServerConnectorException {
        if (this.httpConnectorListener == null) {
            throw new ServerConnectorException(HTTP_CONNECTOR_LISTENER_IS_NOT_SET, new Exception(cause));
        }
        this.httpConnectorListener.onError(cause);
    }

    @Override
    public void setPortBindingEventListener(PortBindingEventListener portBindingEventListener) {
        this.portBindingEventListener = portBindingEventListener;
        if (this.openingServerConnectorId != null) {
            this.notifyPortBindingEvent(this.openingServerConnectorId, this.isOpeningSCHttps);
            this.openingServerConnectorId = null;
            this.isOpeningSCHttps = false;
        }
        if (this.closingServerConnectorId != null) {
            this.notifyPortUnbindingEvent(this.closingServerConnectorId, this.isClosingSCHttps);
            this.closingServerConnectorId = null;
            this.isClosingSCHttps = false;
        }
        if (this.connectorInitException != null) {
            this.notifyPortBindingError(this.connectorInitException);
            this.connectorInitException = null;
        }
    }

    @Override
    public void notifyPortBindingEvent(String serverConnectorId, boolean isHttps) {
        if (this.portBindingEventListener == null) {
            this.openingServerConnectorId = serverConnectorId;
            this.isOpeningSCHttps = isHttps;
        } else {
            this.portBindingEventListener.onOpen(serverConnectorId, isHttps);
        }
    }

    @Override
    public void notifyPortUnbindingEvent(String serverConnectorId, boolean isHttps) {
        if (this.portBindingEventListener == null) {
            this.closingServerConnectorId = serverConnectorId;
            this.isClosingSCHttps = isHttps;
        } else {
            this.portBindingEventListener.onClose(serverConnectorId, isHttps);
        }
    }

    @Override
    public void notifyPortBindingError(Throwable throwable) {
        if (this.portBindingEventListener == null) {
            this.connectorInitException = throwable;
        } else {
            this.portBindingEventListener.onError(throwable);
        }
    }
}

