/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.transport.contractimpl.common;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.Http2FrameLogger;
import io.netty.handler.logging.LogLevel;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;

public class FrameLogger
extends Http2FrameLogger {
    private final InternalLogger logger;
    private LogLevel level;

    public FrameLogger(LogLevel level, String name) {
        super(level, name);
        this.logger = InternalLoggerFactory.getInstance((String)name);
        this.level = level;
    }

    public void logData(Http2FrameLogger.Direction direction, ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endStream) {
        this.logger.log(this.level.toInternalLevel(), "{} {} DATA: streamId={} padding={} endStream={} length={} data={}", new Object[]{ctx.channel(), direction.name(), streamId, padding, endStream, data.readableBytes(), this.formatPayload(data)});
    }

    private String formatPayload(ByteBuf msg) {
        int length = msg.readableBytes();
        if (length == 0) {
            return " 0B";
        }
        int rows = length / 16 + (length % 16 == 0 ? 0 : 1) + 4;
        StringBuilder stringBuilder = new StringBuilder(13 + rows * 80);
        stringBuilder.append(length).append('B').append(StringUtil.NEWLINE);
        try {
            CharsetDecoder decoder = Charset.forName("UTF8").newDecoder();
            CharBuffer buffer = decoder.decode(msg.nioBuffer());
            stringBuilder.append(buffer);
        }
        catch (CharacterCodingException e) {
            return "<< Payload could not be decoded >>";
        }
        return stringBuilder.toString();
    }
}

