/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.transport.contractimpl.listener;

import io.ballerina.stdlib.http.transport.contract.ServerConnectorFuture;
import io.ballerina.stdlib.http.transport.contract.config.ChunkConfig;
import io.ballerina.stdlib.http.transport.contract.config.InboundMsgSizeValidationConfig;
import io.ballerina.stdlib.http.transport.contract.config.KeepAliveConfig;
import io.ballerina.stdlib.http.transport.contractimpl.common.BackPressureHandler;
import io.ballerina.stdlib.http.transport.contractimpl.common.Util;
import io.ballerina.stdlib.http.transport.contractimpl.common.certificatevalidation.CertificateVerificationException;
import io.ballerina.stdlib.http.transport.contractimpl.common.http2.Http2ExceptionHandler;
import io.ballerina.stdlib.http.transport.contractimpl.common.ssl.SSLConfig;
import io.ballerina.stdlib.http.transport.contractimpl.common.ssl.SSLHandlerFactory;
import io.ballerina.stdlib.http.transport.contractimpl.listener.CustomHttpContentCompressor;
import io.ballerina.stdlib.http.transport.contractimpl.listener.HttpExceptionHandler;
import io.ballerina.stdlib.http.transport.contractimpl.listener.HttpTraceLoggingHandler;
import io.ballerina.stdlib.http.transport.contractimpl.listener.MaxEntityBodyValidator;
import io.ballerina.stdlib.http.transport.contractimpl.listener.OCSPResponseBuilder;
import io.ballerina.stdlib.http.transport.contractimpl.listener.SourceHandler;
import io.ballerina.stdlib.http.transport.contractimpl.listener.SslHandshakeCompletionHandlerForServer;
import io.ballerina.stdlib.http.transport.contractimpl.listener.UriAndHeaderLengthValidator;
import io.ballerina.stdlib.http.transport.contractimpl.listener.WebSocketServerHandshakeHandler;
import io.ballerina.stdlib.http.transport.contractimpl.listener.http2.Http2SourceConnectionHandlerBuilder;
import io.ballerina.stdlib.http.transport.contractimpl.listener.http2.Http2SourceHandler;
import io.ballerina.stdlib.http.transport.contractimpl.listener.http2.Http2ToHttpFallbackHandler;
import io.ballerina.stdlib.http.transport.contractimpl.listener.http2.Http2WithPriorKnowledgeHandler;
import io.ballerina.stdlib.http.transport.contractimpl.sender.CertificateValidationHandler;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpServerUpgradeHandler;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2ServerUpgradeCodec;
import io.netty.handler.ssl.ApplicationProtocolNegotiationHandler;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.ReferenceCountedOpenSslContext;
import io.netty.handler.ssl.ReferenceCountedOpenSslEngine;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.AsciiString;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.security.KeyStoreException;
import java.security.cert.CertificateException;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServerChannelInitializer
extends ChannelInitializer<SocketChannel> {
    private static final Logger LOG = LoggerFactory.getLogger(HttpServerChannelInitializer.class);
    private long socketIdleTimeout;
    private boolean httpTraceLogEnabled;
    private boolean httpAccessLogEnabled;
    private ChunkConfig chunkConfig;
    private KeepAliveConfig keepAliveConfig;
    private String interfaceId;
    private String serverName;
    private SSLConfig sslConfig;
    private SSLHandlerFactory sslHandlerFactory;
    private SSLContext keystoreSslContext;
    private SslContext keystoreHttp2SslContext;
    private SslContext certAndKeySslContext;
    private ServerConnectorFuture serverConnectorFuture;
    private InboundMsgSizeValidationConfig reqSizeValidationConfig;
    private boolean http2Enabled = false;
    private boolean validateCertEnabled;
    private int cacheDelay;
    private int cacheSize;
    private ChannelGroup allChannels;
    private ChannelGroup listenerChannels;
    private boolean ocspStaplingEnabled = false;
    private boolean pipeliningEnabled;
    private long pipeliningLimit;
    private EventExecutorGroup pipeliningGroup;
    private boolean webSocketCompressionEnabled;
    private int http2InitialWindowSize;
    private long minIdleTimeInStaleState;
    private long timeBetweenStaleEviction;
    private final BlockingQueue<Http2SourceHandler> http2StaleSourceHandlers = new LinkedBlockingQueue<Http2SourceHandler>();
    private Timer timer;

    public void initChannel(SocketChannel ch) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Initializing source channel pipeline");
        }
        ChannelPipeline serverPipeline = ch.pipeline();
        if (this.http2Enabled) {
            if (this.sslHandlerFactory != null) {
                if (this.ocspStaplingEnabled) {
                    OCSPResp response = this.getOcspResponse();
                    ReferenceCountedOpenSslContext context = (ReferenceCountedOpenSslContext)this.keystoreHttp2SslContext;
                    SslHandler sslHandler = context.newHandler(ch.alloc());
                    ReferenceCountedOpenSslEngine engine = (ReferenceCountedOpenSslEngine)sslHandler.engine();
                    engine.setOcspResponse(response.getEncoded());
                    Util.setSslHandshakeTimeOut(this.sslConfig, sslHandler);
                    ch.pipeline().addLast(new ChannelHandler[]{sslHandler, new Http2PipelineConfiguratorForServer(this, sslHandler.engine())});
                } else {
                    SslHandler sslHandler = this.keystoreHttp2SslContext.newHandler(ch.alloc());
                    Util.setSslHandshakeTimeOut(this.sslConfig, sslHandler);
                    serverPipeline.addLast(new ChannelHandler[]{sslHandler, new Http2PipelineConfiguratorForServer(this, sslHandler.engine())});
                    serverPipeline.addLast("Http2ExceptionHandler", (ChannelHandler)new Http2ExceptionHandler());
                }
            } else {
                this.configureH2cPipeline(serverPipeline);
            }
            this.initiateHttp2ConnectionEvictionTask();
        } else if (this.sslHandlerFactory != null) {
            this.configureSslForHttp(serverPipeline, ch);
        } else {
            this.configureHttpPipeline(serverPipeline, "http");
        }
    }

    private OCSPResp getOcspResponse() throws IOException, KeyStoreException, CertificateVerificationException, CertificateException {
        OCSPResp response = OCSPResponseBuilder.generateOcspResponse(this.sslConfig, this.cacheSize, this.cacheDelay);
        if (!OpenSsl.isAvailable()) {
            throw new IllegalStateException("OpenSSL is not available!");
        }
        if (!OpenSsl.isOcspSupported()) {
            throw new IllegalStateException("OCSP is not supported!");
        }
        return response;
    }

    private void configureSslForHttp(ChannelPipeline serverPipeline, SocketChannel ch) throws CertificateVerificationException, KeyStoreException, IOException, CertificateException {
        SSLEngine sslEngine;
        if (this.ocspStaplingEnabled) {
            OCSPResp response = this.getOcspResponse();
            ReferenceCountedOpenSslContext context = this.sslHandlerFactory.getServerReferenceCountedOpenSslContext(this.ocspStaplingEnabled);
            SslHandler sslHandler = context.newHandler(ch.alloc());
            sslEngine = sslHandler.engine();
            Util.setAlpnProtocols(sslEngine);
            ReferenceCountedOpenSslEngine engine = (ReferenceCountedOpenSslEngine)sslEngine;
            engine.setOcspResponse(response.getEncoded());
            Util.setSslHandshakeTimeOut(this.sslConfig, sslHandler);
            ch.pipeline().addLast(new ChannelHandler[]{sslHandler});
        } else {
            SslHandler sslHandler;
            if (this.sslConfig.getServerKeyFile() != null) {
                sslHandler = this.certAndKeySslContext.newHandler(ch.alloc());
                sslEngine = sslHandler.engine();
                this.sslHandlerFactory.addCommonConfigs(sslEngine);
            } else {
                sslEngine = this.sslHandlerFactory.buildServerSSLEngine(this.keystoreSslContext);
            }
            Util.setAlpnProtocols(sslEngine);
            sslHandler = new SslHandler(sslEngine);
            Util.setSslHandshakeTimeOut(this.sslConfig, sslHandler);
            serverPipeline.addLast("ssl", (ChannelHandler)sslHandler);
            if (this.validateCertEnabled) {
                serverPipeline.addLast("certificateValidation", (ChannelHandler)new CertificateValidationHandler(sslEngine, this.cacheDelay, this.cacheSize));
            }
        }
        serverPipeline.addLast("sslHandshakeCompletionHandler", (ChannelHandler)new SslHandshakeCompletionHandlerForServer(this, serverPipeline, sslEngine));
    }

    public void configureHttpPipeline(ChannelPipeline serverPipeline, String initialHttpScheme) {
        if (initialHttpScheme.equals("http")) {
            serverPipeline.addLast("encoder", (ChannelHandler)new HttpResponseEncoder());
            serverPipeline.addLast("decoder", (ChannelHandler)new HttpRequestDecoder(this.reqSizeValidationConfig.getMaxInitialLineLength(), this.reqSizeValidationConfig.getMaxHeaderSize(), this.reqSizeValidationConfig.getMaxChunkSize()));
            serverPipeline.addLast("compressor", (ChannelHandler)new CustomHttpContentCompressor());
            serverPipeline.addLast("chunkWriter", (ChannelHandler)new ChunkedWriteHandler());
            if (this.httpTraceLogEnabled) {
                serverPipeline.addLast("http-trace-logger", (ChannelHandler)new HttpTraceLoggingHandler("http.tracelog.downstream"));
            }
        }
        serverPipeline.addLast("uriAndHeaderLengthValidator", (ChannelHandler)new UriAndHeaderLengthValidator(this.serverName));
        if (this.reqSizeValidationConfig.getMaxEntityBodySize() > -1L) {
            serverPipeline.addLast("maxEntityBodyValidator", (ChannelHandler)new MaxEntityBodyValidator(this.serverName, this.reqSizeValidationConfig.getMaxEntityBodySize()));
        }
        serverPipeline.addLast("websocket-server-handshake-handler", (ChannelHandler)new WebSocketServerHandshakeHandler(this.serverConnectorFuture, this.webSocketCompressionEnabled));
        serverPipeline.addLast("BackPressureHandler", (ChannelHandler)new BackPressureHandler());
        serverPipeline.addLast("SourceHandler", (ChannelHandler)new SourceHandler(this.serverConnectorFuture, this, this.interfaceId, this.chunkConfig, this.keepAliveConfig, this.serverName, this.allChannels, this.listenerChannels, this.pipeliningEnabled, this.pipeliningLimit, this.pipeliningGroup));
        if (this.socketIdleTimeout >= 0L) {
            serverPipeline.addBefore("SourceHandler", "idleStateHandler", (ChannelHandler)new IdleStateHandler(0L, 0L, this.socketIdleTimeout, TimeUnit.MILLISECONDS));
        }
        serverPipeline.addLast("HttpExceptionHandler", (ChannelHandler)new HttpExceptionHandler());
    }

    private void configureH2cPipeline(ChannelPipeline pipeline) {
        pipeline.addLast(new ChannelHandler[]{new Http2WithPriorKnowledgeHandler(this.interfaceId, this.serverName, this.serverConnectorFuture, this, this.allChannels, this.listenerChannels, this.reqSizeValidationConfig.getMaxHeaderSize(), this.http2InitialWindowSize)});
        HttpServerCodec sourceCodec = new HttpServerCodec(this.reqSizeValidationConfig.getMaxInitialLineLength(), this.reqSizeValidationConfig.getMaxHeaderSize(), this.reqSizeValidationConfig.getMaxChunkSize());
        pipeline.addLast("ServerCodec", (ChannelHandler)sourceCodec);
        pipeline.addLast("compressor", (ChannelHandler)new CustomHttpContentCompressor());
        if (this.httpTraceLogEnabled) {
            pipeline.addLast("http-trace-logger", (ChannelHandler)new HttpTraceLoggingHandler("http.tracelog.downstream"));
        }
        HttpServerUpgradeHandler.UpgradeCodecFactory upgradeCodecFactory = protocol -> {
            if (AsciiString.contentEquals((CharSequence)Http2CodecUtil.HTTP_UPGRADE_PROTOCOL_NAME, (CharSequence)protocol)) {
                return new Http2ServerUpgradeCodec("Http2SourceConnectionHandler", (Http2ConnectionHandler)new Http2SourceConnectionHandlerBuilder(this.interfaceId, this.serverConnectorFuture, this.serverName, this, this.allChannels, this.listenerChannels, this.reqSizeValidationConfig.getMaxHeaderSize(), this.http2InitialWindowSize).build());
            }
            return null;
        };
        pipeline.addLast("Http2UpgradeHandler", (ChannelHandler)new HttpServerUpgradeHandler((HttpServerUpgradeHandler.SourceCodec)sourceCodec, upgradeCodecFactory, Integer.MAX_VALUE));
        pipeline.addLast("Http2ToHttpFallbackHandler", (ChannelHandler)new Http2ToHttpFallbackHandler(this));
    }

    public void setServerConnectorFuture(ServerConnectorFuture serverConnectorFuture) {
        this.serverConnectorFuture = serverConnectorFuture;
    }

    void setIdleTimeout(long idleTimeout) {
        this.socketIdleTimeout = idleTimeout;
    }

    public long getSocketIdleTimeout() {
        return this.socketIdleTimeout;
    }

    void setHttpTraceLogEnabled(boolean httpTraceLogEnabled) {
        this.httpTraceLogEnabled = httpTraceLogEnabled;
    }

    void setHttpAccessLogEnabled(boolean httpAccessLogEnabled) {
        this.httpAccessLogEnabled = httpAccessLogEnabled;
    }

    public boolean isHttpTraceLogEnabled() {
        return this.httpTraceLogEnabled;
    }

    public boolean isHttpAccessLogEnabled() {
        return this.httpAccessLogEnabled;
    }

    void setInterfaceId(String interfaceId) {
        this.interfaceId = interfaceId;
    }

    void setSslConfig(SSLConfig sslConfig) {
        this.sslConfig = sslConfig;
    }

    void setSslHandlerFactory(SSLHandlerFactory sslHandlerFactory) {
        this.sslHandlerFactory = sslHandlerFactory;
    }

    void setKeystoreSslContext(SSLContext sslContext) {
        this.keystoreSslContext = sslContext;
    }

    void setHttp2SslContext(SslContext sslContext) {
        this.keystoreHttp2SslContext = sslContext;
    }

    void setCertandKeySslContext(SslContext sslContext) {
        this.certAndKeySslContext = sslContext;
    }

    void setReqSizeValidationConfig(InboundMsgSizeValidationConfig reqSizeValidationConfig) {
        this.reqSizeValidationConfig = reqSizeValidationConfig;
    }

    void setHttp2InitialWindowSize(int http2InitialWindowSize) {
        this.http2InitialWindowSize = http2InitialWindowSize;
    }

    void setTimeBetweenStaleEviction(long timeBetweenStaleEviction) {
        this.timeBetweenStaleEviction = timeBetweenStaleEviction;
    }

    void setMinIdleTimeInStaleState(long minIdleTimeInStaleState) {
        this.minIdleTimeInStaleState = minIdleTimeInStaleState;
    }

    public void setChunkingConfig(ChunkConfig chunkConfig) {
        this.chunkConfig = chunkConfig;
    }

    void setKeepAliveConfig(KeepAliveConfig keepAliveConfig) {
        this.keepAliveConfig = keepAliveConfig;
    }

    void setValidateCertEnabled(boolean validateCertEnabled) {
        this.validateCertEnabled = validateCertEnabled;
    }

    void setCacheDelay(int cacheDelay) {
        this.cacheDelay = cacheDelay;
    }

    void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    void setServerName(String serverName) {
        this.serverName = serverName;
    }

    void setOcspStaplingEnabled(boolean ocspStaplingEnabled) {
        this.ocspStaplingEnabled = ocspStaplingEnabled;
    }

    void setHttp2Enabled(boolean http2Enabled) {
        this.http2Enabled = http2Enabled;
    }

    void setPipeliningEnabled(boolean pipeliningEnabled) {
        this.pipeliningEnabled = pipeliningEnabled;
    }

    public void setPipeliningLimit(long pipeliningLimit) {
        this.pipeliningLimit = pipeliningLimit;
    }

    public void setPipeliningThreadGroup(EventExecutorGroup pipeliningGroup) {
        this.pipeliningGroup = pipeliningGroup;
    }

    public void setWebSocketCompressionEnabled(boolean webSocketCompressionEnabled) {
        this.webSocketCompressionEnabled = webSocketCompressionEnabled;
    }

    public void addToStaleChannels(Http2SourceHandler http2SourceHandler) {
        this.http2StaleSourceHandlers.add(http2SourceHandler);
    }

    void setAllChannels(ChannelGroup allChannels, ChannelGroup listenerChannels) {
        this.allChannels = allChannels;
        this.listenerChannels = listenerChannels;
    }

    private void initiateHttp2ConnectionEvictionTask() {
        if (Objects.nonNull(this.timer)) {
            return;
        }
        this.timer = new Timer(true);
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                HttpServerChannelInitializer.this.http2StaleSourceHandlers.forEach(http2SourceHandler -> {
                    if (HttpServerChannelInitializer.this.minIdleTimeInStaleState == -1L) {
                        if (http2SourceHandler.getStreamIdRequestMap().isEmpty()) {
                            this.removeChannelAndEvict((Http2SourceHandler)((Object)http2SourceHandler));
                        }
                    } else if (System.currentTimeMillis() - http2SourceHandler.getTimeSinceMarkedAsStale() > HttpServerChannelInitializer.this.minIdleTimeInStaleState) {
                        this.removeChannelAndEvict((Http2SourceHandler)((Object)http2SourceHandler));
                    }
                });
            }

            public void removeChannelAndEvict(Http2SourceHandler http2SourceHandler) {
                HttpServerChannelInitializer.this.http2StaleSourceHandlers.remove((Object)http2SourceHandler);
                http2SourceHandler.closeChannelAfterBecomingStale();
            }
        };
        this.timer.schedule(timerTask, this.timeBetweenStaleEviction, this.timeBetweenStaleEviction);
    }

    public void cancelStaleEvictionTask() {
        if (Objects.nonNull(this.timer)) {
            this.timer.cancel();
        }
    }

    class Http2PipelineConfiguratorForServer
    extends ApplicationProtocolNegotiationHandler {
        private HttpServerChannelInitializer channelInitializer;
        private SSLEngine sslEngine;

        Http2PipelineConfiguratorForServer(HttpServerChannelInitializer channelInitializer, SSLEngine sslEngine) {
            super("http/1.1");
            this.channelInitializer = channelInitializer;
            this.sslEngine = sslEngine;
        }

        protected void configurePipeline(ChannelHandlerContext ctx, String protocol) {
            Util.setMutualSslStatus(ctx, this.sslEngine);
            if ("h2".equals(protocol)) {
                ctx.pipeline().addLast("Http2SourceConnectionHandler", (ChannelHandler)new Http2SourceConnectionHandlerBuilder(HttpServerChannelInitializer.this.interfaceId, HttpServerChannelInitializer.this.serverConnectorFuture, HttpServerChannelInitializer.this.serverName, this.channelInitializer, HttpServerChannelInitializer.this.allChannels, HttpServerChannelInitializer.this.listenerChannels, HttpServerChannelInitializer.this.reqSizeValidationConfig.getMaxHeaderSize(), HttpServerChannelInitializer.this.http2InitialWindowSize).build());
            } else if ("http/1.1".equals(protocol)) {
                HttpServerChannelInitializer.this.configureHttpPipeline(ctx.pipeline(), "http");
                ctx.pipeline().fireChannelActive();
            } else {
                throw new IllegalStateException("unknown protocol: " + protocol);
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            if (ctx != null) {
                if (ctx.channel().isActive()) {
                    ctx.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                } else {
                    super.exceptionCaught(ctx, cause);
                }
            }
        }

        protected void handshakeFailure(ChannelHandlerContext ctx, Throwable cause) {
            if (cause.toString().contains("ssl") || cause.toString().contains("security")) {
                while (cause.getCause() != null && cause.getCause() != cause) {
                    cause = cause.getCause();
                }
            }
            LOG.warn("{} TLS handshake failed: {}", (Object)ctx.channel(), (Object)cause.getMessage());
        }
    }
}

