/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.transport.contractimpl.listener.http2;

import io.ballerina.stdlib.http.transport.contract.ServerConnectorFuture;
import io.ballerina.stdlib.http.transport.contractimpl.common.Util;
import io.ballerina.stdlib.http.transport.contractimpl.common.http2.Http2ExceptionHandler;
import io.ballerina.stdlib.http.transport.contractimpl.listener.HttpServerChannelInitializer;
import io.ballerina.stdlib.http.transport.contractimpl.listener.http2.Http2SourceHandler;
import io.ballerina.stdlib.http.transport.internal.HttpTransportContextHolder;
import io.ballerina.stdlib.http.transport.message.Http2DataFrame;
import io.ballerina.stdlib.http.transport.message.Http2HeadersFrame;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.group.ChannelGroup;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2EventAdapter;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Http2SourceConnectionHandler
extends Http2ConnectionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(Http2SourceConnectionHandler.class);
    private Http2FrameListener http2FrameListener;
    private Http2ConnectionEncoder encoder;
    private String interfaceId;
    private ServerConnectorFuture serverConnectorFuture;
    private String serverName;
    private HttpServerChannelInitializer serverChannelInitializer;
    private ChannelGroup allChannels;
    private ChannelGroup listenerChannels;

    Http2SourceConnectionHandler(HttpServerChannelInitializer serverChannelInitializer, Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings, String interfaceId, ServerConnectorFuture serverConnectorFuture, String serverName, ChannelGroup allChannels, ChannelGroup listenerChannels) {
        super(decoder, encoder, initialSettings);
        this.serverChannelInitializer = serverChannelInitializer;
        this.encoder = encoder;
        this.interfaceId = interfaceId;
        this.serverConnectorFuture = serverConnectorFuture;
        this.serverName = serverName;
        this.http2FrameListener = new ServerFrameListener();
        this.allChannels = allChannels;
        this.listenerChannels = listenerChannels;
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        super.handlerAdded(ctx);
        Util.safelyRemoveHandlers(ctx.pipeline(), "Http2ToHttpFallbackHandler", "compressor", "http-trace-logger", "http-access-logger", "Http2ExceptionHandler");
        Http2SourceHandler http2SourceHandler = new Http2SourceHandler(this.serverChannelInitializer, this.encoder, this.interfaceId, this.connection(), this.serverConnectorFuture, this.serverName, this.allChannels, this.listenerChannels, this);
        ctx.pipeline().addLast("Http2SourceHandler", (ChannelHandler)http2SourceHandler);
        ctx.pipeline().addLast("Http2ExceptionHandler", (ChannelHandler)new Http2ExceptionHandler(this));
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Channel inactive event received in Http2SourceConnectionHandler");
        }
        if (HttpTransportContextHolder.getInstance().getHandlerExecutor() != null) {
            HttpTransportContextHolder.getInstance().getHandlerExecutor().executeAtSourceConnectionTermination(Integer.toString(ctx.hashCode()));
        }
        ctx.fireChannelInactive();
    }

    Http2FrameListener getHttp2FrameListener() {
        return this.http2FrameListener;
    }

    public void setAllChannels(ChannelGroup allChannels) {
        this.allChannels = allChannels;
    }

    public void setListenerChannels(ChannelGroup listenerChannels) {
        this.listenerChannels = listenerChannels;
    }

    private static class ServerFrameListener
    extends Http2EventAdapter {
        private static final Logger LOG = LoggerFactory.getLogger(ServerFrameListener.class);

        private ServerFrameListener() {
        }

        public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int padding, boolean endOfStream) {
            Http2HeadersFrame http2HeadersFrame = new Http2HeadersFrame(streamId, headers, endOfStream);
            ctx.fireChannelRead((Object)http2HeadersFrame);
        }

        public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endOfStream) {
            this.onHeadersRead(ctx, streamId, headers, padding, endOfStream);
        }

        public int onDataRead(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endOfStream) {
            int readableBytes = data.readableBytes();
            ByteBuf forwardedData = data.copy();
            data.skipBytes(readableBytes);
            Http2DataFrame dataFrame = new Http2DataFrame(streamId, forwardedData, endOfStream);
            ctx.fireChannelRead((Object)dataFrame);
            return 0;
        }

        public void onGoAwayReceived(int lastStreamId, long errorCode, ByteBuf debugData) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("GoAwayReceived event in server frame listener. Stream id : {} Error code : {}", (Object)lastStreamId, (Object)errorCode);
            }
        }

        public void onStreamClosed(Http2Stream stream) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("StreamClosed event in server frame listener. Stream id : {}", (Object)stream.id());
            }
        }

        public void onRstStreamRead(ChannelHandlerContext ctx, int streamId, long errorCode) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("RstStreamRead event in server frame listener. Stream id : {} Error code : {}", (Object)streamId, (Object)errorCode);
            }
            ctx.fireExceptionCaught((Throwable)new Http2Exception(Http2Error.valueOf((long)errorCode), "Stream closed"));
        }
    }
}

