/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.transport.contractimpl.sender.websocket;

import io.ballerina.stdlib.http.transport.contract.websocket.ClientHandshakeFuture;
import io.ballerina.stdlib.http.transport.contract.websocket.WebSocketClientConnectorConfig;
import io.ballerina.stdlib.http.transport.contractimpl.common.Util;
import io.ballerina.stdlib.http.transport.contractimpl.common.ssl.SSLConfig;
import io.ballerina.stdlib.http.transport.contractimpl.listener.WebSocketMessageQueueHandler;
import io.ballerina.stdlib.http.transport.contractimpl.sender.websocket.WebSocketClientCompressionHandler;
import io.ballerina.stdlib.http.transport.contractimpl.sender.websocket.WebSocketClientHandshakeHandler;
import io.ballerina.stdlib.http.transport.contractimpl.websocket.DefaultClientHandshakeFuture;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.Utf8FrameValidator;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.handler.timeout.IdleStateHandler;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketClient {
    private static final Logger LOG = LoggerFactory.getLogger(WebSocketClient.class);
    private WebSocketClientHandshakeHandler clientHandshakeHandler;
    private final WebSocketClientConnectorConfig connectorConfig;
    private final EventLoopGroup wsClientEventLoopGroup;

    public WebSocketClient(EventLoopGroup wsClientEventLoopGroup, WebSocketClientConnectorConfig connectorConfig) {
        this.wsClientEventLoopGroup = wsClientEventLoopGroup;
        this.connectorConfig = connectorConfig;
    }

    public ClientHandshakeFuture handshake() {
        DefaultClientHandshakeFuture handshakeFuture = new DefaultClientHandshakeFuture();
        try {
            URI uri = new URI(this.connectorConfig.getRemoteAddress());
            String scheme = uri.getScheme();
            if (!"ws".equalsIgnoreCase(scheme) && !"wss".equalsIgnoreCase(scheme)) {
                LOG.error("Only WS(S) is supported.");
                throw new URISyntaxException(this.connectorConfig.getRemoteAddress(), "WebSocket client supports only WS(S) scheme");
            }
            String host = uri.getHost() == null ? "127.0.0.1" : uri.getHost();
            int port = this.getPort(uri);
            boolean ssl = "wss".equalsIgnoreCase(scheme);
            WebSocketClientHandshaker webSocketHandshaker = WebSocketClientHandshakerFactory.newHandshaker((URI)uri, (WebSocketVersion)WebSocketVersion.V13, (String)this.connectorConfig.getSubProtocolsStr(), (boolean)true, (HttpHeaders)this.connectorConfig.getHeaders(), (int)this.connectorConfig.getMaxFrameSize());
            WebSocketMessageQueueHandler webSocketMessageQueueHandler = new WebSocketMessageQueueHandler();
            this.clientHandshakeHandler = new WebSocketClientHandshakeHandler(webSocketHandshaker, handshakeFuture, webSocketMessageQueueHandler, ssl, this.connectorConfig.isAutoRead(), this.connectorConfig.getRemoteAddress(), handshakeFuture);
            Bootstrap clientBootstrap = this.initClientBootstrap(host, port, handshakeFuture);
            clientBootstrap.connect(uri.getHost(), port).addListener(future -> {
                Throwable cause = future.cause();
                if (!future.isSuccess() && cause != null) {
                    handshakeFuture.notifyError(cause, null);
                }
            });
        }
        catch (Exception throwable) {
            this.handleHandshakeError(handshakeFuture, throwable);
        }
        return handshakeFuture;
    }

    private void handleHandshakeError(DefaultClientHandshakeFuture handshakeFuture, Throwable throwable) {
        if (this.clientHandshakeHandler != null) {
            handshakeFuture.notifyError(throwable, this.clientHandshakeHandler.getHttpCarbonResponse());
        } else {
            handshakeFuture.notifyError(throwable, null);
        }
    }

    private Bootstrap initClientBootstrap(final String host, final int port, final DefaultClientHandshakeFuture handshakeFuture) {
        Bootstrap clientBootstrap = new Bootstrap();
        final SSLConfig sslConfig = this.connectorConfig.getClientSSLConfig();
        ((Bootstrap)((Bootstrap)clientBootstrap.group(this.wsClientEventLoopGroup)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel socketChannel) throws Exception {
                if (sslConfig != null) {
                    if (!sslConfig.hasSslCtxInitialized()) {
                        sslConfig.initializeSSLContext(false);
                    }
                    SSLEngine sslEngine = Util.configureHttpPipelineForSSL(socketChannel, host, port, sslConfig);
                    socketChannel.pipeline().addLast("sslHandshakeCompletionHandler", (ChannelHandler)new WebSocketClientSSLHandshakeCompletionHandler(handshakeFuture, sslEngine));
                } else {
                    WebSocketClient.this.configureHandshakePipeline(socketChannel.pipeline());
                }
            }
        });
        return clientBootstrap;
    }

    private void configureHandshakePipeline(ChannelPipeline pipeline) {
        pipeline.addLast(new ChannelHandler[]{new HttpClientCodec()});
        pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(8192)});
        if (this.connectorConfig.isWebSocketCompressionEnabled()) {
            pipeline.addLast(new ChannelHandler[]{WebSocketClientCompressionHandler.INSTANCE});
        }
        pipeline.addLast(Utf8FrameValidator.class.getName(), (ChannelHandler)new Utf8FrameValidator());
        if (this.connectorConfig.getIdleTimeoutInMillis() > 0) {
            pipeline.addLast("idleStateHandler", (ChannelHandler)new IdleStateHandler(0L, 0L, (long)this.connectorConfig.getIdleTimeoutInMillis(), TimeUnit.MILLISECONDS));
        }
        pipeline.addLast("websocket-client-handshake-handler", (ChannelHandler)this.clientHandshakeHandler);
    }

    private int getPort(URI uri) {
        String scheme = uri.getScheme();
        int port = uri.getPort();
        if (port == -1) {
            switch (scheme) {
                case "ws": {
                    return 80;
                }
                case "wss": {
                    return 443;
                }
            }
            return -1;
        }
        return port;
    }

    private class WebSocketClientSSLHandshakeCompletionHandler
    extends ChannelInboundHandlerAdapter {
        private final DefaultClientHandshakeFuture clientHandshakeFuture;
        private SSLEngine sslEngine;

        private WebSocketClientSSLHandshakeCompletionHandler(DefaultClientHandshakeFuture clientHandshakeFuture, SSLEngine sslEngine) {
            this.clientHandshakeFuture = clientHandshakeFuture;
            this.sslEngine = sslEngine;
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws CertificateNotYetValidException, CertificateExpiredException, SSLPeerUnverifiedException {
            if (evt instanceof SslHandshakeCompletionEvent) {
                SslHandshakeCompletionEvent event = (SslHandshakeCompletionEvent)evt;
                if (event.isSuccess() && event.cause() == null) {
                    try {
                        X509Certificate endUserCert = (X509Certificate)this.sslEngine.getSession().getPeerCertificates()[0];
                        endUserCert.checkValidity(new Date());
                    }
                    catch (CertificateExpiredException e) {
                        this.clientHandshakeFuture.notifyError(new SSLException("Certificate expired : " + e.getMessage()), null);
                    }
                    WebSocketClient.this.configureHandshakePipeline(ctx.channel().pipeline());
                    ctx.pipeline().remove((ChannelHandler)this);
                    ctx.fireChannelActive();
                } else {
                    this.clientHandshakeFuture.notifyError(event.cause(), null);
                }
            }
        }
    }
}

