/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.transport.contractimpl.websocket;

import io.ballerina.stdlib.http.transport.contract.websocket.ClientHandshakeFuture;
import io.ballerina.stdlib.http.transport.contract.websocket.WebSocketClientConnector;
import io.ballerina.stdlib.http.transport.contract.websocket.WebSocketClientConnectorConfig;
import io.ballerina.stdlib.http.transport.contractimpl.common.ssl.SSLConfig;
import io.ballerina.stdlib.http.transport.contractimpl.sender.websocket.WebSocketClient;
import io.netty.channel.EventLoopGroup;
import java.util.Objects;

public class DefaultWebSocketClientConnector
implements WebSocketClientConnector {
    private final WebSocketClient webSocketClient;
    private final WebSocketClientConnectorConfig clientConnectorConfig;

    public DefaultWebSocketClientConnector(WebSocketClientConnectorConfig clientConnectorConfig, EventLoopGroup wsClientEventLoopGroup) {
        this.webSocketClient = new WebSocketClient(wsClientEventLoopGroup, clientConnectorConfig);
        this.clientConnectorConfig = clientConnectorConfig;
    }

    @Override
    public ClientHandshakeFuture connect() {
        return this.webSocketClient.handshake();
    }

    @Override
    public void initializeSSLContext() throws Exception {
        SSLConfig sslConfig = this.clientConnectorConfig.getClientSSLConfig();
        if (Objects.nonNull(sslConfig)) {
            sslConfig.initializeSSLContext(false);
        }
    }
}

