/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.transport.message;

import io.ballerina.stdlib.http.transport.message.BackPressureListener;
import java.util.concurrent.Semaphore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBackPressureListener
implements BackPressureListener {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultBackPressureListener.class);
    private Semaphore semaphore = new Semaphore(0);

    @Override
    public void onUnWritable() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Semaphore acquired in thread {} ", (Object)Thread.currentThread().getName());
        }
        try {
            this.semaphore.acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void onWritable() {
        this.semaphore.release();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Semaphore released in thread {} ", (Object)Thread.currentThread().getName());
        }
    }
}

