/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.log.compiler;

import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionArgumentNode;
import io.ballerina.compiler.syntax.tree.FunctionCallExpressionNode;
import io.ballerina.compiler.syntax.tree.MinutiaeList;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.NameReferenceNode;
import io.ballerina.compiler.syntax.tree.NamedArgumentNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TreeModifier;
import io.ballerina.projects.Document;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.Module;
import io.ballerina.projects.ModuleId;
import io.ballerina.projects.Package;
import io.ballerina.projects.ProjectKind;
import io.ballerina.projects.plugins.CodeModifier;
import io.ballerina.projects.plugins.CodeModifierContext;
import java.util.ArrayList;

public class LogCodeModifier
extends CodeModifier {
    public void init(CodeModifierContext modifierContext) {
        modifierContext.addSourceModifierTask(sourceModifierContext -> {
            Package pkg = sourceModifierContext.currentPackage();
            for (ModuleId moduleId : pkg.moduleIds()) {
                Module module = pkg.module(moduleId);
                String moduleName = module.project().kind() == ProjectKind.SINGLE_FILE_PROJECT ? "" : module.descriptor().org().toString() + "/" + module.descriptor().name().toString();
                for (DocumentId documentId : module.documentIds()) {
                    sourceModifierContext.modifySourceFile(this.getUpdatedSyntaxTree(module, documentId, moduleName).textDocument(), documentId);
                }
                for (DocumentId documentId : module.testDocumentIds()) {
                    sourceModifierContext.modifyTestSourceFile(this.getUpdatedSyntaxTree(module, documentId, moduleName).textDocument(), documentId);
                }
            }
        });
    }

    private SyntaxTree getUpdatedSyntaxTree(Module module, DocumentId documentId, String moduleName) {
        Document document = module.document(documentId);
        ModulePartNode rootNode = (ModulePartNode)document.syntaxTree().rootNode();
        FunctionCallModifier functionCallModifier = new FunctionCallModifier(moduleName);
        ModulePartNode newRoot = (ModulePartNode)rootNode.apply((NodeTransformer)functionCallModifier);
        return document.syntaxTree().modifyWith((Node)newRoot);
    }

    private static class FunctionCallModifier
    extends TreeModifier {
        String moduleName;

        public FunctionCallModifier(String moduleName) {
            this.moduleName = moduleName;
        }

        public FunctionCallExpressionNode transform(FunctionCallExpressionNode functionCall) {
            NameReferenceNode nameRef = functionCall.functionName();
            if (nameRef.kind() != SyntaxKind.QUALIFIED_NAME_REFERENCE) {
                return functionCall;
            }
            QualifiedNameReferenceNode qualifiedNameRef = (QualifiedNameReferenceNode)nameRef;
            if (!qualifiedNameRef.modulePrefix().text().equals("log")) {
                return functionCall;
            }
            String text = qualifiedNameRef.identifier().text();
            if (!(text.equals("printError") || text.equals("printWarn") || text.equals("printInfo") || text.equals("printDebug"))) {
                return functionCall;
            }
            ArrayList<Object> arguments = new ArrayList<Object>();
            for (FunctionArgumentNode arg : functionCall.arguments()) {
                if (arguments.size() > 0) {
                    arguments.add(NodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN));
                }
                arguments.add(arg);
            }
            NamedArgumentNode moduleName = NodeFactory.createNamedArgumentNode((SimpleNameReferenceNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"module")), (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.EQUAL_TOKEN), (ExpressionNode)NodeFactory.createBasicLiteralNode((SyntaxKind)SyntaxKind.STRING_LITERAL, (Token)AbstractNodeFactory.createLiteralValueToken((SyntaxKind)SyntaxKind.STRING_LITERAL_TOKEN, (String)("\"" + this.moduleName + "\""), (MinutiaeList)AbstractNodeFactory.createEmptyMinutiaeList(), (MinutiaeList)AbstractNodeFactory.createEmptyMinutiaeList())));
            if (arguments.size() > 0) {
                arguments.add(NodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN));
            }
            arguments.add(moduleName);
            return functionCall.modify().withArguments(NodeFactory.createSeparatedNodeList(arguments)).apply();
        }
    }
}

