/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.websub;

import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.websub.ServiceRegistry;
import java.util.Objects;

public final class NativeWebSubListenerAdaptor {
    private NativeWebSubListenerAdaptor() {
    }

    public static void externAttach(BObject websubListener, BString servicePath, BObject subscriberService, BObject httpService, BMap<BString, Object> subscriberConfig) {
        subscriberService.addNativeData("SERVICE_PATH", (Object)servicePath);
        httpService.addNativeData("SUBSCRIBER_CONFIG", subscriberConfig);
        ServiceRegistry serviceRegistry = NativeWebSubListenerAdaptor.getServiceRegistry(websubListener);
        serviceRegistry.addHttpService(servicePath, httpService);
    }

    private static ServiceRegistry getServiceRegistry(BObject websubListener) {
        Object serviceRegistry = websubListener.getNativeData("SERVICE_REGISTRY");
        if (Objects.nonNull(serviceRegistry)) {
            return (ServiceRegistry)serviceRegistry;
        }
        ServiceRegistry serviceRegistryInstance = ServiceRegistry.getInstance();
        websubListener.addNativeData("SERVICE_REGISTRY", (Object)serviceRegistryInstance);
        return serviceRegistryInstance;
    }

    public static BObject detachHttpService(BObject websubListener, BObject subscriberService) {
        ServiceRegistry serviceRegistry = (ServiceRegistry)websubListener.getNativeData("SERVICE_REGISTRY");
        return serviceRegistry.detachHttpService(subscriberService);
    }

    public static BArray retrieveAttachedServices(BObject websubListener) {
        Object serviceRegistryObj = websubListener.getNativeData("SERVICE_REGISTRY");
        if (Objects.nonNull(serviceRegistryObj)) {
            ServiceRegistry serviceRegistry = (ServiceRegistry)serviceRegistryObj;
            Object[] attachedServices = serviceRegistry.getAttachedServices();
            if (attachedServices.length > 0) {
                ArrayType arrType = TypeCreator.createArrayType((Type)TypeUtils.getType((Object)attachedServices[0]));
                return ValueCreator.createArrayValue((Object[])attachedServices, (ArrayType)arrType);
            }
            return null;
        }
        return null;
    }
}

