/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.ftp.client;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.ftp.client.FtpClientHelper;
import io.ballerina.stdlib.ftp.client.FtpClientListener;
import io.ballerina.stdlib.ftp.exception.BallerinaFtpException;
import io.ballerina.stdlib.ftp.exception.RemoteFileSystemConnectorException;
import io.ballerina.stdlib.ftp.transport.client.connector.contract.FtpAction;
import io.ballerina.stdlib.ftp.transport.client.connector.contract.VfsClientConnector;
import io.ballerina.stdlib.ftp.transport.client.connector.contractimpl.VfsClientConnectorImpl;
import io.ballerina.stdlib.ftp.transport.impl.RemoteFileSystemConnectorFactoryImpl;
import io.ballerina.stdlib.ftp.transport.message.RemoteFileSystemMessage;
import io.ballerina.stdlib.ftp.util.BufferHolder;
import io.ballerina.stdlib.ftp.util.FtpUtil;
import io.ballerina.stdlib.io.utils.IOUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FtpClient {
    private static final Logger log = LoggerFactory.getLogger(FtpClient.class);

    private FtpClient() {
    }

    public static Object initClientEndpoint(BObject clientEndpoint, BMap<Object, Object> config) {
        String url;
        String protocol = config.getStringValue(StringUtils.fromString((String)"protocol")).getValue();
        Map<String, String> authMap = FtpUtil.getAuthMap(config);
        clientEndpoint.addNativeData("username", (Object)authMap.get("username"));
        clientEndpoint.addNativeData("password", (Object)authMap.get("password"));
        clientEndpoint.addNativeData("host", (Object)config.getStringValue(StringUtils.fromString((String)"host")).getValue());
        clientEndpoint.addNativeData("port", (Object)FtpUtil.extractPortValue(config.getIntValue(StringUtils.fromString((String)"port"))));
        clientEndpoint.addNativeData("protocol", (Object)protocol);
        HashMap<String, String> ftpConfig = new HashMap<String, String>(5);
        BMap auth = config.getMapValue(StringUtils.fromString((String)"auth"));
        if (auth != null) {
            BMap privateKey = auth.getMapValue(StringUtils.fromString((String)"privateKey"));
            if (privateKey != null) {
                BString privateKeyPath = privateKey.getStringValue(StringUtils.fromString((String)"path"));
                ftpConfig.put("IDENTITY", privateKeyPath.getValue());
                BString privateKeyPassword = privateKey.getStringValue(StringUtils.fromString((String)"password"));
                if (privateKeyPassword != null && !privateKeyPassword.getValue().isEmpty()) {
                    ftpConfig.put("IDENTITY_PASS_PHRASE", privateKeyPassword.getValue());
                }
            }
            ftpConfig.put("preferredMethods", FtpUtil.getPreferredMethodsFromAuthConfig(auth));
        }
        ftpConfig.put("PASSIVE_MODE", String.valueOf(true));
        ftpConfig.put("USER_DIR_IS_ROOT", String.valueOf(false));
        ftpConfig.put("AVOID_PERMISSION_CHECK", String.valueOf(true));
        try {
            url = FtpUtil.createUrl(clientEndpoint, "");
        }
        catch (BallerinaFtpException e) {
            return FtpUtil.createError(e.getMessage(), FtpUtil.ErrorType.Error.errorType());
        }
        ftpConfig.put("uri", url);
        clientEndpoint.addNativeData("map", ftpConfig);
        RemoteFileSystemConnectorFactoryImpl fileSystemConnectorFactory = new RemoteFileSystemConnectorFactoryImpl();
        try {
            VfsClientConnector connector = fileSystemConnectorFactory.createVfsClientConnector(ftpConfig);
            clientEndpoint.addNativeData("VfsClientConnector", (Object)connector);
        }
        catch (RemoteFileSystemConnectorException e) {
            return FtpUtil.createError(e.getMessage(), FtpUtil.findRootCause(e), FtpUtil.ErrorType.Error.errorType());
        }
        return null;
    }

    public static Object getFirst(Environment env, BObject clientConnector, BString filePath) {
        clientConnector.addNativeData("entity_byte_stream", null);
        return env.yieldAndRun(() -> {
            CompletableFuture<Object> balFuture = new CompletableFuture<Object>();
            FtpClientListener connectorListener = new FtpClientListener(balFuture, false, remoteFileSystemBaseMessage -> FtpClientHelper.executeGetAction(remoteFileSystemBaseMessage, balFuture, clientConnector));
            VfsClientConnectorImpl connector = (VfsClientConnectorImpl)clientConnector.getNativeData("VfsClientConnector");
            connector.addListener(connectorListener);
            connector.send(null, FtpAction.GET, filePath.getValue(), null);
            return FtpClient.getResult(balFuture);
        });
    }

    public static Object get(BObject clientConnector) {
        return FtpClientHelper.generateInputStreamEntry((InputStream)clientConnector.getNativeData("readInputStream"));
    }

    public static Object closeInputByteStream(BObject clientObject) {
        InputStream readInputStream = (InputStream)clientObject.getNativeData("readInputStream");
        if (readInputStream != null) {
            try {
                readInputStream.close();
                clientObject.addNativeData("readInputStream", null);
                clientObject.addNativeData("entity_byte_stream", null);
                return null;
            }
            catch (IOException e) {
                return IOUtils.createError((Throwable)e);
            }
        }
        return null;
    }

    public static Object append(Environment env, BObject clientConnector, BMap<Object, Object> inputContent) {
        RemoteFileSystemMessage message;
        boolean isFile = inputContent.getBooleanValue(StringUtils.fromString((String)"isFile"));
        if (isFile) {
            InputStream stream = FtpClientHelper.getUploadStream(env, clientConnector, inputContent, true);
            message = new RemoteFileSystemMessage(stream);
        } else {
            String textContent = inputContent.getStringValue(StringUtils.fromString((String)"textContent")).getValue();
            ByteArrayInputStream stream = new ByteArrayInputStream(textContent.getBytes());
            message = new RemoteFileSystemMessage(stream);
        }
        return env.yieldAndRun(() -> {
            CompletableFuture<Object> balFuture = new CompletableFuture<Object>();
            FtpClientListener connectorListener = new FtpClientListener(balFuture, true, remoteFileSystemBaseMessage -> FtpClientHelper.executeGenericAction());
            VfsClientConnectorImpl connector = (VfsClientConnectorImpl)clientConnector.getNativeData("VfsClientConnector");
            connector.addListener(connectorListener);
            connector.send(message, FtpAction.APPEND, inputContent.getStringValue(StringUtils.fromString((String)"filePath")).getValue(), null);
            return FtpClient.getResult(balFuture);
        });
    }

    public static Object put(Environment env, BObject clientConnector, BMap<Object, Object> inputContent) {
        RemoteFileSystemMessage message;
        HashMap<String, String> propertyMap = new HashMap<String, String>((Map)clientConnector.getNativeData("map"));
        boolean isFile = inputContent.getBooleanValue(StringUtils.fromString((String)"isFile"));
        boolean compressInput = inputContent.getBooleanValue(StringUtils.fromString((String)"compressInput"));
        InputStream stream = FtpClientHelper.getUploadStream(env, clientConnector, inputContent, isFile);
        ByteArrayInputStream compressedStream = null;
        if (stream != null) {
            if (compressInput) {
                compressedStream = FtpUtil.compress(stream, inputContent.getStringValue(StringUtils.fromString((String)"filePath")).getValue());
                message = FtpClientHelper.getCompressedMessage(clientConnector, inputContent.getStringValue(StringUtils.fromString((String)"filePath")).getValue(), propertyMap, compressedStream);
            } else {
                try {
                    message = FtpClientHelper.getUncompressedMessage(clientConnector, inputContent.getStringValue(StringUtils.fromString((String)"filePath")).getValue(), propertyMap, stream);
                }
                catch (BallerinaFtpException e) {
                    return FtpUtil.createError(e.getMessage(), FtpUtil.ErrorType.Error.errorType());
                }
            }
        } else {
            return FtpUtil.createError("Error while reading a file", FtpUtil.ErrorType.Error.errorType());
        }
        Object result = env.yieldAndRun(() -> {
            CompletableFuture<Object> balFuture = new CompletableFuture<Object>();
            FtpClientListener connectorListener = new FtpClientListener(balFuture, true, remoteFileSystemBaseMessage -> FtpClientHelper.executeGenericAction());
            VfsClientConnectorImpl connector = (VfsClientConnectorImpl)clientConnector.getNativeData("VfsClientConnector");
            connector.addListener(connectorListener);
            String filePath = inputContent.getStringValue(StringUtils.fromString((String)"filePath")).getValue();
            if (compressInput) {
                filePath = FtpUtil.getCompressedFileName(filePath);
            }
            connector.send(message, FtpAction.PUT, filePath, null);
            return FtpClient.getResult(balFuture);
        });
        try {
            stream.close();
            if (compressedStream != null) {
                compressedStream.close();
            }
        }
        catch (IOException e) {
            log.error("Error in closing stream");
        }
        return result;
    }

    public static Object delete(Environment env, BObject clientConnector, BString filePath) {
        return env.yieldAndRun(() -> {
            CompletableFuture<Object> balFuture = new CompletableFuture<Object>();
            FtpClientListener connectorListener = new FtpClientListener(balFuture, true, remoteFileSystemBaseMessage -> FtpClientHelper.executeGenericAction());
            VfsClientConnectorImpl connector = (VfsClientConnectorImpl)clientConnector.getNativeData("VfsClientConnector");
            connector.addListener(connectorListener);
            connector.send(null, FtpAction.DELETE, filePath.getValue(), null);
            return FtpClient.getResult(balFuture);
        });
    }

    public static Object isDirectory(Environment env, BObject clientConnector, BString filePath) {
        return env.yieldAndRun(() -> {
            CompletableFuture<Object> balFuture = new CompletableFuture<Object>();
            FtpClientListener connectorListener = new FtpClientListener(balFuture, false, remoteFileSystemBaseMessage -> FtpClientHelper.executeIsDirectoryAction(remoteFileSystemBaseMessage, balFuture));
            VfsClientConnectorImpl connector = (VfsClientConnectorImpl)clientConnector.getNativeData("VfsClientConnector");
            connector.addListener(connectorListener);
            connector.send(null, FtpAction.ISDIR, filePath.getValue(), null);
            return FtpClient.getResult(balFuture);
        });
    }

    public static Object list(Environment env, BObject clientConnector, BString filePath) {
        return env.yieldAndRun(() -> {
            CompletableFuture<Object> balFuture = new CompletableFuture<Object>();
            FtpClientListener connectorListener = new FtpClientListener(balFuture, false, remoteFileSystemBaseMessage -> FtpClientHelper.executeListAction(remoteFileSystemBaseMessage, balFuture));
            VfsClientConnectorImpl connector = (VfsClientConnectorImpl)clientConnector.getNativeData("VfsClientConnector");
            connector.addListener(connectorListener);
            connector.send(null, FtpAction.LIST, filePath.getValue(), null);
            return FtpClient.getResult(balFuture);
        });
    }

    public static Object mkdir(Environment env, BObject clientConnector, BString path) {
        return env.yieldAndRun(() -> {
            CompletableFuture<Object> balFuture = new CompletableFuture<Object>();
            FtpClientListener connectorListener = new FtpClientListener(balFuture, true, remoteFileSystemBaseMessage -> FtpClientHelper.executeGenericAction());
            VfsClientConnectorImpl connector = (VfsClientConnectorImpl)clientConnector.getNativeData("VfsClientConnector");
            connector.addListener(connectorListener);
            connector.send(null, FtpAction.MKDIR, path.getValue(), null);
            return FtpClient.getResult(balFuture);
        });
    }

    public static Object rename(Environment env, BObject clientConnector, BString origin, BString destination) {
        String destinationUrl;
        HashMap<String, String> propertyMap = new HashMap<String, String>((Map)clientConnector.getNativeData("map"));
        try {
            propertyMap.put("uri", FtpUtil.createUrl(clientConnector, origin.getValue()));
            propertyMap.put("destination", FtpUtil.createUrl(clientConnector, destination.getValue()));
            destinationUrl = FtpUtil.createUrl(clientConnector, destination.getValue());
        }
        catch (BallerinaFtpException e) {
            return FtpUtil.createError(e.getMessage(), FtpUtil.ErrorType.Error.errorType());
        }
        return env.yieldAndRun(() -> {
            CompletableFuture<Object> balFuture = new CompletableFuture<Object>();
            FtpClientListener connectorListener = new FtpClientListener(balFuture, true, remoteFileSystemBaseMessage -> FtpClientHelper.executeGenericAction());
            VfsClientConnectorImpl connector = (VfsClientConnectorImpl)clientConnector.getNativeData("VfsClientConnector");
            connector.addListener(connectorListener);
            connector.send(null, FtpAction.RENAME, origin.getValue(), destinationUrl);
            return FtpClient.getResult(balFuture);
        });
    }

    public static Object rmdir(Environment env, BObject clientConnector, BString filePath) {
        return env.yieldAndRun(() -> {
            CompletableFuture<Object> balFuture = new CompletableFuture<Object>();
            FtpClientListener connectorListener = new FtpClientListener(balFuture, true, remoteFileSystemBaseMessage -> FtpClientHelper.executeGenericAction());
            VfsClientConnectorImpl connector = (VfsClientConnectorImpl)clientConnector.getNativeData("VfsClientConnector");
            connector.addListener(connectorListener);
            connector.send(null, FtpAction.RMDIR, filePath.getValue(), null);
            return FtpClient.getResult(balFuture);
        });
    }

    public static Object size(Environment env, BObject clientConnector, BString filePath) {
        HashMap<String, String> propertyMap = new HashMap<String, String>((Map)clientConnector.getNativeData("map"));
        propertyMap.put("PASSIVE_MODE", Boolean.TRUE.toString());
        return env.yieldAndRun(() -> {
            CompletableFuture<Object> balFuture = new CompletableFuture<Object>();
            FtpClientListener connectorListener = new FtpClientListener(balFuture, false, remoteFileSystemBaseMessage -> FtpClientHelper.executeSizeAction(remoteFileSystemBaseMessage, balFuture));
            VfsClientConnectorImpl connector = (VfsClientConnectorImpl)clientConnector.getNativeData("VfsClientConnector");
            connector.addListener(connectorListener);
            connector.send(null, FtpAction.SIZE, filePath.getValue(), null);
            return FtpClient.getResult(balFuture);
        });
    }

    public static Object getResult(CompletableFuture<Object> balFuture) {
        try {
            return balFuture.get();
        }
        catch (InterruptedException e) {
            throw ErrorCreator.createError((Throwable)e);
        }
        catch (Throwable throwable) {
            throw ErrorCreator.createError((Throwable)throwable);
        }
    }

    public static void handleStreamEnd(BObject entity, BufferHolder bufferHolder) {
        entity.addNativeData("entity_byte_stream", null);
        bufferHolder.setTerminal(true);
    }
}

