/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.ftp.client;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BStream;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.ftp.exception.BallerinaFtpException;
import io.ballerina.stdlib.ftp.transport.message.FileInfo;
import io.ballerina.stdlib.ftp.transport.message.RemoteFileSystemBaseMessage;
import io.ballerina.stdlib.ftp.transport.message.RemoteFileSystemMessage;
import io.ballerina.stdlib.ftp.util.BufferHolder;
import io.ballerina.stdlib.ftp.util.FtpConstants;
import io.ballerina.stdlib.ftp.util.FtpUtil;
import io.ballerina.stdlib.io.channels.base.Channel;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.vfs2.FileSystemException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FtpClientHelper {
    private static final Logger log = LoggerFactory.getLogger(FtpClientHelper.class);

    private FtpClientHelper() {
    }

    static boolean executeGenericAction() {
        return true;
    }

    static boolean executeGetAction(RemoteFileSystemBaseMessage remoteFileSystemBaseMessage, CompletableFuture<Object> balFuture, BObject clientConnector) {
        try {
            if (remoteFileSystemBaseMessage instanceof RemoteFileSystemMessage) {
                InputStream in = ((RemoteFileSystemMessage)remoteFileSystemBaseMessage).getInputStream();
                FtpByteChannel byteChannel = new FtpByteChannel(in);
                FtpChannel channel = new FtpChannel(byteChannel);
                InputStream inputStream = channel.getInputStream();
                clientConnector.addNativeData("readInputStream", (Object)inputStream);
                BMap<BString, Object> streamEntry = FtpClientHelper.generateInputStreamEntry(inputStream);
                clientConnector.addNativeData("entity_byte_stream", streamEntry);
                balFuture.complete(streamEntry);
            }
        }
        catch (IOException e) {
            log.error("Error occurred while reading stream: ", (Throwable)e);
        }
        return true;
    }

    public static BMap<BString, Object> generateInputStreamEntry(InputStream inputStream) {
        BMap streamEntry = ValueCreator.createRecordValue((Module)FtpUtil.getFtpPackage(), (String)"StreamEntry");
        try {
            byte[] buffer = new byte[8192];
            int readNumber = inputStream.read(buffer);
            if (readNumber == -1) {
                inputStream.close();
                streamEntry.addNativeData("readInputStream", null);
                return null;
            }
            byte[] returnArray = readNumber < 8192 ? Arrays.copyOfRange(buffer, 0, readNumber) : buffer;
            streamEntry.put((Object)FtpConstants.FIELD_VALUE, (Object)ValueCreator.createArrayValue((byte[])returnArray));
        }
        catch (IOException e) {
            log.error("Error occurred while reading stream: ", (Throwable)e);
        }
        return streamEntry;
    }

    static boolean executeIsDirectoryAction(RemoteFileSystemBaseMessage remoteFileSystemBaseMessage, CompletableFuture<Object> balFuture) {
        if (remoteFileSystemBaseMessage instanceof RemoteFileSystemMessage) {
            balFuture.complete(((RemoteFileSystemMessage)remoteFileSystemBaseMessage).isDirectory());
        }
        return true;
    }

    static boolean executeListAction(RemoteFileSystemBaseMessage remoteFileSystemBaseMessage, CompletableFuture<Object> balFuture) {
        if (remoteFileSystemBaseMessage instanceof RemoteFileSystemMessage) {
            RemoteFileSystemMessage message = (RemoteFileSystemMessage)remoteFileSystemBaseMessage;
            Map<String, FileInfo> childrenInfo = message.getChildrenInfo();
            BArray arrayValue = ValueCreator.createArrayValue((ArrayType)TypeCreator.createArrayType((Type)FtpUtil.getFileInfoType()));
            int i = 0;
            for (Map.Entry<String, FileInfo> entry : childrenInfo.entrySet()) {
                HashMap<String, Object> fileInfoParams = new HashMap<String, Object>();
                FileInfo fileInfo = entry.getValue();
                fileInfoParams.put("path", fileInfo.getPath());
                fileInfoParams.put("size", fileInfo.getFileSize());
                fileInfoParams.put("lastModifiedTimestamp", fileInfo.getLastModifiedTime());
                fileInfoParams.put("name", fileInfo.getBaseName());
                fileInfoParams.put("isFolder", fileInfo.isFolder());
                fileInfoParams.put("isFile", fileInfo.isFile());
                fileInfoParams.put("extension", fileInfo.getFileName().getExtension());
                fileInfoParams.put("publicURIString", fileInfo.getPublicURIString());
                fileInfoParams.put("fileType", fileInfo.getFileType().getName());
                fileInfoParams.put("isAttached", fileInfo.isAttached());
                fileInfoParams.put("isContentOpen", fileInfo.isContentOpen());
                fileInfoParams.put("isExecutable", fileInfo.isExecutable());
                fileInfoParams.put("isHidden", fileInfo.isHidden());
                fileInfoParams.put("isReadable", fileInfo.isReadable());
                fileInfoParams.put("isWritable", fileInfo.isWritable());
                fileInfoParams.put("depth", fileInfo.getFileName().getDepth());
                fileInfoParams.put("scheme", fileInfo.getFileName().getScheme());
                fileInfoParams.put("uri", fileInfo.getFileName().getURI());
                fileInfoParams.put("rootURI", fileInfo.getFileName().getRootURI());
                fileInfoParams.put("friendlyURI", fileInfo.getFileName().getFriendlyURI());
                try {
                    fileInfoParams.put("pathDecoded", fileInfo.getFileName().getPathDecoded());
                }
                catch (FileSystemException e) {
                    log.error("Error while evaluating the pathDecoded value.", (Throwable)e);
                }
                BMap ballerinaFileInfo = ValueCreator.createRecordValue((Module)new Module("ballerina", "ftp", FtpUtil.getFtpPackage().getMajorVersion()), (String)"FileInfo", fileInfoParams);
                arrayValue.add((long)i++, (Object)ballerinaFileInfo);
            }
            balFuture.complete(arrayValue);
        }
        return true;
    }

    static boolean executeSizeAction(RemoteFileSystemBaseMessage remoteFileSystemBaseMessage, CompletableFuture<Object> balFuture) {
        if (remoteFileSystemBaseMessage instanceof RemoteFileSystemMessage) {
            RemoteFileSystemMessage message = (RemoteFileSystemMessage)remoteFileSystemBaseMessage;
            balFuture.complete((int)message.getSize());
        }
        return true;
    }

    static InputStream getUploadStream(final Environment env, final BObject clientConnector, BMap<Object, Object> inputContent, boolean isFile) {
        if (isFile) {
            BStream fileByteStream = (BStream)inputContent.get((Object)StringUtils.fromString((String)"fileContent"));
            if (fileByteStream != null) {
                final BObject iteratorObj = fileByteStream.getIteratorObj();
                ByteArrayInputStream fileInputStream = new ByteArrayInputStream(new byte[0]){
                    private final BufferHolder bufferHolder;
                    {
                        super(arg0);
                        this.bufferHolder = new BufferHolder();
                    }

                    @Override
                    public int read(byte[] b) {
                        if (this.bufferHolder.getBuffer().length == 0) {
                            FtpClientHelper.callStreamNext(env, clientConnector, this.bufferHolder, iteratorObj);
                        }
                        int bLength = b.length;
                        int buffLength = this.bufferHolder.getBuffer().length;
                        if (this.bufferHolder.isTerminal()) {
                            return -1;
                        }
                        if (bLength > buffLength) {
                            for (int i = 0; i < buffLength; ++i) {
                                b[i] = this.bufferHolder.getBuffer()[i];
                            }
                            this.bufferHolder.setBuffer(new byte[0]);
                            return buffLength;
                        }
                        for (int i = 0; i < bLength; ++i) {
                            b[i] = this.bufferHolder.getBuffer()[i];
                        }
                        int remainCount = buffLength % bLength;
                        byte[] remainBytes = new byte[remainCount];
                        for (int i = 0; i < remainCount; ++i) {
                            remainBytes[i] = this.bufferHolder.getBuffer()[buffLength - remainCount + i];
                        }
                        this.bufferHolder.setBuffer(remainBytes);
                        return bLength;
                    }

                    @Override
                    public void close() {
                        FtpClientHelper.callStreamClose(env, clientConnector, this.bufferHolder, iteratorObj);
                    }
                };
                return fileInputStream;
            }
            return null;
        }
        String textContent = inputContent.getStringValue(StringUtils.fromString((String)"textContent")).getValue();
        return new ByteArrayInputStream(textContent.getBytes());
    }

    private static void callStreamNext(Environment env, BObject entity, BufferHolder bufferHolder, BObject iteratorObj) {
        Object result = env.getRuntime().callMethod(iteratorObj, "next", null, new Object[0]);
        if (result == bufferHolder.getTerminalType()) {
            FtpClientHelper.handleStreamEnd(entity, bufferHolder);
            return;
        }
        BArray arrayValue = ((BMap)result).getArrayValue(FtpConstants.FIELD_VALUE);
        if (arrayValue == null) {
            FtpClientHelper.handleStreamEnd(entity, bufferHolder);
            return;
        }
        byte[] bytes = arrayValue.getBytes();
        bufferHolder.setBuffer(bytes);
        bufferHolder.setTerminal(false);
    }

    private static void callStreamClose(Environment env, BObject entity, BufferHolder bufferHolder, BObject iteratorObj) {
        try {
            env.getRuntime().callMethod(iteratorObj, "close", null, new Object[0]);
            FtpClientHelper.handleStreamEnd(entity, bufferHolder);
        }
        catch (Throwable t) {
            FtpClientHelper.handleStreamEnd(entity, bufferHolder);
        }
    }

    public static void handleStreamEnd(BObject entity, BufferHolder bufferHolder) {
        entity.addNativeData("entity_byte_stream", null);
        bufferHolder.setTerminal(true);
    }

    static RemoteFileSystemMessage getUncompressedMessage(BObject clientConnector, String filePath, Map<String, String> propertyMap, InputStream stream) throws BallerinaFtpException {
        String url = FtpUtil.createUrl(clientConnector, filePath);
        propertyMap.put("uri", url);
        return new RemoteFileSystemMessage(stream);
    }

    static RemoteFileSystemMessage getCompressedMessage(BObject clientConnector, String filePath, Map<String, String> propertyMap, ByteArrayInputStream compressedStream) {
        try {
            String compressedFilePath = FtpUtil.getCompressedFileName(filePath);
            String url = FtpUtil.createUrl(clientConnector, compressedFilePath);
            propertyMap.put("uri", url);
            return new RemoteFileSystemMessage(compressedStream);
        }
        catch (BallerinaFtpException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    private static class FtpByteChannel
    implements ByteChannel {
        private InputStream inputStream;
        private ReadableByteChannel inputChannel;

        FtpByteChannel(InputStream inputStream) {
            this.inputStream = inputStream;
            this.inputChannel = Channels.newChannel(inputStream);
        }

        @Override
        public int read(ByteBuffer dst) throws IOException {
            return this.inputChannel.read(dst);
        }

        @Override
        public int write(ByteBuffer src) {
            return 0;
        }

        @Override
        public boolean isOpen() {
            return this.inputChannel.isOpen();
        }

        @Override
        public void close() throws IOException {
            this.inputChannel.close();
            this.inputStream.close();
        }
    }

    private static class FtpChannel
    extends Channel {
        FtpChannel(ByteChannel channel) {
            super(channel);
        }

        public void transfer(int i, int i1, WritableByteChannel writableByteChannel) {
            throw new UnsupportedOperationException();
        }

        public Channel getChannel() {
            return this;
        }

        public boolean remaining() {
            return false;
        }
    }
}

