/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.ftp.client;

import io.ballerina.runtime.api.values.BError;
import io.ballerina.stdlib.ftp.transport.listener.RemoteFileSystemListener;
import io.ballerina.stdlib.ftp.transport.message.RemoteFileSystemBaseMessage;
import io.ballerina.stdlib.ftp.util.FtpUtil;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FtpClientListener
implements RemoteFileSystemListener {
    private static final Logger log = LoggerFactory.getLogger(FtpClientListener.class);
    private Function<RemoteFileSystemBaseMessage, Boolean> function;
    private boolean isGenericAction;
    private CompletableFuture<Object> balFuture;

    FtpClientListener(CompletableFuture<Object> listenerFuture, boolean isGenericAction, Function<RemoteFileSystemBaseMessage, Boolean> function) {
        this.balFuture = listenerFuture;
        this.function = function;
        this.isGenericAction = isGenericAction;
    }

    @Override
    public boolean onMessage(RemoteFileSystemBaseMessage remoteFileSystemBaseMessage) {
        return this.function.apply(remoteFileSystemBaseMessage);
    }

    @Override
    public void onError(Throwable throwable) {
        log.error(throwable.getMessage(), throwable);
        this.balFuture.complete(FtpUtil.createError(throwable.getMessage(), throwable.getCause(), FtpUtil.ErrorType.Error.errorType()));
    }

    @Override
    public BError done() {
        if (this.isGenericAction) {
            this.balFuture.complete(null);
        }
        log.debug("Successfully finished the action.");
        return null;
    }
}

