/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.ftp.transport.client.connector.contractimpl;

import io.ballerina.stdlib.ftp.exception.BallerinaFtpException;
import io.ballerina.stdlib.ftp.exception.RemoteFileSystemConnectorException;
import io.ballerina.stdlib.ftp.transport.client.connector.contract.FtpAction;
import io.ballerina.stdlib.ftp.transport.client.connector.contract.VfsClientConnector;
import io.ballerina.stdlib.ftp.transport.client.connector.contractimpl.FileObjectInputStream;
import io.ballerina.stdlib.ftp.transport.listener.RemoteFileSystemListener;
import io.ballerina.stdlib.ftp.transport.message.FileInfo;
import io.ballerina.stdlib.ftp.transport.message.RemoteFileSystemMessage;
import io.ballerina.stdlib.ftp.transport.server.util.FileTransportUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.Selectors;
import org.apache.commons.vfs2.VFS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VfsClientConnectorImpl
implements VfsClientConnector {
    private static final Logger logger = LoggerFactory.getLogger(VfsClientConnectorImpl.class);
    private Map<String, String> connectorConfig;
    private RemoteFileSystemListener remoteFileSystemListener;
    private FileSystemOptions opts;
    private FileObject path;
    private FileSystemManager fsManager;

    public VfsClientConnectorImpl(Map<String, String> config) throws RemoteFileSystemConnectorException {
        this.connectorConfig = config;
        this.opts = FileTransportUtils.attachFileSystemOptions(config);
        String fileURI = null;
        try {
            this.fsManager = VFS.getManager();
            fileURI = this.connectorConfig.get("uri");
            this.path = this.fsManager.resolveFile(fileURI, this.opts);
        }
        catch (FileSystemException e) {
            throw new RemoteFileSystemConnectorException("Error while connecting to the FTP server with URL: " + (fileURI != null ? fileURI : ""), e.getCause());
        }
    }

    public void addListener(RemoteFileSystemListener listener) {
        this.remoteFileSystemListener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(RemoteFileSystemMessage message, FtpAction action, String filePath, String destination) {
        OutputStream outputStream = null;
        FileObject fileObject = null;
        boolean pathClose = true;
        try {
            try {
                fileObject = this.path.resolveFile(filePath);
            }
            catch (FileSystemException e) {
                throw new BallerinaFtpException(e.getMessage(), e.getCause());
            }
            switch (action) {
                case MKDIR: {
                    if (fileObject.exists()) {
                        throw new RemoteFileSystemConnectorException("Directory exists: " + fileObject.getName().getURI());
                    }
                    fileObject.createFolder();
                    break;
                }
                case PUT: 
                case APPEND: {
                    if (!fileObject.exists()) {
                        fileObject.createFile();
                        fileObject.refresh();
                    }
                    outputStream = FtpAction.APPEND.equals((Object)action) ? fileObject.getContent().getOutputStream(true) : fileObject.getContent().getOutputStream();
                    InputStream inputStream = message.getInputStream();
                    ByteBuffer byteBuffer = message.getBytes();
                    if (byteBuffer != null) {
                        outputStream.write(byteBuffer.array());
                    } else if (inputStream != null) {
                        int n;
                        byte[] buffer = new byte[16384];
                        while ((n = inputStream.read(buffer)) > -1) {
                            outputStream.write(buffer, 0, n);
                        }
                    }
                    outputStream.flush();
                    break;
                }
                case DELETE: {
                    if (fileObject.exists()) {
                        int filesDeleted = fileObject.delete(Selectors.SELECT_SELF);
                        if (!logger.isDebugEnabled()) break;
                        logger.debug(filesDeleted + " files successfully deleted");
                        break;
                    }
                    throw new RemoteFileSystemConnectorException("Failed to delete file: " + fileObject.getName().getURI() + " not found");
                }
                case RMDIR: {
                    if (fileObject.exists()) {
                        int filesDeleted = fileObject.delete(Selectors.SELECT_ALL);
                        if (!logger.isDebugEnabled()) break;
                        logger.debug(filesDeleted + " files successfully deleted");
                        break;
                    }
                    throw new RemoteFileSystemConnectorException("Failed to delete directory: " + fileObject.getName().getURI() + " not found");
                }
                case RENAME: {
                    if (fileObject.exists()) {
                        try (FileObject newPath = this.fsManager.resolveFile(destination, this.opts);
                             FileObject parent = newPath.getParent();){
                            if (parent == null) break;
                            if (!parent.exists()) {
                                parent.createFolder();
                            }
                            try (FileObject finalPath = parent.resolveFile(newPath.getName().getBaseName());){
                                if (!finalPath.exists()) {
                                    fileObject.moveTo(finalPath);
                                    break;
                                }
                                throw new RemoteFileSystemConnectorException("The file at " + newPath.getURL().toString() + " already exists or it is a directory");
                            }
                        }
                    }
                    throw new RemoteFileSystemConnectorException("Failed to rename file: " + fileObject.getName().getURI() + " not found");
                }
                case GET: {
                    if (fileObject.exists()) {
                        InputStream inputStream = fileObject.getContent().getInputStream();
                        FileObjectInputStream objectInputStream = new FileObjectInputStream(inputStream, fileObject);
                        RemoteFileSystemMessage fileContent = new RemoteFileSystemMessage((InputStream)((Object)objectInputStream));
                        this.remoteFileSystemListener.onMessage(fileContent);
                        pathClose = false;
                        break;
                    }
                    throw new RemoteFileSystemConnectorException("Failed to read file: " + fileObject.getName().getURI() + " not found");
                }
                case SIZE: {
                    this.remoteFileSystemListener.onMessage(new RemoteFileSystemMessage(fileObject.getContent().getSize()));
                    break;
                }
                case LIST: {
                    FileObject[] fileObjects = fileObject.getChildren();
                    HashMap<String, FileInfo> childrenInfo = new HashMap<String, FileInfo>();
                    for (FileObject tmpFileObject : fileObjects) {
                        FileInfo fileInfo = new FileInfo(tmpFileObject);
                        childrenInfo.put(fileInfo.getBaseName(), fileInfo);
                    }
                    RemoteFileSystemMessage children = new RemoteFileSystemMessage(childrenInfo);
                    this.remoteFileSystemListener.onMessage(children);
                    break;
                }
                case ISDIR: {
                    if (!fileObject.exists()) {
                        throw new BallerinaFtpException(filePath + " does not exists to check if it is a directory.");
                    }
                    this.remoteFileSystemListener.onMessage(new RemoteFileSystemMessage(fileObject.isFolder()));
                    break;
                }
            }
            this.remoteFileSystemListener.done();
        }
        catch (BallerinaFtpException | RemoteFileSystemConnectorException | IOException e) {
            this.remoteFileSystemListener.onError(e);
        }
        finally {
            if (fileObject != null && pathClose) {
                try {
                    fileObject.close();
                }
                catch (FileSystemException e) {
                    logger.error("Error while closing the remote file.");
                }
            }
            VfsClientConnectorImpl.closeQuietly(outputStream);
        }
    }

    private static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException e) {
            logger.error("Error while closing the stream.");
        }
    }
}

