/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.ftp.transport.message;

import java.net.URL;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;

public class FileInfo {
    private final String path;
    private long fileSize;
    private long lastModifiedTime;
    private FileName fileName;
    private String publicURIString;
    private FileType fileType;
    private boolean isAttached;
    private URL url;
    private boolean isContentOpen;
    private boolean isExecutable;
    private boolean isFile;
    private boolean isFolder;
    private boolean isHidden;
    private boolean isReadable;
    private boolean isWritable;

    public FileInfo(String path) {
        this.path = path;
    }

    public FileInfo(FileObject fileObject) throws FileSystemException {
        this.fileName = fileObject.getName();
        this.path = this.fileName.getPath();
        this.publicURIString = fileObject.getPublicURIString();
        this.isFolder = fileObject.isFolder();
        this.isFile = fileObject.isFile();
        this.fileType = fileObject.getType();
        this.isAttached = fileObject.isAttached();
        this.url = fileObject.getURL();
        this.isContentOpen = fileObject.isContentOpen();
        this.isExecutable = fileObject.isExecutable();
        this.isHidden = fileObject.isHidden();
        this.isReadable = fileObject.isReadable();
        this.isWritable = fileObject.isWriteable();
        this.lastModifiedTime = fileObject.getContent().getLastModifiedTime();
        if (this.isFile) {
            this.fileSize = fileObject.getContent().getSize();
        }
    }

    public String getPath() {
        return this.path;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public void setFileSize(long fileSize) {
        this.fileSize = fileSize;
    }

    public void setLastModifiedTime(long lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    public String getBaseName() {
        return this.fileName.getBaseName();
    }

    public FileName getFileName() {
        return this.fileName;
    }

    public String getPublicURIString() {
        return this.publicURIString;
    }

    public FileType getFileType() {
        return this.fileType;
    }

    public boolean isAttached() {
        return this.isAttached;
    }

    public URL getUrl() {
        return this.url;
    }

    public boolean isContentOpen() {
        return this.isContentOpen;
    }

    public boolean isExecutable() {
        return this.isExecutable;
    }

    public boolean isFile() {
        return this.isFile;
    }

    public boolean isFolder() {
        return this.isFolder;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public boolean isReadable() {
        return this.isReadable;
    }

    public boolean isWritable() {
        return this.isWritable;
    }

    public void setFileName(FileName fileName) {
        this.fileName = fileName;
    }

    public void setPublicURIString(String publicURIString) {
        this.publicURIString = publicURIString;
    }

    public void setFileType(FileType fileType) {
        this.fileType = fileType;
    }

    public void setAttached(boolean isAttached) {
        this.isAttached = isAttached;
    }

    public void setContentOpen(boolean isContentOpen) {
        this.isContentOpen = isContentOpen;
    }

    public void setExecutable(boolean executable) {
        this.isExecutable = executable;
    }

    public void setFile(boolean isFile) {
        this.isFile = isFile;
    }

    public void setFolder(boolean isFolder) {
        this.isFolder = isFolder;
    }

    public void setHidden(boolean isHidden) {
        this.isHidden = isHidden;
    }

    public void setReadable(boolean isReadable) {
        this.isReadable = isReadable;
    }

    public void setWritable(boolean isWritable) {
        this.isWritable = isWritable;
    }

    public void setUrl(URL url) {
        this.url = url;
    }
}

