/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.ftp.transport.server.util;

import io.ballerina.stdlib.ftp.exception.RemoteFileSystemConnectorException;
import io.ballerina.stdlib.ftp.util.ExcludeCoverageFromGeneratedReport;
import java.io.File;
import java.time.Duration;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.ftp.FtpFileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.sftp.IdentityInfo;
import org.apache.commons.vfs2.provider.sftp.SftpFileSystemConfigBuilder;

public final class FileTransportUtils {
    private static final Pattern URL_PATTERN = Pattern.compile("[a-z]+://.*");
    private static final Pattern PASSWORD_PATTERN = Pattern.compile(":(?:[^/]+)@");

    private FileTransportUtils() {
    }

    public static FileSystemOptions attachFileSystemOptions(Map<String, String> options) throws RemoteFileSystemConnectorException {
        if (options == null) {
            return null;
        }
        FileSystemOptions opts = new FileSystemOptions();
        String listeningDirURI = options.get("uri");
        if (listeningDirURI.toLowerCase(Locale.getDefault()).startsWith("ftp")) {
            FileTransportUtils.setFtpOptions(options, opts);
        } else if (listeningDirURI.toLowerCase(Locale.getDefault()).startsWith("sftp")) {
            FileTransportUtils.setSftpOptions(options, opts);
        }
        return opts;
    }

    private static void setFtpOptions(Map<String, String> options, FileSystemOptions opts) {
        FtpFileSystemConfigBuilder configBuilder = FtpFileSystemConfigBuilder.getInstance();
        if (options.get("PASSIVE_MODE") != null) {
            configBuilder.setPassiveMode(opts, Boolean.parseBoolean(options.get("PASSIVE_MODE")));
        }
        if (options.get("USER_DIR_IS_ROOT") != null) {
            configBuilder.setUserDirIsRoot(opts, Boolean.parseBoolean("USER_DIR_IS_ROOT"));
        }
    }

    private static void setSftpOptions(Map<String, String> options, FileSystemOptions opts) throws RemoteFileSystemConnectorException {
        SftpFileSystemConfigBuilder configBuilder = SftpFileSystemConfigBuilder.getInstance();
        String value = options.get("preferredMethods");
        configBuilder.setPreferredAuthentications(opts, value);
        if (options.get("USER_DIR_IS_ROOT") != null) {
            configBuilder.setUserDirIsRoot(opts, false);
        }
        if (options.get("IDENTITY") != null) {
            IdentityInfo identityInfo = options.containsKey("IDENTITY_PASS_PHRASE") ? new IdentityInfo(new File(options.get("IDENTITY")), options.get("IDENTITY_PASS_PHRASE").getBytes()) : new IdentityInfo(new File(options.get("IDENTITY")));
            configBuilder.setIdentityInfo(opts, new IdentityInfo[]{identityInfo});
        }
        if (options.get("AVOID_PERMISSION_CHECK") != null) {
            try {
                configBuilder.setStrictHostKeyChecking(opts, "no");
            }
            catch (FileSystemException e) {
                throw new RemoteFileSystemConnectorException(e.getMessage(), e);
            }
        }
        configBuilder.setConnectTimeout(opts, Duration.ofSeconds(10L));
    }

    @ExcludeCoverageFromGeneratedReport
    public static String maskUrlPassword(String url) {
        Matcher urlMatcher = URL_PATTERN.matcher(url);
        if (urlMatcher.find()) {
            Matcher pwdMatcher = PASSWORD_PATTERN.matcher(url);
            return pwdMatcher.replaceFirst("\":***@\"");
        }
        return url;
    }
}

