/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.test.runtime;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.ballerinalang.test.runtime.BTestMain;

public class CustomSystemClassLoader
extends ClassLoader {
    private final HashMap<String, byte[]> modifiedClassDefs;
    private final List<String> excludedClasses = new ArrayList<String>();

    public CustomSystemClassLoader() {
        super(CustomSystemClassLoader.getSystemClassLoader());
        this.modifiedClassDefs = new HashMap();
        this.populateExcludedClasses();
    }

    private void populateExcludedClasses() {
        try (InputStream is = BTestMain.class.getResourceAsStream("/excludedClasses.txt");){
            if (is == null) {
                throw new RuntimeException("Error reading excludedClasses.txt");
            }
            try (BufferedReader br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
                String line;
                while ((line = br.readLine()) != null) {
                    this.excludedClasses.add(line);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading excludedClasses.txt", e);
        }
    }

    public CustomSystemClassLoader(Map<String, byte[]> modifiedClassDefs) {
        super(CustomSystemClassLoader.getSystemClassLoader());
        this.modifiedClassDefs = new HashMap<String, byte[]>(modifiedClassDefs);
        this.populateExcludedClasses();
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        Class<?> loadedClass = this.findLoadedClass(name);
        if (loadedClass != null) {
            return loadedClass;
        }
        if (name.startsWith("java.") || name.startsWith("javax.") || !this.excludedClasses.contains(name)) {
            return super.loadClass(name);
        }
        return this.findClass(name);
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        byte[] classBytes = this.modifiedClassDefs.remove(name);
        if (classBytes != null) {
            return this.defineClass(name, classBytes, 0, classBytes.length);
        }
        try {
            classBytes = this.getClassBytes(name);
            return this.defineClass(name, classBytes, 0, classBytes.length);
        }
        catch (IOException e) {
            return super.findClass(name);
        }
    }

    private byte[] getClassBytes(String classFileName) throws IOException {
        byte[] buff;
        String path = File.separator + classFileName.replace('.', File.separatorChar) + ".class";
        try (InputStream is = BTestMain.class.getResourceAsStream(path);){
            int size = Objects.requireNonNull(is).available();
            buff = new byte[size];
            try (DataInputStream dis = new DataInputStream(is);){
                dis.readFully(buff);
            }
        }
        return buff;
    }
}

