/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.test.runtime.entity;

import java.lang.reflect.Method;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class MockFunctionReplaceVisitor
extends ClassVisitor {
    private final String methodName;
    private final String methodDesc;
    private final Method mockFunc;

    public MockFunctionReplaceVisitor(int api, ClassWriter cw, String name, String methodDescriptor, Method mockFunc) {
        super(api, (ClassVisitor)cw);
        this.methodName = name;
        this.methodDesc = methodDescriptor;
        this.mockFunc = mockFunc;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor methodVisitor;
        if (!name.equals(this.methodName) || !desc.equals(this.methodDesc)) {
            methodVisitor = super.visitMethod(access, name, desc, signature, exceptions);
        } else {
            methodVisitor = super.visitMethod(access, "$ORIG_" + name, desc, signature, exceptions);
            this.generateMethodWithMockFunctionCall(access, name, desc, signature, exceptions);
        }
        return methodVisitor;
    }

    private void generateMethodWithMockFunctionCall(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        mv.visitCode();
        Class<?>[] parameterTypes = this.mockFunc.getParameterTypes();
        int paramOffset = 0;
        for (Class<?> parameterType : parameterTypes) {
            this.generateLoadInstruction(mv, parameterType, paramOffset);
            if (parameterType == Long.TYPE || parameterType == Double.TYPE) {
                paramOffset += 2;
                continue;
            }
            ++paramOffset;
        }
        String mockFuncClassName = this.mockFunc.getDeclaringClass().getName().replace(".", "/");
        mv.visitMethodInsn(184, mockFuncClassName, this.mockFunc.getName(), Type.getMethodDescriptor((Method)this.mockFunc), false);
        this.generateReturnInstruction(mv, this.mockFunc.getReturnType());
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void generateLoadInstruction(MethodVisitor mv, Class<?> type, int index) {
        if (type.isPrimitive()) {
            if (type == Integer.TYPE || type == Boolean.TYPE) {
                mv.visitVarInsn(21, index);
            } else if (type == Long.TYPE) {
                mv.visitVarInsn(22, index);
            } else if (type == Float.TYPE) {
                mv.visitVarInsn(23, index);
            } else if (type == Double.TYPE) {
                mv.visitVarInsn(24, index);
            }
        } else {
            mv.visitVarInsn(25, index);
        }
    }

    private void generateReturnInstruction(MethodVisitor mv, Class<?> returnType) {
        if (returnType.isPrimitive()) {
            if (returnType == Integer.TYPE || returnType == Boolean.TYPE || returnType == Byte.TYPE) {
                mv.visitInsn(172);
            } else if (returnType == Long.TYPE) {
                mv.visitInsn(173);
            } else if (returnType == Float.TYPE) {
                mv.visitInsn(174);
            } else if (returnType == Double.TYPE) {
                mv.visitInsn(175);
            } else if (returnType == Void.TYPE) {
                mv.visitInsn(177);
            }
        } else {
            mv.visitInsn(176);
        }
    }
}

