/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.test.runtime.entity;

import io.ballerina.projects.Document;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class ModuleCoverage {
    private String name;
    private int coveredLines;
    private int missedLines;
    private float coveragePercentage;
    private final List<SourceFile> sourceFiles = new ArrayList<SourceFile>();

    public void addSourceFileCoverage(Document document, List<Integer> coveredLines, List<Integer> missedLines, List<Integer> emptyLines) {
        SourceFile sourceFile = new SourceFile(document, coveredLines, missedLines, emptyLines);
        this.sourceFiles.add(sourceFile);
        this.coveredLines += coveredLines.size();
        this.missedLines += missedLines.size();
        this.setCoveragePercentage();
    }

    public boolean containsSourceFile(String fileName) {
        boolean isAvailable = false;
        for (SourceFile sourceFile : this.sourceFiles) {
            if (!sourceFile.getName().equals(fileName)) continue;
            isAvailable = true;
            break;
        }
        return isAvailable;
    }

    public void updateCoverage(Document document, List<Integer> coveredLines, List<Integer> missedLines, List<Integer> emptyLines, int coveredMissedLineCount, int coveredEmptyLineCount, int missedEmptyLineCount) {
        ArrayList<SourceFile> sourceFileList = new ArrayList<SourceFile>(this.sourceFiles);
        for (SourceFile sourceFile : sourceFileList) {
            if (!sourceFile.getName().equals(document.name())) continue;
            this.sourceFiles.remove(sourceFile);
            SourceFile newSourceFile = new SourceFile(document, coveredLines, missedLines, emptyLines);
            this.sourceFiles.add(newSourceFile);
            this.coveredLines += coveredMissedLineCount;
            this.coveredLines += coveredEmptyLineCount;
            this.missedLines -= coveredMissedLineCount;
            this.missedLines += missedEmptyLineCount;
            this.setCoveragePercentage();
        }
    }

    public void replaceCoverage(Document document, List<Integer> coveredLines, List<Integer> missedLines, List<Integer> emptyLines) {
        ArrayList<SourceFile> sourceFileList = new ArrayList<SourceFile>(this.sourceFiles);
        for (SourceFile sourceFile : sourceFileList) {
            if (!sourceFile.getName().equals(document.name())) continue;
            int oldCoveredLines = sourceFile.coveredLines.size();
            int oldMissedLines = sourceFile.missedLines.size();
            this.sourceFiles.remove(sourceFile);
            SourceFile newSourceFile = new SourceFile(document, coveredLines, missedLines, emptyLines);
            this.sourceFiles.add(newSourceFile);
            this.coveredLines -= oldCoveredLines;
            this.missedLines -= oldMissedLines;
            this.coveredLines += coveredLines.size();
            this.missedLines += missedLines.size();
            this.setCoveragePercentage();
        }
    }

    private void setCoveragePercentage() {
        float coverageVal = (float)this.coveredLines / (float)(this.coveredLines + this.missedLines) * 100.0f;
        this.coveragePercentage = (float)((double)Math.round((double)coverageVal * 100.0) / 100.0);
    }

    public float getCoveragePercentage() {
        return this.coveragePercentage;
    }

    public int getCoveredLines() {
        return this.coveredLines;
    }

    public int getMissedLines() {
        return this.missedLines;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Optional<List<Integer>> getMissedLinesList(String sourceFileName) {
        for (SourceFile sourceFile : this.sourceFiles) {
            if (!sourceFile.getName().equals(sourceFileName)) continue;
            return Optional.of(sourceFile.missedLines);
        }
        return Optional.empty();
    }

    public Optional<List<Integer>> getCoveredLinesList(String sourceFileName) {
        for (SourceFile sourceFile : this.sourceFiles) {
            if (!sourceFile.getName().equals(sourceFileName)) continue;
            return Optional.of(sourceFile.coveredLines);
        }
        return Optional.empty();
    }

    public Optional<List<Integer>> getEmptyLinesList(String sourceFileName) {
        for (SourceFile sourceFile : this.sourceFiles) {
            if (!sourceFile.getName().equals(sourceFileName)) continue;
            return Optional.of(sourceFile.emptyLines);
        }
        return Optional.empty();
    }

    private static class SourceFile {
        private final String name;
        private final List<Integer> coveredLines;
        private final List<Integer> missedLines;
        private List<Integer> emptyLines;
        private float coveragePercentage;
        private String sourceCode;

        private SourceFile(Document document, List<Integer> coveredLines, List<Integer> missedLines) {
            this.name = document.name();
            this.coveredLines = coveredLines;
            this.missedLines = missedLines;
            this.setCoveragePercentage(coveredLines, missedLines);
            this.setSourceCode(document);
        }

        private SourceFile(Document document, List<Integer> coveredLines, List<Integer> missedLines, List<Integer> emptyLines) {
            this.name = document.name();
            this.coveredLines = coveredLines;
            this.missedLines = missedLines;
            this.emptyLines = emptyLines;
            this.setCoveragePercentage(coveredLines, missedLines);
            this.setSourceCode(document);
        }

        private void setCoveragePercentage(List<Integer> coveredLines, List<Integer> missedLines) {
            float coverageVal = (float)coveredLines.size() / (float)(coveredLines.size() + missedLines.size()) * 100.0f;
            this.coveragePercentage = (float)((double)Math.round((double)coverageVal * 100.0) / 100.0);
        }

        private void setSourceCode(Document document) {
            this.sourceCode = document.textDocument().toString();
        }

        public float getCoveragePercentage() {
            return this.coveragePercentage;
        }

        public String getSourceCode() {
            return this.sourceCode;
        }

        public List<Integer> getCoveredLines() {
            return this.coveredLines;
        }

        public List<Integer> getMissedLines() {
            return this.missedLines;
        }

        public String getName() {
            return this.name;
        }
    }
}

