/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.test.runtime.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.List;
import org.jacoco.core.instr.Instrumenter;
import org.jacoco.core.runtime.IExecutionDataAccessorGenerator;
import org.jacoco.core.runtime.OfflineInstrumentationAccessGenerator;

public final class JacocoInstrumentUtils {
    private static final Instrumenter instrumenter = new Instrumenter((IExecutionDataAccessorGenerator)new OfflineInstrumentationAccessGenerator());

    private JacocoInstrumentUtils() {
    }

    public static void instrumentOffline(List<URL> projectModuleJarList, Path destDir, List<String> mockClassNames) throws IOException, ClassNotFoundException {
        try (URLClassLoader classLoader = new URLClassLoader(projectModuleJarList.toArray(new URL[0]));){
            for (String className : mockClassNames) {
                Class<?> clazz = classLoader.loadClass(className);
                File file = new File(destDir.toString(), className.replace(".", "/") + ".class");
                file.getParentFile().mkdirs();
                InputStream input = clazz.getResourceAsStream(clazz.getSimpleName() + ".class");
                try (FileOutputStream output = new FileOutputStream(file);){
                    instrumenter.instrumentAll(input, (OutputStream)output, className);
                }
                finally {
                    if (input == null) continue;
                    input.close();
                }
            }
        }
    }
}

