/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.protoc.builder.syntaxtree;

import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.FieldAccessExpressionNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.StreamTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.protoc.MethodDescriptor;
import io.ballerina.protoc.builder.BallerinaFileBuilder;
import io.ballerina.protoc.builder.stub.EnumMessage;
import io.ballerina.protoc.builder.stub.Message;
import io.ballerina.protoc.builder.stub.Method;
import io.ballerina.protoc.builder.stub.ServiceStub;
import io.ballerina.protoc.builder.stub.StubFile;
import io.ballerina.protoc.builder.syntaxtree.components.Annotation;
import io.ballerina.protoc.builder.syntaxtree.components.Class;
import io.ballerina.protoc.builder.syntaxtree.components.Constant;
import io.ballerina.protoc.builder.syntaxtree.components.Expression;
import io.ballerina.protoc.builder.syntaxtree.components.Function;
import io.ballerina.protoc.builder.syntaxtree.components.Imports;
import io.ballerina.protoc.builder.syntaxtree.components.Listener;
import io.ballerina.protoc.builder.syntaxtree.components.Literal;
import io.ballerina.protoc.builder.syntaxtree.components.Map;
import io.ballerina.protoc.builder.syntaxtree.components.Service;
import io.ballerina.protoc.builder.syntaxtree.components.Statement;
import io.ballerina.protoc.builder.syntaxtree.components.Type;
import io.ballerina.protoc.builder.syntaxtree.components.TypeDescriptor;
import io.ballerina.protoc.builder.syntaxtree.constants.SyntaxTreeConstants;
import io.ballerina.protoc.builder.syntaxtree.utils.CallerUtils;
import io.ballerina.protoc.builder.syntaxtree.utils.ClientUtils;
import io.ballerina.protoc.builder.syntaxtree.utils.CommonUtils;
import io.ballerina.protoc.builder.syntaxtree.utils.EnumUtils;
import io.ballerina.protoc.builder.syntaxtree.utils.MessageUtils;
import io.ballerina.protoc.builder.syntaxtree.utils.ServerUtils;
import io.ballerina.protoc.builder.syntaxtree.utils.UnaryUtils;
import io.ballerina.protoc.builder.syntaxtree.utils.ValueTypeUtils;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextDocuments;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class SyntaxTreeGenerator {
    private SyntaxTreeGenerator() {
    }

    public static SyntaxTree generateSyntaxTree(StubFile stubFile, boolean isRoot, String mode, List<String> fileImports) {
        TreeSet<String> ballerinaImports = new TreeSet<String>();
        TreeSet<String> protobufImports = new TreeSet<String>();
        TreeSet<String> grpcStreamImports = new TreeSet<String>();
        NodeList moduleMembers = AbstractNodeFactory.createEmptyNodeList();
        NodeList<ImportDeclarationNode> imports = NodeFactory.createEmptyNodeList();
        if (stubFile.getStubList().size() > 0) {
            ballerinaImports.add("grpc");
        }
        String descriptorName = SyntaxTreeGenerator.generateDescriptorName(stubFile.getFileName().toUpperCase());
        Constant descriptor = new Constant("public ", "string", descriptorName, (ExpressionNode)Literal.getStringLiteralNode(stubFile.getRootDescriptor() == null ? "" : stubFile.getRootDescriptor()));
        moduleMembers = moduleMembers.add((Node)descriptor.getConstantDeclarationNode());
        if (isRoot && fileImports.size() > 0) {
            Constant descriptorMap = new Constant("public ", (TypeDescriptorNode)TypeDescriptor.getMapTypeDescriptorNode(SyntaxTreeConstants.SYNTAX_TREE_VAR_STRING), stubFile.getFileName().toUpperCase() + "_DESCRIPTOR_MAP", (ExpressionNode)SyntaxTreeGenerator.generateDescMap(fileImports).getMappingConstructorExpressionNode());
            moduleMembers = moduleMembers.add((Node)descriptorMap.getConstantDeclarationNode());
        }
        if (stubFile.getMessageMap().size() > 0) {
            ballerinaImports.add("protobuf");
        }
        CommonUtils.addImports(stubFile, ballerinaImports, protobufImports);
        LinkedHashMap<String, Class> clientStreamingClasses = new LinkedHashMap<String, Class>();
        LinkedHashMap<String, Class> serverStreamingClasses = new LinkedHashMap<String, Class>();
        LinkedHashMap<String, Class> bidirectionalStreamingClasses = new LinkedHashMap<String, Class>();
        LinkedHashMap<String, Class> callerClasses = new LinkedHashMap<String, Class>();
        LinkedHashMap<String, Type> valueTypes = new LinkedHashMap<String, Type>();
        LinkedHashMap<String, Type> valueTypeStreams = new LinkedHashMap<String, Type>();
        for (ServiceStub serviceStub : stubFile.getStubList()) {
            Class client = new Class(serviceStub.getServiceName() + "Client", true);
            client.addQualifiers(new String[]{"isolated", "client"});
            client.addMember((Node)TypeDescriptor.getTypeReferenceNode((Node)TypeDescriptor.getQualifiedNameReferenceNode("grpc", "AbstractClientEndpoint")));
            client.addMember((Node)TypeDescriptor.getObjectFieldNode("private", new String[]{"final"}, (Node)TypeDescriptor.getQualifiedNameReferenceNode("grpc", "Client"), "grpcClient"));
            client.addMember((Node)SyntaxTreeGenerator.getInitFunction(stubFile.getFileName(), fileImports.size() > 0).getFunctionDefinitionNode());
            for (Method method : serviceStub.getUnaryFunctions()) {
                client.addMember((Node)UnaryUtils.getUnaryFunction(method, stubFile.getFileName()).getFunctionDefinitionNode());
                client.addMember((Node)UnaryUtils.getUnaryContextFunction(method, stubFile.getFileName()).getFunctionDefinitionNode());
            }
            for (Method method : serviceStub.getClientStreamingFunctions()) {
                client.addMember((Node)ClientUtils.getStreamingClientFunction(method).getFunctionDefinitionNode());
                clientStreamingClasses.put(method.getMethodName(), ClientUtils.getStreamingClientClass(method, stubFile.getFileName()));
            }
            for (Method method : serviceStub.getServerStreamingFunctions()) {
                client.addMember((Node)ServerUtils.getServerStreamingFunction(method, stubFile.getFileName()).getFunctionDefinitionNode());
                client.addMember((Node)ServerUtils.getServerStreamingContextFunction(method, stubFile.getFileName()).getFunctionDefinitionNode());
                if (!CommonUtils.isBallerinaProtobufType(method.getOutputType())) {
                    if (BallerinaFileBuilder.streamClassMap.containsKey(method.getOutputType())) continue;
                    Class serverStreamClass = ServerUtils.getServerStreamClass(method, stubFile.getFileName());
                    serverStreamingClasses.put(method.getOutputType(), serverStreamClass);
                    BallerinaFileBuilder.streamClassMap.put(method.getOutputType(), serverStreamClass);
                    continue;
                }
                grpcStreamImports.add(CommonUtils.getProtobufType(method.getOutputType()));
            }
            for (Method method : serviceStub.getBidiStreamingFunctions()) {
                client.addMember((Node)ClientUtils.getStreamingClientFunction(method).getFunctionDefinitionNode());
                bidirectionalStreamingClasses.put(method.getMethodName(), ClientUtils.getStreamingClientClass(method, stubFile.getFileName()));
            }
            moduleMembers = moduleMembers.add((Node)client.getClassDefinitionNode());
            if (!"client".equals(mode)) {
                for (Map.Entry entry : serviceStub.getCallerMap().entrySet()) {
                    callerClasses.put((String)entry.getKey(), CallerUtils.getCallerClass((String)entry.getKey(), (String)entry.getValue(), stubFile.getFileName()));
                }
            }
            for (Map.Entry entry : serviceStub.getValueTypeMap().entrySet()) {
                if (!CommonUtils.isBallerinaProtobufType((String)entry.getKey())) {
                    if (!BallerinaFileBuilder.dependentValueTypeMap.contains(entry.getKey())) {
                        valueTypes.put((String)entry.getKey(), ValueTypeUtils.getValueType((String)entry.getKey(), stubFile.getFileName()));
                        BallerinaFileBuilder.dependentValueTypeMap.add((String)entry.getKey());
                    }
                    if (!((Boolean)entry.getValue()).booleanValue() || BallerinaFileBuilder.dependentValueTypeMap.contains((String)entry.getKey() + "Stream")) continue;
                    valueTypeStreams.put((String)entry.getKey(), ValueTypeUtils.getValueTypeStream((String)entry.getKey(), stubFile.getFileName()));
                    BallerinaFileBuilder.dependentValueTypeMap.add((String)entry.getKey() + "Stream");
                    continue;
                }
                protobufImports.add(CommonUtils.getProtobufType((String)entry.getKey()));
            }
        }
        imports = SyntaxTreeGenerator.addBallerinaImportNodes(imports, ballerinaImports);
        imports = SyntaxTreeGenerator.addProtobufImportNodes(imports, protobufImports);
        imports = SyntaxTreeGenerator.addGrpcStreamImportNodes(imports, grpcStreamImports);
        imports = SyntaxTreeGenerator.addSubModuleImportNodes(imports, stubFile);
        for (Map.Entry entry : clientStreamingClasses.entrySet()) {
            moduleMembers = moduleMembers.add((Node)((Class)entry.getValue()).getClassDefinitionNode());
        }
        for (Map.Entry entry : serverStreamingClasses.entrySet()) {
            moduleMembers = moduleMembers.add((Node)((Class)entry.getValue()).getClassDefinitionNode());
        }
        for (Map.Entry entry : bidirectionalStreamingClasses.entrySet()) {
            moduleMembers = moduleMembers.add((Node)((Class)entry.getValue()).getClassDefinitionNode());
        }
        for (Map.Entry entry : callerClasses.entrySet()) {
            moduleMembers = moduleMembers.add((Node)((Class)entry.getValue()).getClassDefinitionNode());
        }
        for (Map.Entry entry : valueTypeStreams.entrySet()) {
            moduleMembers = moduleMembers.add((Node)((Type)entry.getValue()).getTypeDefinitionNode(null));
        }
        for (Map.Entry entry : valueTypes.entrySet()) {
            moduleMembers = moduleMembers.add((Node)((Type)entry.getValue()).getTypeDefinitionNode(null));
        }
        for (Map.Entry entry : stubFile.getMessageMap().entrySet()) {
            for (ModuleMemberDeclarationNode messageNode : MessageUtils.getMessageNodes((Message)entry.getValue(), descriptorName, stubFile.getFileName())) {
                moduleMembers = moduleMembers.add((Node)messageNode);
            }
        }
        for (EnumMessage enumMessage : stubFile.getEnumList()) {
            moduleMembers = moduleMembers.add((Node)EnumUtils.getEnum(enumMessage).getEnumDeclarationNode());
        }
        IdentifierToken eofToken = AbstractNodeFactory.createIdentifierToken((String)"");
        ModulePartNode modulePartNode = NodeFactory.createModulePartNode(imports, (NodeList)moduleMembers, (Token)eofToken);
        TextDocument textDocument = TextDocuments.from((String)"");
        SyntaxTree syntaxTree = SyntaxTree.from((TextDocument)textDocument);
        return syntaxTree.modifyWith((Node)modulePartNode);
    }

    private static String generateDescriptorName(String stubFilename) {
        if (!Character.isAlphabetic(stubFilename.charAt(0))) {
            return SyntaxTreeGenerator.generateDescriptorName(stubFilename.substring(1));
        }
        return stubFilename.toUpperCase() + "_DESC";
    }

    private static Map generateDescMap(List<String> importList) {
        Map descMap = new Map();
        for (String filename : importList) {
            Object importDescName = SyntaxTreeGenerator.generateDescriptorName(filename.split("\\.")[0].replace("/", "_"));
            String protoFileName = filename.substring(0, filename.lastIndexOf("."));
            if (BallerinaFileBuilder.protofileModuleMap.containsKey(protoFileName)) {
                String subModuleName = BallerinaFileBuilder.protofileModuleMap.get(protoFileName);
                importDescName = subModuleName.substring(subModuleName.lastIndexOf(".") + 1) + ":" + (String)importDescName;
            }
            descMap.addField("\"" + filename + "\"", (ExpressionNode)TypeDescriptor.getSimpleNameReferenceNode((String)importDescName));
        }
        return descMap;
    }

    public static SyntaxTree generateSyntaxTreeForServiceSample(ServiceStub serviceStub, boolean addListener, String fileName, List<String> fileImports) {
        NodeList moduleMembers = AbstractNodeFactory.createEmptyNodeList();
        NodeList<ImportDeclarationNode> imports = NodeFactory.createEmptyNodeList();
        ImportDeclarationNode importForGrpc = Imports.getImportDeclarationNode("ballerina", "grpc");
        imports = imports.add((Node)importForGrpc);
        ArrayList<Method> methodList = new ArrayList<Method>();
        methodList.addAll(serviceStub.getUnaryFunctions());
        methodList.addAll(serviceStub.getClientStreamingFunctions());
        methodList.addAll(serviceStub.getServerStreamingFunctions());
        methodList.addAll(serviceStub.getBidiStreamingFunctions());
        imports = CommonUtils.addAnyImportIfExists(methodList, imports);
        imports = CommonUtils.addTimeImportsIfExists(methodList, imports);
        imports = CommonUtils.addSubModuleImports(methodList, fileName, imports);
        if (addListener) {
            Listener listener = new Listener("ep", (TypeDescriptorNode)TypeDescriptor.getQualifiedNameReferenceNode("grpc", "Listener"), Expression.getImplicitNewExpressionNode("9090"), false);
            moduleMembers = moduleMembers.add((Node)listener.getListenerDeclarationNode());
        }
        Service service = new Service(new String[]{"\"" + serviceStub.getServiceName() + "\""}, new String[]{"ep"});
        Annotation grpcServiceDescriptor = new Annotation("grpc", "Descriptor");
        grpcServiceDescriptor.addField("value", SyntaxTreeGenerator.generateDescriptorName(fileName));
        if (fileImports.size() > 0) {
            grpcServiceDescriptor.addField("descMap", fileName.toUpperCase() + "_DESCRIPTOR_MAP");
        }
        service.addAnnotation(grpcServiceDescriptor.getAnnotationNode());
        for (Method method : methodList) {
            Function function = new Function(method.getMethodName());
            function.addQualifiers(new String[]{"remote"});
            String input = method.getInputType();
            String output = method.getOutputType();
            if (method.getInputType() != null) {
                String inputName;
                StreamTypeDescriptorNode inputParam;
                if (method.getMethodType().equals((Object)MethodDescriptor.MethodType.CLIENT_STREAMING) || method.getMethodType().equals((Object)MethodDescriptor.MethodType.BIDI_STREAMING)) {
                    inputParam = TypeDescriptor.getStreamTypeDescriptorNode((Node)TypeDescriptor.getSimpleNameReferenceNode(method.getInputPackagePrefix(fileName) + input), (Node)SyntaxTreeConstants.SYNTAX_TREE_GRPC_ERROR_OPTIONAL);
                    inputName = "clientStream";
                } else {
                    inputParam = TypeDescriptor.getSimpleNameReferenceNode(method.getInputPackagePrefix(fileName) + input);
                    inputName = "value";
                }
                function.addRequiredParameter((Node)inputParam, inputName);
            }
            if (method.getOutputType() != null) {
                Object outputParam = method.getMethodType().equals((Object)MethodDescriptor.MethodType.SERVER_STREAMING) || method.getMethodType().equals((Object)MethodDescriptor.MethodType.BIDI_STREAMING) ? TypeDescriptor.getStreamTypeDescriptorNode((Node)TypeDescriptor.getSimpleNameReferenceNode(method.getOutputPackageType(fileName) + output), (Node)TypeDescriptor.getOptionalTypeDescriptorNode("", "error")) : TypeDescriptor.getSimpleNameReferenceNode(method.getOutputPackageType(fileName) + output);
                function.addReturns((TypeDescriptorNode)TypeDescriptor.getUnionTypeDescriptorNode((TypeDescriptorNode)outputParam, (TypeDescriptorNode)TypeDescriptor.getErrorTypeDescriptorNode()));
            } else {
                function.addReturns((TypeDescriptorNode)TypeDescriptor.getOptionalTypeDescriptorNode("", "error"));
            }
            service.addMember((Node)function.getFunctionDefinitionNode());
        }
        moduleMembers = moduleMembers.add((Node)service.getServiceDeclarationNode());
        IdentifierToken eofToken = AbstractNodeFactory.createIdentifierToken((String)"");
        ModulePartNode modulePartNode = NodeFactory.createModulePartNode(imports, (NodeList)moduleMembers, (Token)eofToken);
        TextDocument textDocument = TextDocuments.from((String)"");
        SyntaxTree syntaxTree = SyntaxTree.from((TextDocument)textDocument);
        return syntaxTree.modifyWith((Node)modulePartNode);
    }

    public static Function getInitFunction(String fileName, boolean addDescMap) {
        String[] stringArray;
        Function function = new Function("init");
        function.addRequiredParameter((Node)SyntaxTreeConstants.SYNTAX_TREE_VAR_STRING, "url");
        function.addIncludedRecordParameter((Node)TypeDescriptor.getQualifiedNameReferenceNode("grpc", "ClientConfiguration"), "config");
        function.addReturns((TypeDescriptorNode)SyntaxTreeConstants.SYNTAX_TREE_GRPC_ERROR_OPTIONAL);
        function.addAssignmentStatement((Node)Expression.getFieldAccessExpressionNode("self", "grpcClient"), (ExpressionNode)Expression.getCheckExpressionNode((ExpressionNode)Expression.getImplicitNewExpressionNode("url", "config")));
        FieldAccessExpressionNode fieldAccessExpressionNode = Expression.getFieldAccessExpressionNode("self", "grpcClient");
        if (addDescMap) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = "self";
            stringArray2[1] = SyntaxTreeGenerator.generateDescriptorName(fileName);
            stringArray = stringArray2;
            stringArray2[2] = fileName.toUpperCase() + "_DESCRIPTOR_MAP";
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = "self";
            stringArray = stringArray3;
            stringArray3[1] = SyntaxTreeGenerator.generateDescriptorName(fileName);
        }
        function.addExpressionStatement(Statement.getCallStatementNode((ExpressionNode)Expression.getCheckExpressionNode((ExpressionNode)Expression.getMethodCallExpressionNode((ExpressionNode)fieldAccessExpressionNode, "initStub", stringArray))));
        function.addQualifiers(new String[]{"public", "isolated"});
        return function;
    }

    private static NodeList<ImportDeclarationNode> addBallerinaImportNodes(NodeList<ImportDeclarationNode> imports, Set<String> ballerinaImports) {
        for (String ballerinaImport : ballerinaImports) {
            imports = imports.add((Node)Imports.getImportDeclarationNode("ballerina", ballerinaImport));
        }
        return imports;
    }

    private static NodeList<ImportDeclarationNode> addSubModuleImportNodes(NodeList<ImportDeclarationNode> imports, StubFile stubFile) {
        for (String moduleImport : stubFile.getImportList()) {
            String importString;
            if (!BallerinaFileBuilder.protofileModuleMap.containsKey(moduleImport = moduleImport.substring(0, moduleImport.lastIndexOf(".proto"))) || (importString = BallerinaFileBuilder.protofileModuleMap.get(moduleImport)).isEmpty() || BallerinaFileBuilder.protofileModuleMap.get(stubFile.getFileName()).equals(importString)) continue;
            imports = imports.add((Node)Imports.getImportDeclarationNode(importString));
        }
        return imports;
    }

    private static NodeList<ImportDeclarationNode> addProtobufImportNodes(NodeList<ImportDeclarationNode> imports, Set<String> protobufImports) {
        for (String protobufImport : protobufImports) {
            imports = imports.add((Node)Imports.getImportDeclarationNode("ballerina", "protobuf", new String[]{"types", protobufImport}, ""));
        }
        return imports;
    }

    private static NodeList<ImportDeclarationNode> addGrpcStreamImportNodes(NodeList<ImportDeclarationNode> imports, Set<String> grpcStreamImports) {
        Iterator<String> iterator = grpcStreamImports.iterator();
        while (iterator.hasNext()) {
            String sImport;
            String prefix = sImport = iterator.next();
            if (sImport.equals("'any")) {
                prefix = "any";
            }
            imports = imports.add((Node)Imports.getImportDeclarationNode("ballerina", "grpc", new String[]{"types", sImport}, "s" + prefix));
        }
        return imports;
    }
}

