/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.protoc.builder.syntaxtree.components;

import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.protoc.builder.syntaxtree.components.Expression;
import io.ballerina.protoc.builder.syntaxtree.components.Literal;
import io.ballerina.protoc.builder.syntaxtree.components.TypeDescriptor;
import io.ballerina.protoc.builder.syntaxtree.constants.SyntaxTreeConstants;
import java.util.ArrayList;
import java.util.List;

public class Map {
    private final List<Node> fields = new ArrayList<Node>();

    public MappingConstructorExpressionNode getMappingConstructorExpressionNode() {
        return NodeFactory.createMappingConstructorExpressionNode((Token)SyntaxTreeConstants.SYNTAX_TREE_OPEN_BRACE, (SeparatedNodeList)NodeFactory.createSeparatedNodeList(this.fields), (Token)SyntaxTreeConstants.SYNTAX_TREE_CLOSE_BRACE);
    }

    public void addField(String fieldName, ExpressionNode field) {
        if (this.fields.size() > 0) {
            this.fields.add((Node)SyntaxTreeConstants.SYNTAX_TREE_COMMA);
        }
        this.fields.add((Node)NodeFactory.createSpecificFieldNode(null, (Node)NodeFactory.createIdentifierToken((String)fieldName), (Token)SyntaxTreeConstants.SYNTAX_TREE_COLON, (ExpressionNode)field));
    }

    public void addStringField(String key, String value) {
        if (this.fields.size() > 0) {
            this.fields.add((Node)SyntaxTreeConstants.SYNTAX_TREE_COMMA);
        }
        this.fields.add((Node)NodeFactory.createSpecificFieldNode(null, (Node)Literal.getStringLiteralNode(key), (Token)SyntaxTreeConstants.SYNTAX_TREE_COLON, (ExpressionNode)Literal.getStringLiteralNode(value)));
    }

    public void addMethodCallField(String key, ExpressionNode expression, String methodName, String ... args) {
        if (this.fields.size() > 0) {
            this.fields.add((Node)SyntaxTreeConstants.SYNTAX_TREE_COMMA);
        }
        this.fields.add((Node)NodeFactory.createSpecificFieldNode(null, (Node)NodeFactory.createIdentifierToken((String)key), (Token)SyntaxTreeConstants.SYNTAX_TREE_COLON, (ExpressionNode)Expression.getMethodCallExpressionNode(expression, methodName, args)));
    }

    public void addSimpleNameReferenceField(String key, String value) {
        if (this.fields.size() > 0) {
            this.fields.add((Node)SyntaxTreeConstants.SYNTAX_TREE_COMMA);
        }
        this.fields.add((Node)NodeFactory.createSpecificFieldNode(null, (Node)NodeFactory.createIdentifierToken((String)key), (Token)SyntaxTreeConstants.SYNTAX_TREE_COLON, (ExpressionNode)TypeDescriptor.getSimpleNameReferenceNode(value)));
    }

    public void addTypeCastExpressionField(String fieldName, String typeCastParam, ExpressionNode expression) {
        if (this.fields.size() > 0) {
            this.fields.add((Node)SyntaxTreeConstants.SYNTAX_TREE_COMMA);
        }
        this.fields.add((Node)NodeFactory.createSpecificFieldNode(null, (Node)NodeFactory.createIdentifierToken((String)fieldName), (Token)SyntaxTreeConstants.SYNTAX_TREE_COLON, (ExpressionNode)TypeDescriptor.getTypeCastExpressionNode(typeCastParam, expression)));
    }
}

