/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.protoc.builder.syntaxtree.utils;

import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.AnonymousFunctionExpressionNode;
import io.ballerina.compiler.syntax.tree.BindingPatternNode;
import io.ballerina.compiler.syntax.tree.CaptureBindingPatternNode;
import io.ballerina.compiler.syntax.tree.CheckExpressionNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.ExpressionStatementNode;
import io.ballerina.compiler.syntax.tree.FunctionBodyNode;
import io.ballerina.compiler.syntax.tree.FunctionSignatureNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MethodCallExpressionNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.NameReferenceNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.TypedBindingPatternNode;
import io.ballerina.compiler.syntax.tree.VariableDeclarationNode;
import io.ballerina.protoc.builder.BallerinaFileBuilder;
import io.ballerina.protoc.builder.stub.Field;
import io.ballerina.protoc.builder.stub.Message;
import io.ballerina.protoc.builder.stub.Method;
import io.ballerina.protoc.builder.stub.ServiceStub;
import io.ballerina.protoc.builder.syntaxtree.components.Expression;
import io.ballerina.protoc.builder.syntaxtree.components.Function;
import io.ballerina.protoc.builder.syntaxtree.components.Imports;
import io.ballerina.protoc.builder.syntaxtree.components.Literal;
import io.ballerina.protoc.builder.syntaxtree.components.ModuleVariable;
import io.ballerina.protoc.builder.syntaxtree.components.Statement;
import io.ballerina.protoc.builder.syntaxtree.components.TypeDescriptor;
import io.ballerina.protoc.builder.syntaxtree.components.VariableDeclaration;
import io.ballerina.protoc.builder.syntaxtree.constants.SyntaxTreeConstants;
import io.ballerina.protoc.builder.syntaxtree.utils.CommonUtils;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextDocuments;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ClientSampleSyntaxTreeUtils {
    private static final String CONST_ENDPOINT = "ep";
    private static boolean firstLine;
    private static final Map<String, ExpressionNode> INPUT_TYPE_EXPR_NODES;

    public static SyntaxTree generateSyntaxTreeForClientSample(ServiceStub serviceStub, String filename, Map<String, Message> msgMap) {
        NodeList moduleMembers = AbstractNodeFactory.createEmptyNodeList();
        NodeList<ImportDeclarationNode> imports = AbstractNodeFactory.createEmptyNodeList();
        Function main = new Function("main");
        main.addQualifiers(new String[]{"public"});
        main.addReturns((TypeDescriptorNode)SyntaxTreeConstants.SYNTAX_TREE_ERROR_OPTIONAL);
        ModuleVariable clientEp = new ModuleVariable(TypeDescriptor.getTypedBindingPatternNode((TypeDescriptorNode)TypeDescriptor.getSimpleNameReferenceNode(serviceStub.getServiceName() + "Client"), (BindingPatternNode)TypeDescriptor.getCaptureBindingPatternNode(CONST_ENDPOINT)), (ExpressionNode)Expression.getCheckExpressionNode((ExpressionNode)Expression.getImplicitNewExpressionNode("\"http://localhost:9090\"")));
        imports = ClientSampleSyntaxTreeUtils.addImports(imports, serviceStub, filename);
        firstLine = false;
        for (Method method : serviceStub.getUnaryFunctions()) {
            ClientSampleSyntaxTreeUtils.addUnaryCallMethodBody(main, method, filename, msgMap);
            firstLine = true;
        }
        for (Method method : serviceStub.getServerStreamingFunctions()) {
            ClientSampleSyntaxTreeUtils.addServerStreamingCallMethodBody(main, method, filename, msgMap);
            firstLine = true;
        }
        for (Method method : serviceStub.getClientStreamingFunctions()) {
            ClientSampleSyntaxTreeUtils.addClientBidiStreamingCallMethodBody(main, method, filename, msgMap);
            firstLine = true;
        }
        for (Method method : serviceStub.getBidiStreamingFunctions()) {
            ClientSampleSyntaxTreeUtils.addClientBidiStreamingCallMethodBody(main, method, filename, msgMap);
            firstLine = true;
        }
        moduleMembers = moduleMembers.add((Node)clientEp.getModuleVariableDeclarationNode());
        moduleMembers = moduleMembers.add((Node)main.getFunctionDefinitionNode());
        IdentifierToken eofToken = AbstractNodeFactory.createIdentifierToken((String)"");
        ModulePartNode modulePartNode = NodeFactory.createModulePartNode(imports, (NodeList)moduleMembers, (Token)eofToken);
        TextDocument textDocument = TextDocuments.from((String)"");
        SyntaxTree syntaxTree = SyntaxTree.from((TextDocument)textDocument);
        return syntaxTree.modifyWith((Node)modulePartNode);
    }

    private static void addUnaryCallMethodBody(Function main, Method method, String filename, Map<String, Message> msgMap) {
        if (method.getInputType() != null) {
            main.addVariableStatement(ClientSampleSyntaxTreeUtils.getInputDeclarationStatement(method, filename, msgMap));
        }
        if (method.getOutputType() != null) {
            main.addVariableStatement(ClientSampleSyntaxTreeUtils.getUnaryCallDeclarationNode(method, filename));
            main.addExpressionStatement(ClientSampleSyntaxTreeUtils.getPrintlnStatement(ClientSampleSyntaxTreeUtils.getResponseName(method.getMethodName())));
        } else {
            main.addExpressionStatement(ClientSampleSyntaxTreeUtils.getUnaryCallExpressionStatement(method));
        }
    }

    private static void addServerStreamingCallMethodBody(Function main, Method method, String filename, Map<String, Message> msgMap) {
        if (method.getInputType() != null) {
            main.addVariableStatement(ClientSampleSyntaxTreeUtils.getInputDeclarationStatement(method, filename, msgMap));
        }
        main.addVariableStatement(ClientSampleSyntaxTreeUtils.getServerStreamingCallDeclarationNode(method, filename));
        main.addExpressionStatement(ClientSampleSyntaxTreeUtils.getForEachExpressionNode(method, filename));
    }

    private static void addClientBidiStreamingCallMethodBody(Function main, Method method, String filename, Map<String, Message> msgMap) {
        if (method.getInputType() != null) {
            main.addVariableStatement(ClientSampleSyntaxTreeUtils.getInputDeclarationStatement(method, filename, msgMap));
        }
        main.addVariableStatement(ClientSampleSyntaxTreeUtils.getClientStreamingCallDeclarationNode(method));
        main.addExpressionStatement(ClientSampleSyntaxTreeUtils.getStreamSendValueStatementNode(method));
        main.addExpressionStatement(ClientSampleSyntaxTreeUtils.getStreamCompleteStatementNode(method));
        if (method.getOutputType() != null) {
            main.addVariableStatement(ClientSampleSyntaxTreeUtils.getStreamReceiveValueDeclarationNode(method, filename));
            main.addExpressionStatement(ClientSampleSyntaxTreeUtils.getPrintlnStatement(ClientSampleSyntaxTreeUtils.getResponseName(method.getMethodName())));
        } else {
            main.addExpressionStatement(ClientSampleSyntaxTreeUtils.getStreamReceiveValueExpressionStatement(method));
        }
    }

    private static ExpressionStatementNode getStreamReceiveValueExpressionStatement(Method method) {
        CheckExpressionNode checkExpressionNode = Expression.getCheckExpressionNode((ExpressionNode)Expression.getRemoteMethodCallActionNode((ExpressionNode)TypeDescriptor.getSimpleNameReferenceNode(ClientSampleSyntaxTreeUtils.getStreamingClientName(method.getMethodName())), "receive" + CommonUtils.getMethodType(method.getOutputType()), new String[0]));
        return Statement.getCallStatementNode((ExpressionNode)checkExpressionNode);
    }

    private static VariableDeclarationNode getUnaryCallDeclarationNode(Method method, String filename) {
        TypedBindingPatternNode bindingPatternNode = TypeDescriptor.getTypedBindingPatternNode((TypeDescriptorNode)TypeDescriptor.getBuiltinSimpleNameReferenceNode(ClientSampleSyntaxTreeUtils.getNameWithNewLine(method.getOutputPackageType(filename) + method.getOutputType() + " ")), (BindingPatternNode)TypeDescriptor.getCaptureBindingPatternNode(ClientSampleSyntaxTreeUtils.getResponseName(method.getMethodName())));
        CheckExpressionNode node = Expression.getCheckExpressionNode((ExpressionNode)Expression.getRemoteMethodCallActionNode((ExpressionNode)TypeDescriptor.getBuiltinSimpleNameReferenceNode(CONST_ENDPOINT), method.getMethodName(), method.getInputType() != null ? ClientSampleSyntaxTreeUtils.getRequestName(method.getMethodName()) : ""));
        VariableDeclaration unaryCallVariable = new VariableDeclaration(bindingPatternNode, (ExpressionNode)node);
        return unaryCallVariable.getVariableDeclarationNode();
    }

    private static ExpressionStatementNode getUnaryCallExpressionStatement(Method method) {
        CheckExpressionNode node = Expression.getCheckExpressionNode((ExpressionNode)Expression.getRemoteMethodCallActionNode((ExpressionNode)TypeDescriptor.getBuiltinSimpleNameReferenceNode(ClientSampleSyntaxTreeUtils.getNameWithNewLine(CONST_ENDPOINT)), method.getMethodName(), method.getInputType() != null ? ClientSampleSyntaxTreeUtils.getRequestName(method.getMethodName()) : ""));
        return Statement.getCallStatementNode((ExpressionNode)node);
    }

    private static VariableDeclarationNode getClientStreamingCallDeclarationNode(Method method) {
        TypedBindingPatternNode bindingPatternNode = TypeDescriptor.getTypedBindingPatternNode((TypeDescriptorNode)TypeDescriptor.getBuiltinSimpleNameReferenceNode(ClientSampleSyntaxTreeUtils.getNameWithNewLine(CommonUtils.capitalize(method.getMethodName()) + "StreamingClient ")), (BindingPatternNode)TypeDescriptor.getCaptureBindingPatternNode(ClientSampleSyntaxTreeUtils.getStreamingClientName(method.getMethodName())));
        CheckExpressionNode node = Expression.getCheckExpressionNode((ExpressionNode)Expression.getRemoteMethodCallActionNode((ExpressionNode)TypeDescriptor.getBuiltinSimpleNameReferenceNode(CONST_ENDPOINT), method.getMethodName(), new String[0]));
        VariableDeclaration streamingCallVariable = new VariableDeclaration(bindingPatternNode, (ExpressionNode)node);
        return streamingCallVariable.getVariableDeclarationNode();
    }

    private static ExpressionStatementNode getForEachExpressionNode(Method method, String filename) {
        AnonymousFunctionExpressionNode functionExpressionNode = ClientSampleSyntaxTreeUtils.getAnonymousFunctionExpressionNode(method, filename);
        MethodCallExpressionNode methodCallExpressionNode = ClientSampleSyntaxTreeUtils.getForEachMethodCall(method, functionExpressionNode);
        return Statement.getCallStatementNode((ExpressionNode)Expression.getCheckExpressionNode((ExpressionNode)methodCallExpressionNode));
    }

    private static AnonymousFunctionExpressionNode getAnonymousFunctionExpressionNode(Method method, String filename) {
        Function function = new Function();
        function.addRequiredParameter((Node)TypeDescriptor.getSimpleNameReferenceNode(method.getOutputPackageType(filename) + method.getOutputType() + " "), "value");
        function.addExpressionStatement(ClientSampleSyntaxTreeUtils.getPrintlnStatement("value"));
        return NodeFactory.createExplicitAnonymousFunctionExpressionNode((NodeList)AbstractNodeFactory.createEmptyNodeList(), (NodeList)AbstractNodeFactory.createEmptyNodeList(), (Token)SyntaxTreeConstants.SYNTAX_TREE_KEYWORD_FUNCTION, (FunctionSignatureNode)function.getFunctionSignature(), (FunctionBodyNode)function.getFunctionBody());
    }

    private static MethodCallExpressionNode getForEachMethodCall(Method method, AnonymousFunctionExpressionNode expressionNode) {
        return NodeFactory.createMethodCallExpressionNode((ExpressionNode)TypeDescriptor.getSimpleNameReferenceNode(ClientSampleSyntaxTreeUtils.getResponseName(method.getMethodName())), (Token)SyntaxTreeConstants.SYNTAX_TREE_DOT, (NameReferenceNode)TypeDescriptor.getSimpleNameReferenceNode("forEach"), (Token)SyntaxTreeConstants.SYNTAX_TREE_OPEN_PAREN, (SeparatedNodeList)AbstractNodeFactory.createSeparatedNodeList((Node[])new Node[]{NodeFactory.createPositionalArgumentNode((ExpressionNode)expressionNode)}), (Token)SyntaxTreeConstants.SYNTAX_TREE_CLOSE_PAREN);
    }

    private static VariableDeclarationNode getServerStreamingCallDeclarationNode(Method method, String filename) {
        TypedBindingPatternNode bindingPatternNode = TypeDescriptor.getTypedBindingPatternNode((TypeDescriptorNode)TypeDescriptor.getStreamTypeDescriptorNode((Node)TypeDescriptor.getSimpleNameReferenceNode(ClientSampleSyntaxTreeUtils.getNameWithNewLine(method.getOutputPackageType(filename) + method.getOutputType())), (Node)SyntaxTreeConstants.SYNTAX_TREE_ERROR_OPTIONAL), (BindingPatternNode)TypeDescriptor.getCaptureBindingPatternNode(ClientSampleSyntaxTreeUtils.getResponseName(method.getMethodName())));
        CheckExpressionNode node = Expression.getCheckExpressionNode((ExpressionNode)Expression.getRemoteMethodCallActionNode((ExpressionNode)TypeDescriptor.getBuiltinSimpleNameReferenceNode(CONST_ENDPOINT), method.getMethodName(), method.getInputType() != null ? ClientSampleSyntaxTreeUtils.getRequestName(method.getMethodName()) : ""));
        VariableDeclaration streamingCallVariable = new VariableDeclaration(bindingPatternNode, (ExpressionNode)node);
        return streamingCallVariable.getVariableDeclarationNode();
    }

    private static ExpressionStatementNode getStreamSendValueStatementNode(Method method) {
        CheckExpressionNode node = Expression.getCheckExpressionNode((ExpressionNode)Expression.getRemoteMethodCallActionNode((ExpressionNode)TypeDescriptor.getBuiltinSimpleNameReferenceNode(ClientSampleSyntaxTreeUtils.getStreamingClientName(method.getMethodName())), "send" + CommonUtils.getMethodType(method.getInputType()), method.getInputType() != null ? ClientSampleSyntaxTreeUtils.getRequestName(method.getMethodName()) : ""));
        return Statement.getCallStatementNode((ExpressionNode)node);
    }

    private static ExpressionStatementNode getStreamCompleteStatementNode(Method method) {
        CheckExpressionNode node = Expression.getCheckExpressionNode((ExpressionNode)Expression.getRemoteMethodCallActionNode((ExpressionNode)TypeDescriptor.getBuiltinSimpleNameReferenceNode(ClientSampleSyntaxTreeUtils.getStreamingClientName(method.getMethodName())), "complete", new String[0]));
        return Statement.getCallStatementNode((ExpressionNode)node);
    }

    private static VariableDeclarationNode getStreamReceiveValueDeclarationNode(Method method, String filename) {
        TypedBindingPatternNode bindingPatternNode = TypeDescriptor.getTypedBindingPatternNode((TypeDescriptorNode)TypeDescriptor.getSimpleNameReferenceNode(method.getOutputPackageType(filename) + method.getOutputType() + "? "), (BindingPatternNode)TypeDescriptor.getCaptureBindingPatternNode(ClientSampleSyntaxTreeUtils.getResponseName(method.getMethodName())));
        CheckExpressionNode checkExpressionNode = Expression.getCheckExpressionNode((ExpressionNode)Expression.getRemoteMethodCallActionNode((ExpressionNode)TypeDescriptor.getSimpleNameReferenceNode(ClientSampleSyntaxTreeUtils.getStreamingClientName(method.getMethodName())), "receive" + CommonUtils.getMethodType(method.getOutputType()), new String[0]));
        VariableDeclaration streamingCallVariable = new VariableDeclaration(bindingPatternNode, (ExpressionNode)checkExpressionNode);
        return streamingCallVariable.getVariableDeclarationNode();
    }

    private static VariableDeclarationNode getInputDeclarationStatement(Method method, String filename, Map<String, Message> msgMap) {
        TypedBindingPatternNode bindingPatternNode = TypeDescriptor.getTypedBindingPatternNode((TypeDescriptorNode)TypeDescriptor.getSimpleNameReferenceNode(ClientSampleSyntaxTreeUtils.getNameWithNewLine(method.getInputPackagePrefix(filename) + method.getInputType() + " ")), (BindingPatternNode)TypeDescriptor.getCaptureBindingPatternNode(ClientSampleSyntaxTreeUtils.getRequestName(method.getMethodName())));
        ExpressionNode node = null;
        if (INPUT_TYPE_EXPR_NODES.containsKey(method.getInputType())) {
            node = INPUT_TYPE_EXPR_NODES.get(method.getInputType());
        } else if (msgMap.containsKey(method.getInputType())) {
            Message msg = msgMap.get(method.getInputType());
            node = NodeFactory.createMappingConstructorExpressionNode((Token)SyntaxTreeConstants.SYNTAX_TREE_OPEN_BRACE, (SeparatedNodeList)NodeFactory.createSeparatedNodeList(ClientSampleSyntaxTreeUtils.getFieldNodes(msg, msgMap)), (Token)SyntaxTreeConstants.SYNTAX_TREE_CLOSE_BRACE);
        }
        VariableDeclaration valueVariable = new VariableDeclaration(bindingPatternNode, node);
        return valueVariable.getVariableDeclarationNode();
    }

    private static ArrayList<Node> getFieldNodes(Message message, Map<String, Message> msgMap) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        if (message.getFieldList().size() == 0) {
            return nodes;
        }
        for (Field field : message.getFieldList()) {
            nodes.add((Node)NodeFactory.createFieldMatchPatternNode((IdentifierToken)AbstractNodeFactory.createIdentifierToken((String)(field.getFieldName() + " ")), (Token)SyntaxTreeConstants.SYNTAX_TREE_COLON, (Node)ClientSampleSyntaxTreeUtils.getFieldPatternNode(field, msgMap)));
            nodes.add((Node)NodeFactory.createCaptureBindingPatternNode((Token)SyntaxTreeConstants.SYNTAX_TREE_COMMA));
        }
        nodes.remove(nodes.size() - 1);
        return nodes;
    }

    private static Node getFieldPatternNode(Field field, Map<String, Message> msgMap) {
        Object node = switch (field.getFieldType()) {
            case "int", "int:Signed32", "int:Unsigned32", "float", "decimal" -> TypeDescriptor.getCaptureBindingPatternNode("1");
            case "boolean" -> TypeDescriptor.getCaptureBindingPatternNode("true");
            case "byte[]" -> TypeDescriptor.getCaptureBindingPatternNode("[72,101,108,108,111]");
            case "Timestamp", "time:Utc" -> TypeDescriptor.getCaptureBindingPatternNode("[1659688553,0.310073000d]");
            case "Duration", "time:Seconds" -> TypeDescriptor.getCaptureBindingPatternNode("0.310073000d");
            case "Struct", "map<anydata>" -> TypeDescriptor.getCaptureBindingPatternNode("{message: \"Hello Ballerina\"}");
            case "string" -> TypeDescriptor.getCaptureBindingPatternNode("\"ballerina\"");
            case "'any:Any" -> Expression.getCheckExpressionNode((ExpressionNode)Statement.getFunctionCallExpressionNode("'any", "pack", "\"ballerina\""));
            default -> msgMap.containsKey(field.getFieldType()) ? ClientSampleSyntaxTreeUtils.handleMessageTypes(field, msgMap) : (BallerinaFileBuilder.enumDefaultValueMap.containsKey(field.getFieldType()) ? ClientSampleSyntaxTreeUtils.handleEnumTypes(field) : TypeDescriptor.getCaptureBindingPatternNode("{}"));
        };
        if (field.getFieldLabel() != null && field.getFieldLabel().equals("[]")) {
            List<CaptureBindingPatternNode> subRecordNodes = Collections.singletonList(node);
            return Expression.getListConstructorExpressionNode(subRecordNodes);
        }
        return node;
    }

    private static CaptureBindingPatternNode handleEnumTypes(Field field) {
        return TypeDescriptor.getCaptureBindingPatternNode("\"" + BallerinaFileBuilder.enumDefaultValueMap.get(field.getFieldType()) + "\"");
    }

    private static MappingConstructorExpressionNode handleMessageTypes(Field field, Map<String, Message> msgMap) {
        Message msg = msgMap.get(field.getFieldType());
        ArrayList<Node> subRecordNodes = ClientSampleSyntaxTreeUtils.getFieldNodes(msg, msgMap);
        return NodeFactory.createMappingConstructorExpressionNode((Token)SyntaxTreeConstants.SYNTAX_TREE_OPEN_BRACE, (SeparatedNodeList)NodeFactory.createSeparatedNodeList(subRecordNodes), (Token)SyntaxTreeConstants.SYNTAX_TREE_CLOSE_BRACE);
    }

    private static NodeList<ImportDeclarationNode> addImports(NodeList<ImportDeclarationNode> imports, ServiceStub stub, String filename) {
        ArrayList<Method> methods = new ArrayList<Method>();
        methods.addAll(stub.getUnaryFunctions());
        methods.addAll(stub.getClientStreamingFunctions());
        methods.addAll(stub.getServerStreamingFunctions());
        methods.addAll(stub.getBidiStreamingFunctions());
        imports = ClientSampleSyntaxTreeUtils.addIoImport(methods, imports);
        imports = CommonUtils.addSubModuleImports(methods, filename, imports);
        imports = CommonUtils.addAnyImportIfExists(methods, imports);
        return CommonUtils.addTimeImportsIfExists(methods, imports);
    }

    private static NodeList<ImportDeclarationNode> addIoImport(List<Method> methods, NodeList<ImportDeclarationNode> imports) {
        for (Method method : methods) {
            if (method.getOutputType() == null) continue;
            return imports.add((Node)Imports.getImportDeclarationNode("ballerina", "io"));
        }
        return imports;
    }

    private static ExpressionStatementNode getPrintlnStatement(String input) {
        return Statement.getCallStatementNode((ExpressionNode)Statement.getFunctionCallExpressionNode("io", "println", input));
    }

    private static String getNameWithNewLine(String filename) {
        if (firstLine) {
            firstLine = false;
            return "\n\n" + filename;
        }
        return filename;
    }

    private static String getResponseName(String methodName) {
        return CommonUtils.toCamelCase(methodName) + "Response";
    }

    private static String getRequestName(String methodName) {
        return CommonUtils.toCamelCase(methodName) + "Request";
    }

    private static String getStreamingClientName(String methodName) {
        return CommonUtils.toCamelCase(methodName) + "StreamingClient";
    }

    static {
        INPUT_TYPE_EXPR_NODES = new HashMap<String, ExpressionNode>();
        INPUT_TYPE_EXPR_NODES.put("int", (ExpressionNode)Literal.getNumericLiteralNode(1));
        INPUT_TYPE_EXPR_NODES.put("float", (ExpressionNode)Literal.getNumericLiteralNode(1));
        INPUT_TYPE_EXPR_NODES.put("decimal", (ExpressionNode)Literal.getNumericLiteralNode(1));
        INPUT_TYPE_EXPR_NODES.put("boolean", (ExpressionNode)Literal.getBooleanLiteralNode(true));
        INPUT_TYPE_EXPR_NODES.put("string", (ExpressionNode)Literal.getStringLiteralNode("ballerina"));
        INPUT_TYPE_EXPR_NODES.put("byte[]", (ExpressionNode)Literal.getByteArrayLiteralNode("[72,101,108,108,111]"));
        INPUT_TYPE_EXPR_NODES.put("time:Utc", (ExpressionNode)Literal.getTupleLiteralNode("[1659688553,0.310073000d]"));
        INPUT_TYPE_EXPR_NODES.put("time:Seconds", (ExpressionNode)Literal.getDecimalLiteralNode("0.310073000d"));
        INPUT_TYPE_EXPR_NODES.put("map<anydata>", (ExpressionNode)Literal.createBasicLiteralNode(SyntaxKind.MAP_TYPE_DESC, "{message: \"Hello Ballerina\"}"));
        INPUT_TYPE_EXPR_NODES.put("'any:Any", (ExpressionNode)Expression.getCheckExpressionNode((ExpressionNode)Statement.getFunctionCallExpressionNode("'any", "pack", "\"ballerina\"")));
    }
}

