/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.formatter.core;

import io.ballerina.compiler.syntax.tree.AnnotAccessExpressionNode;
import io.ballerina.compiler.syntax.tree.BinaryExpressionNode;
import io.ballerina.compiler.syntax.tree.BracedExpressionNode;
import io.ballerina.compiler.syntax.tree.CheckExpressionNode;
import io.ballerina.compiler.syntax.tree.ConditionalExpressionNode;
import io.ballerina.compiler.syntax.tree.ErrorConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.ExplicitAnonymousFunctionExpressionNode;
import io.ballerina.compiler.syntax.tree.ExplicitNewExpressionNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.FieldAccessExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionCallExpressionNode;
import io.ballerina.compiler.syntax.tree.ImplicitAnonymousFunctionExpressionNode;
import io.ballerina.compiler.syntax.tree.ImplicitNewExpressionNode;
import io.ballerina.compiler.syntax.tree.IndexedExpressionNode;
import io.ballerina.compiler.syntax.tree.LetExpressionNode;
import io.ballerina.compiler.syntax.tree.ListConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MethodCallExpressionNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeParser;
import io.ballerina.compiler.syntax.tree.ObjectConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.OptionalFieldAccessExpressionNode;
import io.ballerina.compiler.syntax.tree.QueryExpressionNode;
import io.ballerina.compiler.syntax.tree.RequiredExpressionNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.TableConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.TemplateExpressionNode;
import io.ballerina.compiler.syntax.tree.TransactionalExpressionNode;
import io.ballerina.compiler.syntax.tree.TrapExpressionNode;
import io.ballerina.compiler.syntax.tree.TypeCastExpressionNode;
import io.ballerina.compiler.syntax.tree.TypeTestExpressionNode;
import io.ballerina.compiler.syntax.tree.TypeofExpressionNode;
import io.ballerina.compiler.syntax.tree.UnaryExpressionNode;
import io.ballerina.compiler.syntax.tree.XMLFilterExpressionNode;
import io.ballerina.compiler.syntax.tree.XMLStepExpressionNode;
import io.ballerina.tools.text.LineRange;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextDocuments;
import org.ballerinalang.formatter.core.FormatterException;
import org.ballerinalang.formatter.core.FormattingTreeModifier;
import org.ballerinalang.formatter.core.options.FormattingOptions;

public final class Formatter {
    private Formatter() {
    }

    public static String format(String source) throws FormatterException {
        return Formatter.format(source, FormattingOptions.builder().build());
    }

    public static SyntaxTree format(SyntaxTree syntaxTree, LineRange range) throws FormatterException {
        return Formatter.format(syntaxTree, range, FormattingOptions.builder().build());
    }

    public static SyntaxTree format(SyntaxTree syntaxTree) throws FormatterException {
        return Formatter.format(syntaxTree, FormattingOptions.builder().build());
    }

    public static String format(String source, FormattingOptions options) throws FormatterException {
        TextDocument textDocument = TextDocuments.from((String)source);
        SyntaxTree syntaxTree = SyntaxTree.from((TextDocument)textDocument);
        return Formatter.modifyTree(syntaxTree, options, null).toSourceCode();
    }

    public static SyntaxTree format(SyntaxTree syntaxTree, LineRange range, FormattingOptions options) throws FormatterException {
        return Formatter.modifyTree(syntaxTree, options, range);
    }

    public static SyntaxTree format(SyntaxTree syntaxTree, FormattingOptions options) throws FormatterException {
        return Formatter.modifyTree(syntaxTree, options, null);
    }

    public static String formatExpression(String text) throws FormatterException {
        FormattingTreeModifier treeModifier = new FormattingTreeModifier(FormattingOptions.builder().build(), null);
        ExpressionNode parsedNode = NodeParser.parseExpression((String)text);
        AnnotAccessExpressionNode formattedNode = switch (parsedNode.kind()) {
            case SyntaxKind.ANNOT_ACCESS -> treeModifier.transform((AnnotAccessExpressionNode)parsedNode);
            case SyntaxKind.BINARY_EXPRESSION -> treeModifier.transform((BinaryExpressionNode)parsedNode);
            case SyntaxKind.BRACED_EXPRESSION -> treeModifier.transform((BracedExpressionNode)parsedNode);
            case SyntaxKind.CHECK_EXPRESSION -> treeModifier.transform((CheckExpressionNode)parsedNode);
            case SyntaxKind.CONDITIONAL_EXPRESSION -> treeModifier.transform((ConditionalExpressionNode)parsedNode);
            case SyntaxKind.ERROR_CONSTRUCTOR -> treeModifier.transform((ErrorConstructorExpressionNode)parsedNode);
            case SyntaxKind.EXPLICIT_ANONYMOUS_FUNCTION_EXPRESSION -> treeModifier.transform((ExplicitAnonymousFunctionExpressionNode)parsedNode);
            case SyntaxKind.EXPLICIT_NEW_EXPRESSION -> treeModifier.transform((ExplicitNewExpressionNode)parsedNode);
            case SyntaxKind.FIELD_ACCESS -> treeModifier.transform((FieldAccessExpressionNode)parsedNode);
            case SyntaxKind.FUNCTION_CALL -> treeModifier.transform((FunctionCallExpressionNode)parsedNode);
            case SyntaxKind.IMPLICIT_ANONYMOUS_FUNCTION_EXPRESSION -> treeModifier.transform((ImplicitAnonymousFunctionExpressionNode)parsedNode);
            case SyntaxKind.IMPLICIT_NEW_EXPRESSION -> treeModifier.transform((ImplicitNewExpressionNode)parsedNode);
            case SyntaxKind.INDEXED_EXPRESSION -> treeModifier.transform((IndexedExpressionNode)parsedNode);
            case SyntaxKind.LET_EXPRESSION -> treeModifier.transform((LetExpressionNode)parsedNode);
            case SyntaxKind.LIST_CONSTRUCTOR -> treeModifier.transform((ListConstructorExpressionNode)parsedNode);
            case SyntaxKind.MAPPING_CONSTRUCTOR -> treeModifier.transform((MappingConstructorExpressionNode)parsedNode);
            case SyntaxKind.METHOD_CALL -> treeModifier.transform((MethodCallExpressionNode)parsedNode);
            case SyntaxKind.OBJECT_CONSTRUCTOR -> treeModifier.transform((ObjectConstructorExpressionNode)parsedNode);
            case SyntaxKind.OPTIONAL_FIELD_ACCESS -> treeModifier.transform((OptionalFieldAccessExpressionNode)parsedNode);
            case SyntaxKind.QUERY_EXPRESSION -> treeModifier.transform((QueryExpressionNode)parsedNode);
            case SyntaxKind.REQUIRED_EXPRESSION -> treeModifier.transform((RequiredExpressionNode)parsedNode);
            case SyntaxKind.TABLE_CONSTRUCTOR -> treeModifier.transform((TableConstructorExpressionNode)parsedNode);
            case SyntaxKind.RAW_TEMPLATE_EXPRESSION -> treeModifier.transform((TemplateExpressionNode)parsedNode);
            case SyntaxKind.TRANSACTIONAL_EXPRESSION -> treeModifier.transform((TransactionalExpressionNode)parsedNode);
            case SyntaxKind.TRAP_EXPRESSION -> treeModifier.transform((TrapExpressionNode)parsedNode);
            case SyntaxKind.TYPE_CAST_EXPRESSION -> treeModifier.transform((TypeCastExpressionNode)parsedNode);
            case SyntaxKind.TYPE_TEST_EXPRESSION -> treeModifier.transform((TypeTestExpressionNode)parsedNode);
            case SyntaxKind.TYPEOF_EXPRESSION -> treeModifier.transform((TypeofExpressionNode)parsedNode);
            case SyntaxKind.UNARY_EXPRESSION -> treeModifier.transform((UnaryExpressionNode)parsedNode);
            case SyntaxKind.XML_FILTER_EXPRESSION -> treeModifier.transform((XMLFilterExpressionNode)parsedNode);
            case SyntaxKind.XML_STEP_EXPRESSION -> treeModifier.transform((XMLStepExpressionNode)parsedNode);
            default -> throw new FormatterException("Unsupported expression type: " + String.valueOf(parsedNode.kind()));
        };
        return formattedNode.toSourceCode().strip();
    }

    private static SyntaxTree modifyTree(SyntaxTree syntaxTree, FormattingOptions options, LineRange range) throws FormatterException {
        FormattingTreeModifier treeModifier = new FormattingTreeModifier(options, range);
        ModulePartNode modulePartNode = (ModulePartNode)syntaxTree.rootNode();
        try {
            return syntaxTree.modifyWith((Node)treeModifier.transform(modulePartNode));
        }
        catch (Exception e) {
            throw new FormatterException("Error while formatting: " + e.getMessage(), e.getCause());
        }
    }
}

