/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.formatter.core.options;

import java.util.Map;
import org.ballerinalang.formatter.core.FormatterException;
import org.ballerinalang.formatter.core.FormatterUtils;
import org.ballerinalang.formatter.core.options.BraceStyle;
import org.ballerinalang.formatter.core.options.FormatSection;

public class BraceFormattingOptions {
    private final BraceStyle classBraceStyle;
    private final BraceStyle functionBraceStyle;

    private BraceFormattingOptions(BraceStyle classBraceStyle, BraceStyle functionBraceStyle) {
        this.classBraceStyle = classBraceStyle;
        this.functionBraceStyle = functionBraceStyle;
    }

    public BraceStyle classBraceStyle() {
        return this.classBraceStyle;
    }

    public BraceStyle functionBraceStyle() {
        return this.functionBraceStyle;
    }

    public static BraceFormattingOptionsBuilder builder() {
        return new BraceFormattingOptionsBuilder();
    }

    public static class BraceFormattingOptionsBuilder {
        private static final String CLASS_BRACE_STYLE = "classBraceStyle";
        private static final String FUNCTION_BRACE_STYLE = "functionBraceStyle";
        private BraceStyle classBraceStyle = BraceStyle.valueOf(FormatterUtils.getDefaultString(FormatSection.BRACES, "classBraceStyle"));
        private BraceStyle functionBraceStyle = BraceStyle.valueOf(FormatterUtils.getDefaultString(FormatSection.BRACES, "functionBraceStyle"));

        public BraceFormattingOptionsBuilder setClassBraceStyle(BraceStyle classBraceStyle) {
            this.classBraceStyle = classBraceStyle;
            return this;
        }

        public BraceFormattingOptionsBuilder setFunctionBraceStyle(BraceStyle functionBraceStyle) {
            this.functionBraceStyle = functionBraceStyle;
            return this;
        }

        public BraceFormattingOptions build() {
            return new BraceFormattingOptions(this.classBraceStyle, this.functionBraceStyle);
        }

        public BraceFormattingOptions build(Map<String, Object> configs) throws FormatterException {
            block8: for (Map.Entry<String, Object> bracesEntry : configs.entrySet()) {
                String bracesKey = bracesEntry.getKey();
                BraceStyle style = BraceStyle.fromString((String)bracesEntry.getValue());
                switch (bracesKey) {
                    case "classBraceStyle": {
                        this.setClassBraceStyle(style);
                        continue block8;
                    }
                    case "functionBraceStyle": {
                        this.setFunctionBraceStyle(style);
                        continue block8;
                    }
                }
                throw new FormatterException("invalid Brace Option: " + bracesKey);
            }
            return this.build();
        }
    }
}

