/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.formatter.core.options;

import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import org.ballerinalang.formatter.core.FormatterException;
import org.ballerinalang.formatter.core.FormatterUtils;
import org.ballerinalang.formatter.core.options.BraceFormattingOptions;
import org.ballerinalang.formatter.core.options.ForceFormattingOptions;
import org.ballerinalang.formatter.core.options.FormatSection;
import org.ballerinalang.formatter.core.options.FunctionCallFormattingOptions;
import org.ballerinalang.formatter.core.options.FunctionDefFormattingOptions;
import org.ballerinalang.formatter.core.options.IfStatementFormattingOptions;
import org.ballerinalang.formatter.core.options.ImportFormattingOptions;
import org.ballerinalang.formatter.core.options.IndentFormattingOptions;
import org.ballerinalang.formatter.core.options.QueryFormattingOptions;
import org.ballerinalang.formatter.core.options.SpacingFormattingOptions;
import org.ballerinalang.formatter.core.options.WrappingFormattingOptions;

public class FormattingOptions {
    private final IndentFormattingOptions indentFormattingOptions;
    private final WrappingFormattingOptions wrappingFormattingOptions;
    private final BraceFormattingOptions braceFormattingOptions;
    private final FunctionDefFormattingOptions functionDefFormattingOptions;
    private final FunctionCallFormattingOptions functionCallFormattingOptions;
    private final IfStatementFormattingOptions ifStatementFormattingOptions;
    private final SpacingFormattingOptions spacingFormattingOptions;
    private final ForceFormattingOptions forceFormattingOptions;
    private final ImportFormattingOptions importFormattingOptions;
    private final QueryFormattingOptions queryFormattingOptions;

    private FormattingOptions(IndentFormattingOptions indentFormattingOptions, WrappingFormattingOptions wrappingFormattingOptions, BraceFormattingOptions braceFormattingOptions, FunctionDefFormattingOptions functionDefFormattingOptions, FunctionCallFormattingOptions functionCallFormattingOptions, IfStatementFormattingOptions ifStatementFormattingOptions, SpacingFormattingOptions spacingFormattingOptions, ForceFormattingOptions forceFormattingOptions, ImportFormattingOptions importFormattingOptions, QueryFormattingOptions queryFormattingOptions) {
        this.indentFormattingOptions = indentFormattingOptions;
        this.wrappingFormattingOptions = wrappingFormattingOptions;
        this.braceFormattingOptions = braceFormattingOptions;
        this.functionDefFormattingOptions = functionDefFormattingOptions;
        this.functionCallFormattingOptions = functionCallFormattingOptions;
        this.ifStatementFormattingOptions = ifStatementFormattingOptions;
        this.spacingFormattingOptions = spacingFormattingOptions;
        this.forceFormattingOptions = forceFormattingOptions;
        this.importFormattingOptions = importFormattingOptions;
        this.queryFormattingOptions = queryFormattingOptions;
    }

    public ForceFormattingOptions forceFormattingOptions() {
        return this.forceFormattingOptions;
    }

    public ImportFormattingOptions importFormattingOptions() {
        return this.importFormattingOptions;
    }

    public IndentFormattingOptions indentFormattingOptions() {
        return this.indentFormattingOptions;
    }

    public WrappingFormattingOptions wrappingFormattingOptions() {
        return this.wrappingFormattingOptions;
    }

    public BraceFormattingOptions braceFormattingOptions() {
        return this.braceFormattingOptions;
    }

    public FunctionDefFormattingOptions functionDefFormattingOptions() {
        return this.functionDefFormattingOptions;
    }

    public FunctionCallFormattingOptions functionCallFormattingOptions() {
        return this.functionCallFormattingOptions;
    }

    public IfStatementFormattingOptions ifStatementFormattingOptions() {
        return this.ifStatementFormattingOptions;
    }

    public SpacingFormattingOptions spacingFormattingOptions() {
        return this.spacingFormattingOptions;
    }

    public QueryFormattingOptions queryFormattingOptions() {
        return this.queryFormattingOptions;
    }

    public static FormattingOptionsBuilder builder() {
        return new FormattingOptionsBuilder();
    }

    public static class FormattingOptionsBuilder {
        private int tabSize = 4;
        private String wsCharacter = " ";
        private int columnLimit = 120;
        private boolean lineWrapping = false;
        private IndentFormattingOptions indentFormattingOptions = IndentFormattingOptions.builder().build();
        private WrappingFormattingOptions wrappingFormattingOptions = WrappingFormattingOptions.builder().build();
        private BraceFormattingOptions braceFormattingOptions = BraceFormattingOptions.builder().build();
        private FunctionDefFormattingOptions functionDefFormattingOptions = FunctionDefFormattingOptions.builder().build();
        private FunctionCallFormattingOptions functionCallFormattingOptions = FunctionCallFormattingOptions.builder().build();
        private IfStatementFormattingOptions ifStatementFormattingOptions = IfStatementFormattingOptions.builder().build();
        private SpacingFormattingOptions spacingFormattingOptions = SpacingFormattingOptions.builder().build();
        private ImportFormattingOptions importFormattingOptions = ImportFormattingOptions.builder().build();
        private QueryFormattingOptions queryFormattingOptions = QueryFormattingOptions.builder().build();
        private ForceFormattingOptions forceFormattingOptions = ForceFormattingOptions.builder().build();

        @Deprecated
        public FormattingOptionsBuilder setTabSize(int tabSize) {
            this.tabSize = tabSize;
            return this;
        }

        @Deprecated
        public FormattingOptionsBuilder setWSCharacter(String wsCharacter) {
            this.wsCharacter = wsCharacter;
            return this;
        }

        @Deprecated
        public FormattingOptionsBuilder setColumnLimit(int columnLimit) {
            this.columnLimit = columnLimit;
            return this;
        }

        @Deprecated
        public FormattingOptionsBuilder setLineWrapping(boolean lineWrapping) {
            this.lineWrapping = lineWrapping;
            return this;
        }

        public FormattingOptionsBuilder setForceFormattingOptions(ForceFormattingOptions forceFormattingOptions) {
            this.forceFormattingOptions = forceFormattingOptions;
            return this;
        }

        public FormattingOptionsBuilder setImportFormattingOptions(ImportFormattingOptions importFormattingOptions) {
            this.importFormattingOptions = importFormattingOptions;
            return this;
        }

        public FormattingOptionsBuilder setWrappingFormattingOptions(WrappingFormattingOptions wrappingFormattingOptions) {
            this.wrappingFormattingOptions = wrappingFormattingOptions;
            return this;
        }

        public FormattingOptions build() {
            return new FormattingOptions(this.indentFormattingOptions, this.wrappingFormattingOptions, this.braceFormattingOptions, this.functionDefFormattingOptions, this.functionCallFormattingOptions, this.ifStatementFormattingOptions, this.spacingFormattingOptions, this.forceFormattingOptions, this.importFormattingOptions, this.queryFormattingOptions);
        }

        public FormattingOptions build(Path root, Object formatSection) throws FormatterException {
            Optional<String> path = FormatterUtils.getFormattingFilePath(formatSection, root.toString());
            if (path.isEmpty()) {
                return this.build();
            }
            Map<String, Object> configurations = FormatterUtils.getFormattingConfigurations(root, path.get());
            for (Map.Entry<String, Object> entry : configurations.entrySet()) {
                Object value = entry.getValue();
                if (!(value instanceof Map)) continue;
                Map configs = (Map)value;
                String key = entry.getKey();
                FormatSection section = FormatSection.fromString(key);
                switch (section) {
                    case INDENT: {
                        this.indentFormattingOptions = IndentFormattingOptions.builder().build(configs);
                        break;
                    }
                    case WRAPPING: {
                        this.wrappingFormattingOptions = WrappingFormattingOptions.builder().build(configs);
                        break;
                    }
                    case BRACES: {
                        this.braceFormattingOptions = BraceFormattingOptions.builder().build(configs);
                        break;
                    }
                    case FUNCTION_DEFINITION: {
                        this.functionDefFormattingOptions = FunctionDefFormattingOptions.builder().build(configs);
                        break;
                    }
                    case FUNCTION_CALL: {
                        this.functionCallFormattingOptions = FunctionCallFormattingOptions.builder().build(configs);
                        break;
                    }
                    case IF_STATEMENT: {
                        this.ifStatementFormattingOptions = IfStatementFormattingOptions.builder().build(configs);
                        break;
                    }
                    case QUERY: {
                        this.queryFormattingOptions = QueryFormattingOptions.builder().build(configs);
                        break;
                    }
                    case SPACING: {
                        this.spacingFormattingOptions = SpacingFormattingOptions.builder().build(configs);
                        break;
                    }
                    case IMPORT: {
                        this.importFormattingOptions = ImportFormattingOptions.builder().build(configs);
                    }
                }
            }
            return this.build();
        }
    }
}

