/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.formatter.core.options;

import java.util.Map;
import org.ballerinalang.formatter.core.FormatterException;
import org.ballerinalang.formatter.core.FormatterUtils;
import org.ballerinalang.formatter.core.options.FormatSection;

public class IfStatementFormattingOptions {
    private final boolean elseOnNewLine;

    private IfStatementFormattingOptions(boolean elseOnNewLine) {
        this.elseOnNewLine = elseOnNewLine;
    }

    public boolean elseOnNewLine() {
        return this.elseOnNewLine;
    }

    public static IfStatementFormattingOptionsBuilder builder() {
        return new IfStatementFormattingOptionsBuilder();
    }

    public static class IfStatementFormattingOptionsBuilder {
        private static final String ELSE_ON_NEW_LINE = "elseOnNewLine";
        private boolean elseOnNewLine = FormatterUtils.getDefaultBoolean(FormatSection.IF_STATEMENT, "elseOnNewLine");

        public IfStatementFormattingOptionsBuilder setElseOnNewLine(boolean elseOnNewLine) {
            this.elseOnNewLine = elseOnNewLine;
            return this;
        }

        public IfStatementFormattingOptions build() {
            return new IfStatementFormattingOptions(this.elseOnNewLine);
        }

        public IfStatementFormattingOptions build(Map<String, Object> configs) throws FormatterException {
            for (Map.Entry<String, Object> ifStatementEntry : configs.entrySet()) {
                String ifStatementKey = ifStatementEntry.getKey();
                if (ifStatementKey.equals(ELSE_ON_NEW_LINE)) {
                    this.setElseOnNewLine((Boolean)ifStatementEntry.getValue());
                    continue;
                }
                throw new FormatterException("invalid if statement formatting option: " + ifStatementKey);
            }
            return this.build();
        }
    }
}

