/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.auth.ldap;

import io.ballerina.stdlib.auth.ldap.CommonLdapConfiguration;
import io.ballerina.stdlib.auth.ldap.SslSocketFactory;
import io.ballerina.stdlib.auth.ldap.utils.LdapUtils;
import java.util.Hashtable;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;

public class ConnectionContext {
    private Hashtable environment;

    public ConnectionContext(CommonLdapConfiguration ldapConfiguration) {
        String connectionURL = ldapConfiguration.getConnectionURL();
        String connectionName = ldapConfiguration.getConnectionName();
        String connectionPassword = ldapConfiguration.getConnectionPassword();
        this.environment = new Hashtable();
        this.environment.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        this.environment.put("java.naming.security.authentication", "simple");
        this.environment.put("java.naming.security.principal", connectionName);
        this.environment.put("java.naming.security.credentials", connectionPassword);
        this.environment.put("java.naming.provider.url", connectionURL);
        boolean isLdapConnectionPoolingEnabled = ldapConfiguration.isConnectionPoolingEnabled();
        this.environment.put("com.sun.jndi.ldap.connect.pool", isLdapConnectionPoolingEnabled ? "true" : "false");
        if (LdapUtils.isLdapsUrl(connectionURL)) {
            this.environment.put("java.naming.security.protocol", "TLS");
            this.environment.put("java.naming.ldap.factory.socket", SslSocketFactory.class.getName());
        }
        String connectTimeout = String.valueOf((int)ldapConfiguration.getConnectionTimeout() * 1000);
        String readTimeout = String.valueOf((int)ldapConfiguration.getReadTimeout() * 1000);
        this.environment.put("com.sun.jndi.ldap.connect.timeout", connectTimeout);
        this.environment.put("com.sun.jndi.ldap.read.timeout", readTimeout);
    }

    public DirContext getContext() throws NamingException {
        return new InitialDirContext(this.environment);
    }

    public LdapContext getContextWithCredentials(String userDN, byte[] password) throws NamingException {
        Hashtable<String, Object> tempEnv = new Hashtable<String, Object>(this.environment);
        tempEnv.put("java.naming.security.principal", userDN);
        tempEnv.put("java.naming.security.credentials", password);
        return this.getContextForEnvironmentVariables(tempEnv);
    }

    private LdapContext getContextForEnvironmentVariables(Hashtable<?, ?> environment) throws NamingException {
        Hashtable tempEnv = new Hashtable(environment);
        return new InitialLdapContext(tempEnv, null);
    }
}

