/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.auth.ldap.nativeimpl;

import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.auth.ldap.CommonLdapConfiguration;
import io.ballerina.stdlib.auth.ldap.utils.LdapUtils;
import java.util.ArrayList;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetGroups {
    private static final Logger LOG = LoggerFactory.getLogger(GetGroups.class);

    private GetGroups() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getGroups(BMap<BString, Object> ldapConnection, BString userName) {
        try {
            LdapUtils.setServiceName((String)ldapConnection.getNativeData("instanceId"));
            DirContext ldapConnectionContext = (DirContext)ldapConnection.getNativeData("connectionContext");
            CommonLdapConfiguration ldapConfiguration = (CommonLdapConfiguration)ldapConnection.getNativeData("ldapConfiguration");
            String[] externalRoles = GetGroups.doGetGroupsListOfUser(userName.getValue(), ldapConfiguration, ldapConnectionContext);
            if (externalRoles.length == 0) {
                Object var5_6 = null;
                return var5_6;
            }
            BArray bArray = StringUtils.fromStringArray((String[])externalRoles);
            return bArray;
        }
        catch (BError | NamingException e) {
            BError bError = LdapUtils.createError(e.getMessage());
            return bError;
        }
        finally {
            LdapUtils.removeServiceName();
        }
    }

    private static String[] doGetGroupsListOfUser(String userName, CommonLdapConfiguration ldapAuthConfig, DirContext ldapConnectionContext) throws NamingException {
        List<String> searchBase = ldapAuthConfig.getGroupSearchBase();
        return GetGroups.getLDAPGroupsListOfUser(userName, searchBase, ldapAuthConfig, ldapConnectionContext);
    }

    private static String[] getLDAPGroupsListOfUser(String userName, List<String> searchBase, CommonLdapConfiguration ldapAuthConfig, DirContext ldapConnectionContext) throws NamingException {
        String membershipValue;
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        Object searchFilter = ldapAuthConfig.getGroupNameListFilter();
        String roleNameProperty = ldapAuthConfig.getGroupNameAttribute();
        String membershipProperty = ldapAuthConfig.getMembershipAttribute();
        String nameInSpace = GetGroups.getNameInSpaceForUsername(userName, ldapAuthConfig, ldapConnectionContext);
        if (membershipProperty == null || membershipProperty.length() < 1) {
            throw LdapUtils.createError("Membership attribute is not set in configurations.");
        }
        if (nameInSpace != null) {
            LdapName ldn = new LdapName(nameInSpace);
            if ("memberUid".equals(ldapAuthConfig.getMembershipAttribute())) {
                List<Rdn> rdns = ldn.getRdns();
                membershipValue = rdns.get(rdns.size() - 1).getValue().toString();
            } else {
                membershipValue = GetGroups.escapeLdapNameForFilter(ldn);
            }
        } else {
            return new String[0];
        }
        searchFilter = "(&" + (String)searchFilter + "(" + membershipProperty + "=" + membershipValue + "))";
        String[] returnedAttributes = new String[]{roleNameProperty};
        searchControls.setReturningAttributes(returnedAttributes);
        LOG.debug("Reading roles with the membership property '{}'", (Object)membershipProperty);
        List<String> list = GetGroups.getListOfNames(searchBase, (String)searchFilter, searchControls, roleNameProperty, ldapConnectionContext);
        return list.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> getListOfNames(List<String> searchBases, String searchFilter, SearchControls searchControls, String property, DirContext ldapConnectionContext) throws NamingException {
        LOG.debug("Result for search-base: '{}', search-filter: '{}', property: '{}', appendDN: 'false'", new Object[]{searchBases, searchFilter, property});
        ArrayList<String> names = new ArrayList<String>();
        NamingEnumeration<SearchResult> answer = null;
        try {
            for (String searchBase : searchBases) {
                answer = ldapConnectionContext.search(LdapUtils.escapeDNForSearch(searchBase), searchFilter, searchControls);
                while (answer.hasMoreElements()) {
                    Attribute attr;
                    SearchResult searchResult = answer.next();
                    if (searchResult.getAttributes() == null || (attr = searchResult.getAttributes().get(property)) == null) continue;
                    NamingEnumeration<?> values = attr.getAll();
                    while (values.hasMoreElements()) {
                        String name = (String)values.nextElement();
                        names.add(name);
                        LOG.debug("Found the user '{}'", (Object)name);
                    }
                }
            }
        }
        finally {
            LdapUtils.closeNamingEnumeration(answer);
        }
        return names;
    }

    private static String getNameInSpaceForUsername(String userName, CommonLdapConfiguration ldapConfiguration, DirContext ldapConnectionContext) throws NamingException {
        return LdapUtils.getNameInSpaceForUsernameFromLDAP(userName, ldapConfiguration, ldapConnectionContext);
    }

    private static String escapeLdapNameForFilter(LdapName ldn) {
        if (ldn == null) {
            LOG.debug("Received null value to escape special characters. Returning null.");
            return null;
        }
        StringBuilder escapedDN = new StringBuilder();
        for (int i = ldn.size() - 1; i > -1; --i) {
            escapedDN.append(GetGroups.escapeSpecialCharactersForFilterWithStarAsRegex(ldn.get(i)));
            if (i == 0) continue;
            escapedDN.append(",");
        }
        LOG.debug("Escaped DN value for filter '{}'", (Object)escapedDN.toString());
        return escapedDN.toString();
    }

    private static String escapeSpecialCharactersForFilterWithStarAsRegex(String filter) {
        StringBuilder sb = new StringBuilder();
        block6: for (int i = 0; i < filter.length(); ++i) {
            char currentChar = filter.charAt(i);
            switch (currentChar) {
                case '\\': {
                    if (filter.charAt(i + 1) == '*') {
                        sb.append("\\2a");
                        ++i;
                        continue block6;
                    }
                    sb.append("\\5c");
                    continue block6;
                }
                case '(': {
                    sb.append("\\28");
                    continue block6;
                }
                case ')': {
                    sb.append("\\29");
                    continue block6;
                }
                case '\u0000': {
                    sb.append("\\00");
                    continue block6;
                }
                default: {
                    sb.append(currentChar);
                }
            }
        }
        return sb.toString();
    }
}

