/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.auth.ldap.nativeimpl;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BDecimal;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.auth.ModuleUtils;
import io.ballerina.stdlib.auth.ldap.CommonLdapConfiguration;
import io.ballerina.stdlib.auth.ldap.ConnectionContext;
import io.ballerina.stdlib.auth.ldap.SslContextTrustManager;
import io.ballerina.stdlib.auth.ldap.utils.LdapUtils;
import io.ballerina.stdlib.auth.ldap.utils.SslUtils;
import java.io.File;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.net.ssl.SSLContext;

public class InitLdapConnection {
    private InitLdapConnection() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object initLdapConnection(BMap<BString, Object> authProviderConfig) {
        CommonLdapConfiguration commonLdapConfiguration = new CommonLdapConfiguration();
        String instanceId = UUID.randomUUID().toString();
        commonLdapConfiguration.setDomainName(authProviderConfig.getStringValue(StringUtils.fromString((String)"domainName")).getValue());
        commonLdapConfiguration.setConnectionURL(authProviderConfig.getStringValue(StringUtils.fromString((String)"connectionUrl")).getValue());
        commonLdapConfiguration.setConnectionName(authProviderConfig.getStringValue(StringUtils.fromString((String)"connectionName")).getValue());
        commonLdapConfiguration.setConnectionPassword(authProviderConfig.getStringValue(StringUtils.fromString((String)"connectionPassword")).getValue());
        commonLdapConfiguration.setUserSearchBase(authProviderConfig.getStringValue(StringUtils.fromString((String)"userSearchBase")).getValue());
        commonLdapConfiguration.setUserEntryObjectClass(authProviderConfig.getStringValue(StringUtils.fromString((String)"userEntryObjectClass")).getValue());
        commonLdapConfiguration.setUsernameAttribute(authProviderConfig.getStringValue(StringUtils.fromString((String)"userNameAttribute")).getValue());
        commonLdapConfiguration.setUsernameSearchFilter(authProviderConfig.getStringValue(StringUtils.fromString((String)"userNameSearchFilter")).getValue());
        commonLdapConfiguration.setUsernameListFilter(authProviderConfig.getStringValue(StringUtils.fromString((String)"userNameListFilter")).getValue());
        commonLdapConfiguration.setGroupSearchBase(InitLdapConnection.getAsStringList(authProviderConfig.getArrayValue(StringUtils.fromString((String)"groupSearchBase")).getStringArray()));
        commonLdapConfiguration.setGroupEntryObjectClass(authProviderConfig.getStringValue(StringUtils.fromString((String)"groupEntryObjectClass")).getValue());
        commonLdapConfiguration.setGroupNameAttribute(authProviderConfig.getStringValue(StringUtils.fromString((String)"groupNameAttribute")).getValue());
        commonLdapConfiguration.setGroupNameSearchFilter(authProviderConfig.getStringValue(StringUtils.fromString((String)"groupNameSearchFilter")).getValue());
        commonLdapConfiguration.setGroupNameListFilter(authProviderConfig.getStringValue(StringUtils.fromString((String)"groupNameListFilter")).getValue());
        commonLdapConfiguration.setMembershipAttribute(authProviderConfig.getStringValue(StringUtils.fromString((String)"membershipAttribute")).getValue());
        commonLdapConfiguration.setUserRolesCacheEnabled(authProviderConfig.getBooleanValue(StringUtils.fromString((String)"userRolesCacheEnabled")));
        commonLdapConfiguration.setConnectionPoolingEnabled(authProviderConfig.getBooleanValue(StringUtils.fromString((String)"connectionPoolingEnabled")));
        commonLdapConfiguration.setConnectionTimeout(((BDecimal)authProviderConfig.get((Object)StringUtils.fromString((String)"connectionTimeout"))).floatValue());
        commonLdapConfiguration.setReadTimeout(((BDecimal)authProviderConfig.get((Object)StringUtils.fromString((String)"readTimeout"))).floatValue());
        BMap sslConfig = authProviderConfig.containsKey((Object)StringUtils.fromString((String)"secureSocket")) ? authProviderConfig.getMapValue(StringUtils.fromString((String)"secureSocket")) : null;
        try {
            if (sslConfig != null) {
                InitLdapConnection.setSslConfig((BMap<BString, Object>)sslConfig, commonLdapConfiguration, instanceId);
                LdapUtils.setServiceName(instanceId);
            }
            ConnectionContext connectionSource = new ConnectionContext(commonLdapConfiguration);
            DirContext dirContext = connectionSource.getContext();
            BMap ldapConnectionRecord = ValueCreator.createRecordValue((Module)ModuleUtils.getModule(), (String)"LdapConnection");
            ldapConnectionRecord.addNativeData("ldapConfiguration", (Object)commonLdapConfiguration);
            ldapConnectionRecord.addNativeData("connectionSource", (Object)connectionSource);
            ldapConnectionRecord.addNativeData("connectionContext", (Object)dirContext);
            ldapConnectionRecord.addNativeData("instanceId", (Object)instanceId);
            BMap bMap = ldapConnectionRecord;
            return bMap;
        }
        catch (IOException | IllegalArgumentException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException | NamingException e) {
            if (e.getCause() == null) {
                BError bError = LdapUtils.createError(e.getMessage());
                return bError;
            }
            BError bError = LdapUtils.createError(e.getCause().getMessage());
            return bError;
        }
        finally {
            if (sslConfig != null) {
                LdapUtils.removeServiceName();
            }
        }
    }

    private static void setSslConfig(BMap<BString, Object> sslConfig, CommonLdapConfiguration commonLdapConfiguration, String instanceId) throws IOException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException, CertificateException {
        Object cert = sslConfig.get((Object)StringUtils.fromString((String)"cert"));
        if (cert instanceof BMap) {
            BMap trustStore = (BMap)cert;
            String trustStoreFilePath = trustStore.getStringValue(StringUtils.fromString((String)"path")).getValue();
            String trustStorePassword = trustStore.getStringValue(StringUtils.fromString((String)"password")).getValue();
            File trustStoreFile = new File(trustStoreFilePath);
            if (!trustStoreFile.exists()) {
                throw new IllegalArgumentException("TrustStore file '" + trustStoreFilePath + "' not found.");
            }
            commonLdapConfiguration.setTrustStoreFile(trustStoreFile);
            commonLdapConfiguration.setTrustStorePass(trustStorePassword);
            SSLContext sslContext = SslUtils.createClientSslContext(trustStoreFilePath, trustStorePassword);
            SslContextTrustManager.getInstance().addSSLContext(instanceId, sslContext);
        } else {
            String trustedCertFile = ((BString)cert).getValue();
            commonLdapConfiguration.setClientTrustCertificates(trustedCertFile);
            SSLContext sslContext = SslUtils.getSslContextForCertificateFile(trustedCertFile);
            SslContextTrustManager.getInstance().addSSLContext(instanceId, sslContext);
        }
    }

    private static List<String> getAsStringList(Object[] values) {
        ArrayList<String> valuesList = new ArrayList<String>();
        for (Object val : values) {
            valuesList.add(val.toString().trim());
        }
        return valuesList;
    }
}

