/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.tcp.compiler;

import io.ballerina.compiler.api.symbols.ClassSymbol;
import io.ballerina.compiler.api.symbols.MethodSymbol;
import io.ballerina.compiler.api.symbols.ParameterSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.stdlib.tcp.compiler.CompilationErrors;
import io.ballerina.stdlib.tcp.compiler.PluginConstants;
import io.ballerina.stdlib.tcp.compiler.Utils;
import io.ballerina.tools.diagnostics.Location;
import java.util.List;
import java.util.Optional;

public class TcpConnectionServiceValidator {
    private MethodSymbol onCloseFunctionSymbol;
    private MethodSymbol onBytesFunctionSymbol;
    private MethodSymbol onErrorFunctionSymbol;
    private final ClassSymbol classSymbol;
    private final SyntaxNodeAnalysisContext ctx;

    public TcpConnectionServiceValidator(SyntaxNodeAnalysisContext syntaxNodeAnalysisContext, ClassSymbol classSymbol) {
        this.ctx = syntaxNodeAnalysisContext;
        this.classSymbol = classSymbol;
    }

    public void validate() {
        this.classSymbol.methods().values().stream().forEach(methodSymbol -> this.filterRemoteMethods((MethodSymbol)methodSymbol));
        this.checkOnBytesFunctionExistence();
        this.validateFunctionSignature(this.onBytesFunctionSymbol, "onBytes");
        this.validateFunctionSignature(this.onErrorFunctionSymbol, "onError");
        this.validateFunctionSignature(this.onCloseFunctionSymbol, "onClose");
    }

    private void filterRemoteMethods(MethodSymbol methodSymbol) {
        String functionName = (String)methodSymbol.getName().get();
        if (Utils.hasRemoteKeyword(methodSymbol) && !Utils.equals(functionName, "onBytes") && !Utils.equals(functionName, "onError") && !Utils.equals(functionName, "onClose")) {
            this.reportInvalidFunction(methodSymbol);
        } else {
            this.onBytesFunctionSymbol = Utils.equals(functionName, "onBytes") ? methodSymbol : this.onBytesFunctionSymbol;
            this.onErrorFunctionSymbol = Utils.equals(functionName, "onError") ? methodSymbol : this.onErrorFunctionSymbol;
            this.onCloseFunctionSymbol = Utils.equals(functionName, "onClose") ? methodSymbol : this.onCloseFunctionSymbol;
        }
    }

    private void reportInvalidFunction(MethodSymbol methodSymbol) {
        Utils.reportDiagnostics(this.ctx, CompilationErrors.FUNCTION_0_NOT_ACCEPTED_BY_THE_SERVICE, (Location)methodSymbol.getLocation().get(), methodSymbol.getName().get());
    }

    private void validateFunctionSignature(MethodSymbol methodSymbol, String functionName) {
        if (methodSymbol != null) {
            this.hasRemoteKeyword(methodSymbol, functionName);
            List parameterSymbols = methodSymbol.typeDescriptor().parameters();
            if (!functionName.equals("onClose") && this.hasNoParameters(parameterSymbols, methodSymbol, functionName)) {
                return;
            }
            this.validateParameter(parameterSymbols, functionName);
            this.validateFunctionReturnTypeDesc(methodSymbol, functionName);
        }
    }

    private void checkOnBytesFunctionExistence() {
        if (this.onBytesFunctionSymbol == null) {
            Utils.reportDiagnostics(this.ctx, CompilationErrors.SERVICE_DOES_NOT_CONTAIN_ON_BYTES_FUNCTION, (Location)this.ctx.node().location(), new Object[0]);
        }
    }

    private void hasRemoteKeyword(MethodSymbol methodSymbol, String functionName) {
        boolean hasRemoteKeyword = Utils.hasRemoteKeyword(methodSymbol);
        if (!hasRemoteKeyword) {
            Utils.reportDiagnostics(this.ctx, CompilationErrors.REMOTE_KEYWORD_EXPECTED_IN_0_FUNCTION_SIGNATURE, (Location)methodSymbol.getLocation().get(), functionName);
        }
    }

    private boolean hasNoParameters(List<ParameterSymbol> parameterSymbols, MethodSymbol methodSymbol, String functionName) {
        if (parameterSymbols.isEmpty()) {
            Object expectedParameter = functionName.equals("onBytes") ? "readonly & byte[]" : PluginConstants.MODULE_PREFIX + "Error";
            Utils.reportDiagnostics(this.ctx, CompilationErrors.NO_PARAMETER_PROVIDED_FOR_0_FUNCTION_EXPECTS_1_AS_A_PARAMETER, (Location)methodSymbol.getLocation().get(), functionName, expectedParameter);
            return true;
        }
        return false;
    }

    private void validateParameter(List<ParameterSymbol> parameterSymbols, String functionName) {
        if (this.hasValidParameterCount(parameterSymbols.size(), functionName)) {
            for (ParameterSymbol parameterSymbol : parameterSymbols) {
                TypeSymbol typeSymbol = parameterSymbol.typeDescriptor();
                String signature = typeSymbol.signature();
                boolean hasCaller = signature.startsWith(PluginConstants.MODULE_PREFIX) && signature.endsWith(SyntaxKind.COLON_TOKEN.stringValue() + "Caller");
                boolean hasError = signature.startsWith(PluginConstants.MODULE_PREFIX) && signature.endsWith(SyntaxKind.COLON_TOKEN.stringValue() + "Error");
                boolean hasByteArray = signature.contains("byte[]");
                if (functionName.equals("onBytes") && (typeSymbol.typeKind() == TypeDescKind.INTERSECTION && !hasByteArray || typeSymbol.typeKind() == TypeDescKind.TYPE_REFERENCE && !hasCaller)) {
                    Utils.reportDiagnostics(this.ctx, CompilationErrors.INVALID_PARAMETER_0_PROVIDED_FOR_1_FUNCTION, (Location)parameterSymbol.getLocation().get(), parameterSymbol.signature(), functionName);
                    continue;
                }
                if (functionName.equals("onError") && (typeSymbol.typeKind() != TypeDescKind.TYPE_REFERENCE || !hasError)) {
                    Utils.reportDiagnostics(this.ctx, CompilationErrors.INVALID_PARAMETER_0_PROVIDED_FOR_1_FUNCTION_EXPECTS_2, (Location)parameterSymbol.getLocation().get(), parameterSymbol.signature(), functionName, PluginConstants.MODULE_PREFIX + "Error");
                    continue;
                }
                if (typeSymbol.typeKind() == TypeDescKind.TYPE_REFERENCE || typeSymbol.typeKind() == TypeDescKind.INTERSECTION || typeSymbol.typeKind() == TypeDescKind.ERROR) continue;
                if (functionName.equals("onBytes") && hasByteArray) {
                    Utils.reportDiagnostics(this.ctx, CompilationErrors.INVALID_PARAMETER_0_PROVIDED_FOR_1_FUNCTION_EXPECTS_2, (Location)parameterSymbol.getLocation().get(), parameterSymbol.signature(), functionName, "readonly & byte[]");
                    continue;
                }
                Utils.reportDiagnostics(this.ctx, CompilationErrors.INVALID_PARAMETER_0_PROVIDED_FOR_1_FUNCTION, (Location)parameterSymbol.getLocation().get(), parameterSymbol.signature(), functionName);
            }
        }
    }

    private boolean hasValidParameterCount(int parameterCount, String functionName) {
        if (functionName.equals("onBytes") && parameterCount > 2) {
            Utils.reportDiagnostics(this.ctx, CompilationErrors.PROVIDED_0_PARAMETERS_1_CAN_HAVE_ONLY_2_PARAMETERS, (Location)this.onBytesFunctionSymbol.getLocation().get(), parameterCount, functionName, 2);
            return false;
        }
        if (functionName.equals("onError") && parameterCount > 1) {
            Utils.reportDiagnostics(this.ctx, CompilationErrors.PROVIDED_0_PARAMETERS_1_CAN_HAVE_ONLY_2_PARAMETERS, (Location)this.onErrorFunctionSymbol.getLocation().get(), parameterCount, functionName, 1);
            return false;
        }
        if (functionName.equals("onClose") && parameterCount > 0) {
            Utils.reportDiagnostics(this.ctx, CompilationErrors.PROVIDED_0_PARAMETERS_ON_CLOSE_FUNCTION_CANNOT_HAVE_ANY_PARAMETERS, (Location)this.onCloseFunctionSymbol.getLocation().get(), parameterCount, functionName, 2);
            return false;
        }
        return true;
    }

    private void validateFunctionReturnTypeDesc(MethodSymbol methodSymbol, String functionName) {
        Location returnTypeSymbolLocation;
        Optional typeSymbol = methodSymbol.typeDescriptor().returnTypeDescriptor();
        if (typeSymbol.isEmpty()) {
            return;
        }
        TypeSymbol returnTypeSymbol = (TypeSymbol)typeSymbol.get();
        if (functionName.equals("onBytes") && returnTypeSymbol.typeKind() == TypeDescKind.ARRAY && Utils.equals(returnTypeSymbol.signature(), "byte[]")) {
            return;
        }
        if (returnTypeSymbol.typeKind() == TypeDescKind.NIL) {
            return;
        }
        boolean hasInvalidUnionTypeDesc = false;
        boolean isUnionTypeDesc = false;
        boolean isOptionalError = false;
        if ((functionName.equals("onError") || functionName.equals("onClose")) && returnTypeSymbol.typeKind() == TypeDescKind.UNION) {
            isUnionTypeDesc = true;
            for (TypeSymbol symbol : ((UnionTypeSymbol)typeSymbol.get()).memberTypeDescriptors()) {
                if (symbol.typeKind() == TypeDescKind.TYPE_REFERENCE && symbol.signature().startsWith(PluginConstants.MODULE_PREFIX) && symbol.signature().endsWith(SyntaxKind.COLON_TOKEN.stringValue() + "Error")) continue;
                if (symbol.typeKind() == TypeDescKind.NIL) {
                    isOptionalError = true;
                    continue;
                }
                hasInvalidUnionTypeDesc = true;
                break;
            }
            hasInvalidUnionTypeDesc = !isOptionalError || hasInvalidUnionTypeDesc;
        } else if (functionName.equals("onBytes") && returnTypeSymbol.typeKind() == TypeDescKind.UNION) {
            isUnionTypeDesc = true;
            for (TypeSymbol symbol : ((UnionTypeSymbol)typeSymbol.get()).memberTypeDescriptors()) {
                if (symbol.typeKind() == TypeDescKind.ARRAY && Utils.equals(symbol.signature(), "byte[]") || symbol.typeKind() == TypeDescKind.TYPE_REFERENCE && symbol.signature().startsWith(PluginConstants.MODULE_PREFIX) && symbol.signature().endsWith(SyntaxKind.COLON_TOKEN.stringValue() + "Error") || symbol.typeKind() == TypeDescKind.NIL) continue;
                hasInvalidUnionTypeDesc = true;
                break;
            }
        }
        Location location = returnTypeSymbolLocation = returnTypeSymbol.getLocation().isPresent() ? (Location)returnTypeSymbol.getLocation().get() : (Location)methodSymbol.getLocation().get();
        if (hasInvalidUnionTypeDesc || !isUnionTypeDesc) {
            if (functionName.equals("onBytes")) {
                Utils.reportDiagnostics(this.ctx, CompilationErrors.INVALID_RETURN_TYPE_0_FUNCTION_1_RETURN_TYPE_SHOULD_BE_A_SUBTYPE_OF_2, returnTypeSymbolLocation, returnTypeSymbol.signature(), functionName, "byte[]|" + PluginConstants.MODULE_PREFIX + "Error?");
            } else {
                Utils.reportDiagnostics(this.ctx, CompilationErrors.INVALID_RETURN_TYPE_0_FUNCTION_1_RETURN_TYPE_SHOULD_BE_A_SUBTYPE_OF_2, returnTypeSymbolLocation, returnTypeSymbol.signature(), functionName, PluginConstants.MODULE_PREFIX + "Error|()");
            }
        }
    }
}

